<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Volunteer_Widget extends Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'swiftcart-volunteer-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return esc_html__('Volunteer', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls()
	{

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'swiftcart-core'),
					'layout_two' => __('Layout Two', 'swiftcart-core'),
					'layout_three' => __('Layout Three', 'swiftcart-core'),
				]
			]
		);

		$this->end_controls_section();

		/*
		* content
		*/
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__('Content', 'swiftcart-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label' => __('Title', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Title', 'swiftcart-core'),
				'default' => esc_html__('Add Title', 'swiftcart-core'),
			]
		);

		$this->add_control(
			'sub_title',
			[
				'label' => __('Sub Title', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Sub Title', 'swiftcart-core'),
				'default' => esc_html__('Add Sub Title', 'swiftcart-core'),
			]
		);

		$this->add_control(
			'summary',
			[
				'label' => __('Summary', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Summary', 'swiftcart-core'),
				'default' => esc_html__('Add Summary', 'swiftcart-core'),
			]
		);

		$this->end_controls_section();


		/*
		* Images
		*/
		$this->start_controls_section(
			'images',
			[
				'label' => esc_html__('Images', 'swiftcart-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
				'condition'  => [
					'layout_type' => 'layout_one'
				]
			]
		);


		$this->add_control(
			'shape_one',
			[
				'label' => __('Background Shape Left Top', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => []
			]
		);

		$this->add_control(
			'shape_two',
			[
				'label' => __('Background Shape Left Down', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => []
			]
		);

		$this->add_control(
			'shape_three',
			[
				'label' => __('Background Shape Right Top', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => []
			]
		);

		$this->add_control(
			'shape_four',
			[
				'label' => __('Background Shape Right Down', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => []
			]
		);

		$this->end_controls_section();


		/*
		* Post Options
		*/
		$this->start_controls_section(
			'post_options',
			[
				'label' => esc_html__('Post Options', 'swiftcart-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'post_count',
			[
				'label' => __('Number Of Posts', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['count'],
				'range' => [
					'count' => [
						'min' => 0,
						'max' => 8,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'count',
					'size' => 4,
				],
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'   => esc_html__('Order by', 'swiftcart-core'),
				'type'    => Controls_Manager::SELECT2,
				'options' => array(
					'author' => esc_html__('Author', 'swiftcart-core'),
					'title'  => esc_html__('Title', 'swiftcart-core'),
					'date'   => esc_html__('Date', 'swiftcart-core'),
					'rand'   => esc_html__('Random', 'swiftcart-core'),
				),
				'default' => 'date'

			]
		);

		$this->add_control(
			'order',
			[
				'label'   => esc_html__('Order', 'swiftcart-core'),
				'type'    => Controls_Manager::SELECT2,
				'options' => array(
					'desc' => esc_html__('DESC', 'swiftcart-core'),
					'asc'  => esc_html__('ASC', 'swiftcart-core'),
				),
				'default' => 'desc'

			]
		);

		$this->add_control(
			'post-offset',
			[
				'label'       => esc_html__('Post Offset', 'swiftcart-core'),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__('How Many Post You Offset', 'swiftcart-core'),
				'default'     => esc_html__('0', 'swiftcart-core')
			]
		);

		$this->end_controls_section();

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		swiftcart_core_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title h3', ['layout_one', 'layout_two', 'layout_three']);
		swiftcart_core_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title .section-title__subtitle', ['layout_one', 'layout_two', 'layout_three']);
		swiftcart_core_elementor_general_style_options($this, 'Section Summary', '{{WRAPPER}} .section-title p', ['layout_one', 'layout_two', 'layout_three']);

		swiftcart_core_elementor_general_style_options($this, 'Volunteer Name', '{{WRAPPER}} .valunteer-item__designation h5, {{WRAPPER}} .valunteer-two-item .valunteer-two-item__des h5, {{WRAPPER}} .valunteer-item--three .valunteer-item__designation h4', ['layout_one', 'layout_two', 'layout_three']);
		swiftcart_core_elementor_general_style_options($this, 'Volunteer Designation', '{{WRAPPER}} .valunteer-item__designation span, {{WRAPPER}} .valunteer-two-item .valunteer-two-item__des span, {{WRAPPER}} .valunteer-item--three .valunteer-item__designation span', ['layout_one', 'layout_two', 'layout_three']);



		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		global $post;
		$post_query = new \WP_Query(array('post_type' => 'volunteer', 'order' => $settings['order'], 'orderby', $settings['orderby'], 'posts_per_page' => $settings['post_count']['size'], 'offset' => $settings['post-offset']));
		include swiftcart_get_template('volunteer-one.php');
		include swiftcart_get_template('volunteer-two.php');
		include swiftcart_get_template('volunteer-three.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Volunteer_Widget());
