<?php

/**
 *
 * @package swiftcart
 */
if (!defined('ABSPATH')) {
  exit(); //exit if access directly
}



if (!function_exists('swiftcart_core_post_query')) {
  function swiftcart_core_post_query($post_type)
  {
    $post_list = get_posts(array(
      'post_type' => $post_type,
      'showposts' => -1,
    ));
    $posts = array();

    if (!empty($post_list) && !is_wp_error($post_list)) {
      foreach ($post_list as $post) {
        $options[$post->ID] = $post->post_title;
      }
      return $options;
    }
  }
}

function swiftcart_core_taxonomies_list($taxonom_name)
{

  $args = array(
    'taxonomy' => $taxonom_name,
    'hide_empty' => false,
  );

  $categories = get_categories($args);

  $options = array();

  foreach ($categories as $category) {
    $options[$category->slug] = $category->name;
  }

  return  $options;
}

/**
 *  Taxonomy List
 * @return array
 */
function swiftcart_core_taxonomy_list($taxonomy = 'category')
{
  $terms = get_terms(array(
    'taxonomy' => $taxonomy,
    'hide_empty' => false,
  ));
  if (!empty($terms) && !is_wp_error($terms)) {
    foreach ($terms as $term) {
      $options[$term->slug] = $term->name;
    }
    return $options;
  }
}



function swiftcart_core_get_project_cat_name($slug)
{
  $term = get_term_by('slug', $slug, 'project_cat');
  $name = $term->name;
  return $name;
}


//select tag
function swiftcart_core_post_tag($post_tag = 'post_tag')
{

  $terms = get_terms(array(
    'taxonomy'       => $post_tag,
    'hide_empty'     => false,
    'posts_per_page' => -1,
  ));

  $tag_list = [];
  foreach ($terms as $post) {
    $tag_list[$post->slug] = [$post->name];
  }

  return $tag_list;
}

function swiftcart_core_property_cat($cat_id)
{
  $cat_id   = (int) $cat_id;
  $category = get_term($cat_id, 'property_status');

  if (!$category || is_wp_error($category)) {
    return '';
  }

  return $category->name;
}
function swiftcart_core_property_tag($cat_id)
{
  $cat_id   = (int) $cat_id;
  $tag = get_term($cat_id, 'property_cat');

  if (!$tag || is_wp_error($tag)) {
    return '';
  }

  return $tag->name;
}
function swiftcart_core_property_tags($cat_id)
{
  $cat_id   = (int) $cat_id;
  $tag = get_term($cat_id, 'property_tag');

  if (!$tag || is_wp_error($tag)) {
    return '';
  }

  return $tag->name;
}

function swiftcart_core_nav_menu()
{
  $menu_list = get_terms(array(
    'taxonomy' => 'nav_menu',
    'hide_empty' => true,
  ));
  $options = [];
  if (!empty($menu_list) && !is_wp_error($menu_list)) {
    foreach ($menu_list as $menu) {
      $options[$menu->slug] = $menu->name;
    }
    return $options;
  }
}

function swiftcart_core_get_thumbnail_alt($thumbnail_id)
{
  return get_post_meta($thumbnail_id, '_wp_attachment_image_alt', true);
}




// custom kses allowed html
if (!function_exists('swiftcart_core_allowed_tags')) :
  function swiftcart_core_allowed_tags($tags, $context)
  {
    switch ($context) {
      case 'swiftcart_core_allowed_tags':
        $tags = array(
          'a' => array('href' => array(), 'class' => array()),
          'b' => array(),
          'br' => array(),
          'span' => array('class' => array(), 'data-count' => array()),
          'img' => array('class' => array()),
          'i' => array('class' => array()),
          'p' => array('class' => array()),
          'ul' => array('class' => array()),
          'li' => array('class' => array()),
          'div' => array('class' => array()),
          'strong' => array()
        );
        return $tags;
      default:
        return $tags;
    }
  }

  add_filter('wp_kses_allowed_html', 'swiftcart_core_allowed_tags', 10, 2);

endif;


if (!function_exists('swiftcart_get_template')) :
  function swiftcart_get_template($template_name = null)
  {
    $template_path = apply_filters('swiftcart-elementor/template-path', 'elementor-templates/');
    $template = locate_template($template_path . $template_name);
    if (!$template) {
      $template = SWIFTCART_CORE_ELEMENTOR  . '/templates/' . $template_name;
    }
    if (file_exists($template)) {
      return $template;
    } else {
      return false;
    }
  }
endif;

if (!function_exists('swiftcart_get_elementor_option')) :
  function swiftcart_get_elementor_option($template_name = null)
  {
    $template_path = apply_filters('swiftcart-elementor/template-options', 'elementor-options/');
    $template = locate_template($template_path . $template_name);
    if (!$template) {
      $template = SWIFTCART_CORE_ELEMENTOR  . '/template-options/' . $template_name;
    }
    if (file_exists($template)) {
      return $template;
    }
  }
endif;



add_action('swiftcart_after_tags', 'swiftcart_core_next_prev_post');
function swiftcart_core_next_prev_post()
{ ?>
  <div class="prev-next-post">
    <div class="row">
      <?php
      $swiftcart_prev_post = get_previous_post();
      if (!empty($swiftcart_prev_post)) :
      ?>
        <div class="col-6">
          <a class="btn btn-base" href="<?php echo esc_url(get_permalink($swiftcart_prev_post->ID)); ?>">
            <?php esc_html_e('Prev post', 'swiftcart'); ?></a>
        </div>
      <?php endif; ?>
      <?php
      $swiftcart_next_post = get_next_post();
      if (!empty($swiftcart_next_post)) :
      ?>
        <div class="text-end <?php echo esc_attr((!empty($swiftcart_prev_post) ? 'col-6' : 'col-12')); ?>">
          <a class="btn btn-base" href="<?php echo esc_url(get_permalink($swiftcart_next_post->ID)); ?>"> <?php esc_html_e('Next post', 'swiftcart'); ?></a>
        </div>
      <?php endif; ?>
    </div>
  </div>
  <?php
}


add_action('swiftcart_beside_tags', 'swiftcart_core_social_icon');
function swiftcart_core_social_icon()
{
  if (swiftcart_get_option('social_share', false) == 1) :
    global $post;
    //get current page url
    $swiftcart_url = urlencode_deep(get_permalink());
    //get current page title
    $swiftcart_title = str_replace(' ', '%20', get_the_title($post->ID));
    //get post thumbnail for pinterest
    $swiftcart_thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');

    //all social share link generate
    $facebook_share_link = 'https://www.facebook.com/sharer/sharer.php?u=' . $swiftcart_url;
    $twitter_share_link = 'https://twitter.com/intent/tweet?text=' . $swiftcart_title . '&amp;url=' . $swiftcart_url . '&amp;via=Crunchify';
    $linkedin_share_link = 'https://www.linkedin.com/shareArticle?mini=true&url=' . $swiftcart_url . '&amp;title=' . $swiftcart_title;
    $pinterest_share_link = 'https://pinterest.com/pin/create/button/?url=' . $swiftcart_url . '&amp;media=' . $swiftcart_thumbnail[0] . '&amp;description=' . $swiftcart_title;

  ?>
    <div class="col-sm-5 mt-3 mt-sm-0 text-sm-end align-self-center">
      <div class="blog-share">
        <ul>
          <li><a target="_blank" href="<?php echo esc_url($facebook_share_link); ?>"><i class="fab fa-facebook-f" aria-hidden="true"></i></a></li>
          <li><a target="_blank" href="<?php echo esc_url($twitter_share_link); ?>"><i class="fab fa-twitter" aria-hidden="true"></i></a></li>
          <li><a target="_blank" href="<?php echo esc_url($pinterest_share_link); ?>"><i class="fab fa-pinterest" aria-hidden="true"></i></a></li>
          <li><a target="_blank" href="<?php echo esc_url($linkedin_share_link); ?>"><i class="fab fa-linkedin" aria-hidden="true"></i></a></li>
        </ul>
      </div>
    </div>
  <?php
  endif;
}

if (!function_exists('swiftcart_core__blog_addon_social_icon')) :
  function swiftcart_core__blog_addon_social_icon()
  {
    global $post;
    //get current page url
    $swiftcart_url = urlencode_deep(get_permalink());
    //get current page title
    $swiftcart_title = str_replace(' ', '%20', get_the_title($post->ID));
    //get post thumbnail for pinterest
    $swiftcart_thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');
    //all social share link generate
    $facebook_share_link = 'https://www.facebook.com/sharer/sharer.php?u=' . $swiftcart_url;
    $twitter_share_link = 'https://twitter.com/intent/tweet?text=' . $swiftcart_title . '&amp;url=' . $swiftcart_url . '&amp;via=Crunchify';
    $pinterest_share_link = 'https://pinterest.com/pin/create/button/?url=' . $swiftcart_url . '&amp;media=' . $swiftcart_thumbnail[0] . '&amp;description=' . $swiftcart_title;
  ?>
    <div class="share-hover-icons">
      <ul>
        <li><a target="_blank" href="<?php echo esc_url($facebook_share_link); ?>"><i class="fab fa-facebook-f"></i></a></li>
        <li><a target="_blank" href="<?php echo esc_url($twitter_share_link); ?>"><i class="fab fa-twitter"></i></a></li>
        <li><a target="_blank" href="<?php echo esc_url($pinterest_share_link); ?>"><i class="fab fa-pinterest"></i></a></li>
      </ul>
    </div>
  <?php
  }
endif;
/*
*  header builder
*/
if (!function_exists('swiftcart_get_header_builder_library')) :
  function swiftcart_get_header_builder_library()
  {

    $pageslist = get_posts(array(
      'post_type'      => 'header-builder',
      'posts_per_page' => -1
    ));

    $pagearray = array();
    if (!empty($pageslist)) {
      foreach ($pageslist as $page) {
        $pagearray[$page->ID] = $page->post_title;
      }
    }

    return $pagearray;
  }

endif;


/*
*  header builder
*/
if (!function_exists('swiftcart_get_footer_builder_library')) :
  function swiftcart_get_footer_builder_library()
  {

    $pageslist = get_posts(array(
      'post_type'      => 'footer-builder',
      'posts_per_page' => -1
    ));

    $pagearray = array();
    if (!empty($pageslist)) {
      foreach ($pageslist as $page) {
        $pagearray[$page->ID] = $page->post_title;
      }
    }

    return $pagearray;
  }
endif;

if (!function_exists('swiftcart_excerpt')) :
  // Post excerpt
  function swiftcart_excerpt($get_limit_value = 40, $echo = true)
  {
    $opt = $get_limit_value;
    $excerpt_limit = !empty($opt) ? $opt : 40;
    $excerpt = wp_trim_words(get_the_content(), $excerpt_limit, '');
    if ($echo == true) {
      echo esc_html($excerpt);
    } else {
      return esc_html($excerpt);
    }
  }
endif;

if (!function_exists('swiftcart_posted_by')) :
  /**
   * Prints HTML with meta information for the current author.
   */
  function swiftcart_posted_by()
  {
    $byline = sprintf(
      /* translators: %s: post author. */
      esc_html_x('%s', 'post author', 'swiftcart'), // phpcs:ignore WordPress.WP.I18n.NoEmptyStrings
      '<span class="author vcard"><a class="url fn n" href="' . esc_url(get_author_posts_url(get_the_author_meta('ID'))) . '">' . esc_html(get_the_author()) . '</a></span>'
    );

    echo '<span class="byline"> ' . $byline . '</span>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

  }
endif;


if (!function_exists('swiftcart_posted_on')) :
  /**
   * Prints HTML with meta information for the current post-date/time.
   */
  function swiftcart_posted_on()
  {
    $time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
    if (get_the_time('U') !== get_the_modified_time('U')) {
      $time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
    }

    $time_string = sprintf(
      $time_string,
      esc_attr(get_the_date(DATE_W3C)),
      esc_html(get_the_date()),
      esc_attr(get_the_modified_date(DATE_W3C)),
      esc_html(get_the_modified_date())
    );

    $posted_on = sprintf(
      /* translators: %s: post date. */
      esc_html_x('%s', 'post date', 'swiftcart'),
      '<a href="' . esc_url(get_permalink()) . '" rel="bookmark">' . $time_string . '</a>'
    );

    echo '<span class="date"><i aria-hidden="true" class=" icomoon-calendar-2"></i> ' . $posted_on . '</span>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

  }
endif;

// add_filter('pt-ocdi/plugin_page_setup', 'swiftcart_core_import_page_setup');
function swiftcart_core_import_page_setup($default_settings)
{
  $default_settings['parent_slug'] = 'swiftcart-theme-option';
  $default_settings['page_title']  = esc_html__('Demo import', 'swiftcart-core');
  $default_settings['menu_title']  = esc_html__('Demo import', 'swiftcart-core');
  $default_settings['capability']  = 'import';
  $default_settings['menu_slug']   = 'demo';

  return $default_settings;
}


add_filter('body_class',  'swiftcart_core_body_classes');
/**
 * swiftcart_core_body_classes
 * @since 1.0.0
 * */
if (!function_exists('swiftcart_core_body_classes')) :
  function swiftcart_core_body_classes($classes)
  {

    $classes[] = 'swiftcart-core';


    return $classes;
  }
endif;

if (!function_exists('swiftcart_page_header_extra_class_callback')) :
  function swiftcart_page_header_extra_class_callback($class)
  {
    return '';
  }
endif;
add_filter('swiftcart_page_header_extra_class', 'swiftcart_page_header_extra_class_callback', 10, 1);

if (!function_exists('swiftcart_body_classes')) :
  function swiftcart_body_classes($classes)
  {

    if (is_page()) {

      $swiftcart_body_class =  get_post_meta(get_queried_object_id(), 'swiftcart_page_meta', true);
      $swiftcart_body_class = isset($swiftcart_body_class['header_extra_class']) ? $swiftcart_body_class['header_extra_class'] : '';

      if (!empty($swiftcart_body_class)) {
        $classes[] = $swiftcart_body_class;
      }
    }


    return $classes;
  }
endif;

add_filter('body_class', 'swiftcart_body_classes');


if (!function_exists('swiftcart_core_typo_and_color_options')) :
  function swiftcart_core_typo_and_color_options($agrs, $label, $selector, $condition, $style = 'color', $typo = true, $color = true)
  {
    if (!function_exists('swiftcart_core_elementor_general_style_options')) :
      function swiftcart_core_elementor_general_style_options($agrs, $label, $selector, $condition, $style = 'color', $typo = true, $color = true)
      {

        //Label
        $agrs->add_control(
          str_replace(' ', '_', $label) . '_subtitle',
          [
            'type' => \Elementor\Controls_Manager::HEADING,
            'label' => __($label, 'swiftcart-core'),
            'separator' => 'after',
            'condition' => [
              'layout_type' => $condition
            ]
          ]
        );

        $agrs->add_responsive_control(
          str_replace(' ', '_', $label) . '_padding',
          [
            'label' => __(' Padding', 'swiftcart-core'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'selectors' => [
              $selector => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'condition' => [
              'layout_type' => $condition
            ]
          ]
        );

        $agrs->add_responsive_control(
          str_replace(' ', '_', $label) . '_margin',
          [
            'label' => __(' Margin', 'swiftcart-core'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'selectors' => [
              $selector => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'condition' => [
              'layout_type' => $condition
            ]
          ]
        );

        if ($typo) :
          $agrs->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
              'name'           =>  str_replace(' ', '_', $label) . '_typo',
              'label'          => esc_html__(' Typography', 'swiftcart-core'),
              'selector'       => $selector,
              'condition' => [
                'layout_type' => $condition
              ]
            ]
          );

        endif;
        if ($color) :
          $agrs->add_control(
            str_replace(' ', '_', $label) . '_color',
            [
              'label' => __('Color', 'swiftcart-core'),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                $selector => $style . ': {{VALUE}}',
              ],
              'condition' => [
                'layout_type' => $condition
              ]
            ]
          );
        endif;
      }
    endif;

    if (false != $typo) :
      //title typography
      $agrs->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name'           =>  str_replace(' ', '_', $label) . '_typo',
          'label'          => esc_html__($label . ' Typography', 'swiftcart-core'),
          'selector'       => $selector,
          'condition' => [
            'layout_type' => $condition
          ]
        ]
      );

    endif;

    if (false != $color) :
      $agrs->add_control(
        str_replace(' ', '_', $label) . '_color',
        [
          'label' => __($label . ' Color', 'swiftcart_core'),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            $selector => $style . ': {{VALUE}}',
          ],
          'condition' => [
            'layout_type' => $condition
          ]
        ]
      );
    endif;
  }
endif;


if (!function_exists('swiftcart_core_elementor_general_style_options')) :
  function swiftcart_core_elementor_general_style_options($agrs, $label, $selector, $condition, $style = 'color', $typo = true, $color = true)
  {

    //Label
    $agrs->add_control(
      str_replace(' ', '_', $label) . '_subtitle',
      [
        'type' => \Elementor\Controls_Manager::HEADING,
        'label' => __($label, 'swiftcart_core'),
        'separator' => 'after',
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    $agrs->add_responsive_control(
      str_replace(' ', '_', $label) . '_padding',
      [
        'label' => __(' Padding', 'swiftcart_core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', 'em', '%'],
        'selectors' => [
          $selector => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    $agrs->add_responsive_control(
      str_replace(' ', '_', $label) . '_margin',
      [
        'label' => __(' Margin', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', 'em', '%'],
        'selectors' => [
          $selector => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    if ($typo) :
      $agrs->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name'           =>  str_replace(' ', '_', $label) . '_typo',
          'label'          => esc_html__(' Typography', 'swiftcart-core'),
          'selector'       => $selector,
          'condition' => [
            'layout_type' => $condition
          ]
        ]
      );

    endif;
    if ($color) :
      $agrs->add_control(
        str_replace(' ', '_', $label) . '_color',
        [
          'label' => __('Color', 'swiftcart-core'),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            $selector => $style . ': {{VALUE}}',
          ],
          'condition' => [
            'layout_type' => $condition
          ]
        ]
      );
    endif;
  }
endif;

if (!function_exists('swiftcart_core_elementor_link_style_options')) :
  function swiftcart_core_elementor_link_style_options($agrs, $label, $selector, $hoverSelector, $condition, $style = 'color', $typo = true, $color = true)
  {

    //Label
    $agrs->add_control(
      str_replace(' ', '_', $label) . '_subtitle',
      [
        'type' => \Elementor\Controls_Manager::HEADING,
        'label' => __($label, 'swiftcart_core'),
        'separator' => 'after',
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    $agrs->add_responsive_control(
      str_replace(' ', '_', $label) . '_padding',
      [
        'label' => __(' Padding', 'swiftcart_core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', 'em', '%'],
        'selectors' => [
          $selector => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    $agrs->add_responsive_control(
      str_replace(' ', '_', $label) . '_margin',
      [
        'label' => __(' Margin', 'swiftcart_core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', 'em', '%'],
        'selectors' => [
          $selector => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    if ($typo) :
      $agrs->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name'           =>  str_replace(' ', '_', $label) . '_typo',
          'label'          => esc_html__(' Typography', 'swiftcart_core'),
          'selector'       => $selector,
          'condition' => [
            'layout_type' => $condition
          ]
        ]
      );

    endif;

    $agrs->start_controls_tabs(str_replace(' ', '_', $label) . '_tabs_link');

    $agrs->start_controls_tab(
      str_replace(' ', '_', $label) . '_tab_link_normal',
      [
        'label' => __('Normal', 'swiftcart_core'),
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    $agrs->add_control(
      str_replace(' ', '_', $label) . '_color',
      [
        'label' => __('Color', 'swiftcart_core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '',
        'selectors' => [
          $selector => 'color: {{VALUE}};',
        ],
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );
    $agrs->end_controls_tab();
    $agrs->start_controls_tab(
      str_replace(' ', '_', $label) . '_tab_button_hover',
      [
        'label' => __('Hover', 'swiftcart_core'),
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    $agrs->add_control(
      str_replace(' ', '_', $label) . '_hover_color',
      [
        'label' => __('Color', 'swiftcart_core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          $hoverSelector . ':hover' => 'color: {{VALUE}};',
        ],
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );
    $agrs->end_controls_tab();
    $agrs->end_controls_tabs();
  }
endif;

if (!function_exists('swiftcart_core_elementor_button_style_options')) :

  function swiftcart_core_elementor_button_style_options($init, $label, $selector, $hover_bg_selector = '', $condition = 'layout_one')
  {

    //Label
    $init->add_control(
      str_replace(' ', '_', $label) . '_subtitle_label',
      [
        'type' => \Elementor\Controls_Manager::HEADING,
        'label' => __($label, 'swiftcart-core'),
        'separator' => 'after',
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    $init->add_responsive_control(
      str_replace(' ', '_', $label) . '_padding',
      [
        'label' => __('Padding', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', 'em', '%'],
        'selectors' => [
          $selector => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    $init->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => str_replace(' ', '_', $label) . '_typography',
        'selector' => $selector,
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    $init->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => str_replace(' ', '_', $label) . '_border',
        'selector' => $selector,
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    $init->add_control(
      str_replace(' ', '_', $label) . '_border_radius',
      [
        'label' => __('Border Radius', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
          $selector => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    $init->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => str_replace(' ', '_', $label) . '_box_shadow',
        'selector' => $selector,
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    $init->add_control(
      str_replace(' ', '_', $label) . '_hr',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
        'style' => 'thick',
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    $init->start_controls_tabs(str_replace(' ', '_', $label) . '_tabs_button');

    $init->start_controls_tab(
      str_replace(' ', '_', $label) . '_tab_button_normal',
      [
        'label' => __('Normal', 'swiftcart-core'),
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    $init->add_control(
      str_replace(' ', '_', $label) . '_color',
      [
        'label' => __('Text Color', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '',
        'selectors' => [
          $selector => 'color: {{VALUE}};',
        ],
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    $init->add_control(
      str_replace(' ', '_', $label) . '_bg_color',
      [
        'label' => __('Background Color', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          $selector => 'background-color: {{VALUE}};',
        ],
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    $init->end_controls_tab();

    $init->start_controls_tab(
      str_replace(' ', '_', $label) . '_tab_button_hover',
      [
        'label' => __('Hover', 'swiftcart-core'),
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    $init->add_control(
      str_replace(' ', '_', $label) . '_hover_color',
      [
        'label' => __('Text Color', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          $hover_bg_selector . ':hover,' . $hover_bg_selector . ':focus' => 'color: {{VALUE}};',
        ],
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    $init->add_control(
      str_replace(' ', '_', $label) . '_hover_bg_color',
      [
        'label' => __('Background Color', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          $hover_bg_selector => 'background-color: {{VALUE}};',
        ],
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    $init->add_control(
      str_replace(' ', '_', $label) . '_hover_border_color',
      [
        'label' => __('Border Color', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'button_border_border!' => '',
        ],
        'selectors' => [
          $hover_bg_selector . ':hover,' . $hover_bg_selector . ':focus' => 'border-color: {{VALUE}};',
        ],
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );

    $init->end_controls_tab();
    $init->end_controls_tabs();
  }
endif;



if (!function_exists('swiftcart_elementor_rendered_image')) {
  function swiftcart_elementor_rendered_image($content, $name, $class = '', $duration = '', $delay = '')
  {
    if (empty($content[$name])) {
      return;
    }

    $image = ($content[$name]["id"] != "") ? wp_get_attachment_image_url($content[$name]["id"], "full") : $content[$name]["url"];
    if (empty($image)) {
      return;
    }

    $image_attr = '';
    $title = \Elementor\Control_Media::get_image_title($content[$name]);

    if (!empty($title)) {
      $image_attr .= 'title="' . esc_attr($title) . '" ';
    }

    if (!empty($class)) {
      $image_attr .= 'class="' . esc_attr($class) . '" ';
    }

    if (!empty($duration)) {
      $image_attr .= 'data-wow-duration="' . esc_attr($duration) . '" ';
    }

    if (!empty($delay)) {
      $image_attr .= 'data-wow-delay="' . esc_attr($delay) . '" ';
    }

    printf(
      '<img src="%s" alt="%s" %s>',
      esc_url($image),
      esc_attr(\Elementor\Control_Media::get_image_alt($content[$name])),
      $image_attr
    );
  }
}

if (!function_exists('swiftcart_elementor_heading_option')) :
  function swiftcart_elementor_heading_option($init, $label, $default = 'h2', $layout = '')
  {
    $init->add_control(
      str_replace(' ', '_', strtolower($label)) . '_tag_' . $layout,
      [
        'label' => esc_html__($label . ' Tag', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'label_block' => true,
        'options' => array(
          'h1'   => 'H1',
          'h2'   => 'H2',
          'h3'   => 'H3',
          'h4'   => 'H4',
          'h5'   => 'H5',
          'h6'   => 'H6',
          'div'  => 'div',
          'span' => 'span',
          'p'    => 'p',
        ),
        'default' => $default,
      ]
    );
  }
endif;

if (!function_exists('swiftcart_elementor_rendered_content')) :
  function swiftcart_elementor_rendered_content($init, $rendered_name, $class = '', $tag = 'p', $url_name = 'url', $extra = '')
  {

    $settings = $init->get_settings_for_display();


    if ('a' == $tag) :
      $init->add_render_attribute($rendered_name, [
        'class' => 'swiftcart-inline-editing'
      ]);
    else :
      $init->add_render_attribute($rendered_name, [
        'class' => $class,
      ]);
    endif;

    if ('a' == $tag) :
      printf(
        '<%1$s %7$s %3$s %4$s><em %2$s>%5$s</em> %6$s</%1$s>',
        tag_escape($tag),
        $init->get_render_attribute_string($rendered_name),
        'href="' . esc_url($settings[$url_name]['url']) . '"',
        esc_attr(!empty($settings[$url_name]['is_external']) ? "target=_blank" : ' '),
        wp_kses($settings[$rendered_name], 'swiftcart_core_allowed_tags'),
        $extra,
        'class="' . esc_attr($class) . '"'
      );
    else :
      printf(
        '<%1$s %2$s>%3$s</%1$s>',
        tag_escape($tag),
        $init->get_render_attribute_string($rendered_name),
        wp_kses($settings[$rendered_name], 'swiftcart_core_allowed_tags')
      );
    endif;
  }

endif;
if (!function_exists('swiftcart_elementor_repeater_rendered_content')) :
  function swiftcart_elementor_repeater_rendered_content($init, $content, $key, $rendered_name, $class = 'swiftcart-default', $tag = 'p', $url_name = 'url', $extra = '')
  {
    if ('a' == $tag) :
      $init->add_render_attribute(
        $key,
        [
          'class' => 'swiftcart-inline-editing'
        ]
      );
    else :
      $init->add_render_attribute($key, [
        'class' => $class,
      ]);
    endif;


    if ('a' == $tag) :
      printf(
        '<%1$s %7$s %3$s %4$s><em %2$s>%5$s</em> %6$s</%1$s>',
        tag_escape($tag),
        $init->get_render_attribute_string($key),
        'href="' . esc_url($content[$url_name]['url']) . '"',
        esc_attr(!empty($content[$url_name]['is_external']) ? "target=_blank" : ' '),
        wp_kses($content[$rendered_name], 'swiftcart_core_allowed_tags'),
        $extra,
        'class="' . esc_attr($class) . '"'
      );

    else :
      printf(
        '<%1$s %2$s>%3$s</%1$s>',
        tag_escape($tag),
        $init->get_render_attribute_string($key),
        wp_kses($content[$rendered_name], 'swiftcart_core_allowed_tags')
      );
    endif;
  }

endif;

if (!function_exists('swiftcart_basic_rendered_content')) :
  function swiftcart_basic_rendered_content($init, $content, $rendered_name, $class = 'swiftcart-default', $tag = 'p', $url_name = 'url', $extra = '')
  {

    $init->add_render_attribute($rendered_name, [
      'class' => $class,
    ]);


    if ('a' == $tag) :
      printf(
        '<%1$s %2$s %3$s %4$s>%5$s%6$s</%1$s>',
        tag_escape($tag),
        $init->get_render_attribute_string($rendered_name),
        'href="' . esc_url($content[$url_name]['url']) . '"',
        esc_attr(!empty($content[$url_name]['is_external']) ? "target=_blank" : ' '),
        wp_kses($content[$rendered_name], 'swiftcart_core_allowed_tags'),
        $extra,
      );

    else :
      printf(
        '<%1$s %2$s>%3$s</%1$s>',
        tag_escape($tag),
        $init->get_render_attribute_string($rendered_name),
        wp_kses($content[$rendered_name], 'swiftcart_core_allowed_tags')
      );
    endif;
  }

endif;
if (!function_exists('swiftcart_elementor_column_count_options')) :
  function swiftcart_elementor_column_count_options($init, $condition)
  {
    $init->start_controls_section(
      'column_options',
      [
        'label' => __('Column Options', 'swiftcart-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
          'layout_type' => $condition
        ]
      ]
    );


    $init->add_responsive_control(
      'column_count',
      [
        'label' => __('Column Width %', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'range' => [
          '%' => [
            'min' => 1,
            'max' => 100,
          ],
        ],
        'devices' => ['desktop', 'tablet', 'mobile'],
        'desktop_default' => [
          'unit' => '%',
          'size' => '',
        ],
        'tablet_default' => [
          'unit' => '%',
          'size' => '',
        ],
        'mobile_default' => [
          'unit' => '%',
          'size' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .row [class*=col-]' => 'width: {{SIZE}}% !important;',
        ],
      ]
    );

    $init->end_controls_section();
  }
endif;

/*
*  header builder
*/
if (!function_exists('swiftcart_get_header_builder_library')) :
  function swiftcart_get_header_builder_library()
  {

    $pageslist = get_posts(array(
      'post_type'      => 'header-builder',
      'posts_per_page' => -1
    ));

    $pagearray = array();
    if (!empty($pageslist)) {
      foreach ($pageslist as $page) {
        $pagearray[$page->ID] = $page->post_title;
      }
    }

    return $pagearray;
  }

endif;

if (!function_exists('swiftcart_custom_post_views')) :
  function swiftcart_custom_post_views($postID)
  {
    $key = 'custom_post_views';
    $count = get_post_meta($postID, $key, true);
    $count = ($count == '') ? 1 : $count + 1;
    update_post_meta($postID, $key, $count);
  }
endif;


if (!function_exists('swiftcart_custom_get_post_views')) :
  function swiftcart_custom_get_post_views($postID)
  {
    $key = 'custom_post_views';
    $count = get_post_meta($postID, $key, true);
    $count = ($count == '') ? 0 : $count;
    return $count;
  }

endif;


if (!function_exists('swiftcart_custom_track_post_views')) :
  function swiftcart_custom_track_post_views()
  {
    if (is_single()) {
      global $post;
      if (empty($post)) return;
      swiftcart_custom_post_views($post->ID);
    }
  }
  add_action('wp_head', 'swiftcart_custom_track_post_views');
endif;


/*
*  header builder
*/
if (!function_exists('swiftcart_get_footer_builder_library')) :
  function swiftcart_get_footer_builder_library()
  {

    $pageslist = get_posts(array(
      'post_type'      => 'footer-builder',
      'posts_per_page' => -1
    ));

    $pagearray = array();
    if (!empty($pageslist)) {
      foreach ($pageslist as $page) {
        $pagearray[$page->ID] = $page->post_title;
      }
    }

    return $pagearray;
  }
endif;


if (!function_exists('swiftcart_get_taxonoy')) :
  function swiftcart_get_taxonoy($taxonoy)
  {
    $taxonomy_list = get_terms(array(
      'taxonomy' => $taxonoy,
      'hide_empty' => true,
    ));
    $options = [];
    if (!empty($taxonomy_list) && !is_wp_error($taxonomy_list)) {
      foreach ($taxonomy_list as $taxonomy) {
        $options[$taxonomy->slug] = $taxonomy->name;
      }
      return $options;
    }
  }
endif;


if (!function_exists('swiftcart_core_get_elementor_carousel_options')) :
  function swiftcart_core_get_elementor_carousel_options($arg, $condition = false)
  {

    if (!empty($condition)) :
      $arg->start_controls_section(
        'slider_options',
        [
          'label' => __('Slider Options', 'agrofa-addon'),
          'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
          'condition' => [
            'layout_type' => $condition
          ]
        ]
      );
    else :
      $arg->start_controls_section(
        'slider_options',
        [
          'label' => __('Slider Options', 'agrofa-addon'),
          'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
    endif;


    $arg->add_control(
      'autoplay',
      [
        'label' => esc_html__('AutoPlay', 'agrofa-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'agrofa-addon'),
        'label_off' => esc_html__('No', 'agrofa-addon'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );

    $arg->add_control(
      'delay',
      [
        'label' => __('AutoPlay Delay', 'agrofa-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],

        'range' => [
          'count' => [
            'min' => 0,
            'max' => 10000,
            'step' => 1,
          ],
        ],
        'default' => [
          'unit' => 'count',
          'size' => 5000,
        ],
      ]
    );

    $arg->add_control(
      'custom_animation_status',
      [
        'label' => esc_html__('Enable Custom Animation?', 'agrofa-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'agrofa-addon'),
        'label_off' => esc_html__('No', 'agrofa-addon'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );

    $arg->add_control(
      'custom_animation_out',
      [
        'label' => esc_html__('Out Animation Class Name', 'agrofa-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'custom_animation_status' => 'yes'
        ],
        'label_block' => true,
      ]
    );

    $arg->add_control(
      'custom_animation_in',
      [
        'label' => esc_html__('In Animation Class Name', 'agrofa-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'custom_animation_status' => 'yes'
        ],
        'label_block' => true,
      ]
    );

    $arg->add_control(
      'hover_pause',
      [
        'label' => __('AutoPlay On Hover', 'pifoxen-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'pifoxen-addon'),
        'label_off' => esc_html__('No', 'pifoxen-addon'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );

    $arg->add_control(
      'loop',
      [
        'label' => esc_html__('Loop', 'agrofa-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'agrofa-addon'),
        'label_off' => esc_html__('No', 'agrofa-addon'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );

    $arg->add_control(
      'enable_nav',
      [
        'label' => esc_html__('Display Nav', 'agrofa-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'agrofa-addon'),
        'label_off' => esc_html__('No', 'agrofa-addon'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );

    $arg->add_control(
      'nav_left_icon',
      [
        'label' => esc_html__('Nav Left Icon', 'agrofa-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'condition' => [
          'enable_nav' => 'yes'
        ],
        'default' => [
          'value' => 'fas fa-arrow-left',
          'library' => 'solid',
        ],
      ]
    );

    $arg->add_control(
      'nav_right_icon',
      [
        'label' => esc_html__('Nav Right Icon', 'agrofa-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'condition' => [
          'enable_nav' => 'yes'
        ],
        'default' => [
          'value' => 'fas fa-arrow-right',
          'library' => 'solid',
        ],
      ]
    );

    $arg->add_control(
      'enable_dots',
      [
        'label' => esc_html__('Display Dots', 'agrofa-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'agrofa-addon'),
        'label_off' => esc_html__('No', 'agrofa-addon'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );


    $arg->add_control(
      'smart_speed',
      [
        'label' => __('Smart Speed', 'agrofa-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],

        'range' => [
          'count' => [
            'min' => 0,
            'max' => 10000,
            'step' => 1,
          ],
        ],
        'default' => [
          'unit' => 'count',
          'size' => 700,
        ],
      ]
    );


    $arg->add_control(
      'items',
      [
        'label' => __('Slide Items', 'agrofa-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],
        'range' => [
          'count' => [
            'min' => 1,
            'max' => 10,
            'step' => 1,
          ],
        ],
        'default' => [
          'unit' => 'count',
          'size' => 1,
        ],
      ]
    );

    $arg->add_control(
      'margin',
      [
        'label' => __('Margin', 'agrofa-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],
        'range' => [
          'count' => [
            'min' => 1,
            'max' => 200,
            'step' => 1,
          ],
        ],
        'default' => [
          'unit' => 'count',
          'size' => 0,
        ],
      ]
    );


    $breakpoint = new \Elementor\Repeater();

    $breakpoint->add_control(
      'screen_size',
      [
        'label' => __('Screen Size', 'agrofa-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],
        'range' => [
          'count' => [
            'min' => 0,
            'max' => 1920,
            'step' => 1,
          ],
        ],
        'default' => [
          'unit' => 'count',
          'size' => 0,
        ],
      ]
    );

    $breakpoint->add_control(
      'item',
      [
        'label' => __('Slide Item', 'agrofa-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],
        'range' => [
          'count' => [
            'min' => 1,
            'max' => 10,
            'step' => 1,
          ],
        ],
        'default' => [
          'unit' => 'count',
          'size' => 1,
        ],
      ]
    );

    $breakpoint->add_control(
      'margin',
      [
        'label' => __('Margin', 'agrofa-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],
        'range' => [
          'count' => [
            'min' => 1,
            'max' => 200,
            'step' => 1,
          ],
        ],
        'default' => [
          'unit' => 'count',
          'size' => 0,
        ],
      ]
    );

    $arg->add_control(
      'breakpoint',
      [
        'label' => __('Breakpoints', 'agrofa-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'prevent_empty' => false,
        'fields' => $breakpoint->get_controls(),
      ]
    );

    $arg->end_controls_section();
  }
endif;

if (!function_exists('swiftcart_core_get_owl_options')) :
  function swiftcart_core_get_owl_options($settings)
  {
    $loop_status = ('yes' == $settings['loop']) ? 'true' : 'false';
    $nav_status = ('yes' == $settings['enable_nav']) ? 'true' : 'false';
    $dots_status = ('yes' == $settings['enable_dots']) ? 'true' : 'false';
    $autoplay_status = ('yes' == $settings['autoplay']) ? 'true' : 'false';
    $hover_pause_status = ('yes' == $settings['hover_pause']) ? 'true' : 'false';
    $delay = $settings['delay']['size'];
    $custom_animation_status = ('yes' == $settings['custom_animation_status']) ? 'true' : 'false';
    $custom_animation_out = $settings['custom_animation_out'];
    $custom_animation_in = $settings['custom_animation_in'];
    if ('yes' == $settings['enable_nav']) {
      $nav_left_icon = $settings['nav_left_icon']['value'];
      $nav_right_icon = $settings['nav_right_icon']['value'];
    }
    $items = $settings['items']['size'];
    $margin = $settings['margin']['size'];
    $smart_speed = $settings['smart_speed']['size'];
    $breakpoint = $settings['breakpoint'];
    ob_start(); ?>
    {
    "loop": <?php echo esc_attr($loop_status) ?>,
    "margin": <?php echo esc_attr($margin) ?>,
    "items": <?php echo esc_attr($items) ?>
    ,"nav": <?php echo esc_attr($nav_status) ?>
    <?php if ('true' == $autoplay_status) : ?>
      ,"autoplay": <?php echo esc_attr($autoplay_status); ?>
      ,"autoplayTimeout": <?php echo esc_attr($delay); ?>
    <?php endif; ?>
    <?php if ('true' == $custom_animation_status) : ?>
      ,"animateOut": "<?php echo esc_attr($custom_animation_out); ?>"
      ,"animateIn": "<?php echo esc_attr($custom_animation_in); ?>"
    <?php endif; ?>
    <?php if ('true' == $hover_pause_status) : ?>
      ,"autoplayHoverPause": <?php echo esc_attr($hover_pause_status); ?>
    <?php endif; ?>
    <?php if ('yes' == $settings['enable_nav']) :  ?>
      ,"navText": [
      "<span class=\" <?php echo esc_attr($nav_left_icon) ?>\"></span>",
      "<span class=\" <?php echo esc_attr($nav_right_icon) ?>\"></span>"
      ]
    <?php endif; ?>
    ,"dots": <?php echo esc_attr($dots_status) ?>
    ,"smartSpeed": <?php echo esc_attr($smart_speed) ?>

    <?php if (!empty($breakpoint)) :  ?>
      ,
      "responsive":
      {
      <?php foreach ($breakpoint as $item) : ?>
        "<?php echo esc_attr($item['screen_size']['size']); ?>": {
        "margin": <?php echo esc_attr($item['margin']['size']); ?>,
        "items": <?php echo esc_attr($item['item']['size']); ?>
        }<?php echo esc_attr($item != end($breakpoint) ? ',' : ''); ?>
      <?php endforeach; ?>
      }
    <?php endif; ?>
    }
  <?php return ob_get_clean();
  }
endif;

function custom_product_search_query($query)
{
  if ($query->is_search && !is_admin()) {
    // Set the post type to 'product' to only search products
    $query->set('post_type', 'product');

    // Check if a product category is selected
    if (!empty($_GET['product_cat'])) {
      $query->set('tax_query', array(
        array(
          'taxonomy' => 'product_cat',
          'field'    => 'slug',
          'terms'    => sanitize_text_field($_GET['product_cat']),
        ),
      ));
    }
  }
  return $query;
}
add_filter('pre_get_posts', 'custom_product_search_query');
function custom_product_search_form()
{
  // Get all product categories
  $product_categories = get_terms(array(
    'taxonomy'   => 'product_cat',
    'hide_empty' => true,
  ));

  ob_start(); // Start output buffering
  ?>
  <form role="search" method="get" action="<?php echo esc_url(home_url('/')); ?>">
    <input type="search" placeholder="Search" value="<?php echo get_search_query(); ?>" name="s" />
    <select name="product_cat" id="product_cat">
      <option value=""><?php echo esc_html__('All Categories', 'your-text-domain'); ?></option>
      <?php foreach ($product_categories as $category) : ?>
        <option value="<?php echo esc_attr($category->slug); ?>" <?php selected(isset($_GET['product_cat']) ? $_GET['product_cat'] : '', $category->slug); ?>>
          <?php echo esc_html($category->name); ?>
        </option>
      <?php endforeach; ?>
    </select>
    <!-- Hidden input to specify that we are searching for products -->
    <input type="hidden" name="post_type" value="product" />
    <button type="submit"><?php echo esc_attr_x('Search', 'submit button'); ?></button>
  </form>
<?php
  return ob_get_clean(); // Return the buffered content
}
add_shortcode('product_search_form', 'custom_product_search_form');
