<?php
// Control core classes for avoid errors
if (class_exists('CSF')) {
	$swiftcart_allowed_html = 'swiftcart_core_allowed_tags';

	//
	// Set a unique slug-like ID
	$swiftcart_prefix = 'swiftcart';

	//
	// Create options
	CSF::createOptions($swiftcart_prefix . '_theme_options', array(
		'menu_title'      => 'Theme Option',
		'menu_slug'       => 'swiftcart-theme-option',
		'menu_type'       => 'submenu',
		'enqueue_webfont' => true,
		'show_footer'     => false,
		'show_in_customizer'      => false,
		'footer_text'             => '',
		'footer_after'            => '',
		'footer_credit'           => '',
		'show_in_customizer'      => true,
		'framework_title' => 'Swiftcart ' . esc_html__(' Option', 'swiftcart') . ' <small>' . esc_html__('You also find those option in ', 'swiftcart') . '<a href="' . esc_url(admin_url('customize.php')) . '">' . esc_html__('Customizer', 'swiftcart') . '</a> </small>',
	));

	//
	// Create a section
	CSF::createSection($swiftcart_prefix . '_theme_options', array(
		'title'  => 'General',
		'icon'   => 'fa fa-wrench',
		'fields' => array(
			array(
				'type'    => 'subheading',
				'content' => '<h3>' . esc_html__('Preloader Options', 'swiftcart') . '</h3>'
			),
			array(
				'id'      => 'preloader_enable',
				'title'   => esc_html__('Preloader', 'swiftcart'),
				'type'    => 'switcher',
				'desc'    => esc_html__('you can set Yes / No to enable/disable preloader', 'swiftcart'),
				'default' => true,
			),
			array(
				'id'    => 'swiftcart_preloader_iamge',
				'type'  => 'upload',
				'title' => esc_html__('Upload Preloader Image', 'swiftcart'),
				'dependency' => array('preloader_enable', '==', 'true')
			),
			array(
				'type'    => 'subheading',
				'content' => '<h3>' . esc_html__('Back Top Options', 'swiftcart') . '</h3>'
			),
			array(
				'id'      => 'back_top_enable',
				'title'   => esc_html__('Back Top', 'swiftcart'),
				'type'    => 'switcher',
				'desc'    => esc_html__('you can set Yes / No to show/hide back to top', 'swiftcart'),
				'default' => true,
			),
			array(
				'type'    => 'subheading',
				'content' => '<h3>' . esc_html__('RTL Options', 'swiftcart') . '</h3>'
			),
			array(
				'id'      => 'rtl_enable',
				'title'   => esc_html__('Enable RTL', 'swiftcart'),
				'type'    => 'switcher',
				'desc'    => esc_html__('you can set Yes / No to show/hide RTL', 'swiftcart'),
				'default' => false,
			),

		)
	));

	/*-------------------------------------------------------
	   ** Entire Site Header  Options
	 --------------------------------------------------------*/
	CSF::createSection(
		$swiftcart_prefix . '_theme_options',
		array(
			'title' => esc_html__('Header Option', 'swiftcart'),
			'id'    => 'entire_site_header_options',
			'icon'  => 'fa fa-header'
		)
	);
	CSF::createSection($swiftcart_prefix . '_theme_options', array(
		'title'  => esc_html__('Select Header', 'swiftcart'),
		'id'     => 'logo_options',
		'icon'   => 'fa fa-ellipsis-h',
		'parent' => 'entire_site_header_options',
		'fields' => array(
			array(
				'id'         => 'enable_header_builder',
				'title'      => esc_html__('Enable Header Builder', 'swiftcart'),
				'type'       => 'switcher',
				'desc'       => esc_html__('You can set Yes / No to use header builder', 'swiftcart'),
				'default'    => false,
			),
			array(
				'id'          => 'header-builder-id',
				'type'        => 'select',
				'title'       => esc_html__('Select Header', 'swiftcart'),
				'placeholder' => esc_html__('Select a Header', 'swiftcart'),
				'options'     => swiftcart_get_header_builder_library(),
				'dependency'  => array('enable_header_builder', '==', true),
				'desc'        => esc_html__("You need to create first header from header builder", 'swiftcart')

			),
		)
	));
	CSF::createSection($swiftcart_prefix . '_theme_options', array(
		'title'  => esc_html__('Banner', 'swiftcart'),
		'id'     => 'breadcrumb_options',
		'icon'   => 'fa fa-ellipsis-h',
		'parent' => 'entire_site_header_options',
		'fields' => array(
			array(
				'type'    => 'subheading',
				'content' => '<h3>' . esc_html__('Banner Options', 'swiftcart') . '</h3>'
			),
			array(
				'id'      => 'breadcrumb_enable',
				'title'   => esc_html__('Banner', 'swiftcart'),
				'type'    => 'switcher',
				'desc'    => esc_html__('you can set Yes / No to show/hide banner', 'swiftcart'),
				'default' => true,
			),
			array(
				'id'    => 'banner_shape',
				'type'  => 'upload',
				'title' => esc_html__('Upload Breadcrumb Banner Shape', 'swiftcart'),
			),
		)
	));

	/*-------------------------------------------------------
	   ** Pages and Template
	 --------------------------------------------------------*/
	CSF::createSection($swiftcart_prefix . '_theme_options', array(
		'id'    => 'pages_and_template',
		'title' => esc_html__('Pages & Template', 'swiftcart'),
		'icon'  => 'fa fa-files-o'
	));

	// blog option
	CSF::createSection($swiftcart_prefix . '_theme_options', array(
		'title'  => esc_html__('Blog Page', 'swiftcart'),
		'id'     => 'blog_page',
		'icon'   => 'fa fa-ellipsis-h',
		'parent' => 'pages_and_template',
		'fields' => array(
			array(
				'type'    => 'subheading',
				'content' => '<h3>' . esc_html__('Blog Page Option', 'swiftcart') . '</h3>'
			),
			array(
				'id'      => $swiftcart_prefix . '_blog_layout',
				'type'    => 'image_select',
				'title'   => esc_html__('Select Page Layout', 'swiftcart'),
				'options' => array(
					'full-width'    => SWIFTCART_CORE_IMG . '/page/D.png',
					'left-sidebar'  => SWIFTCART_CORE_IMG . '/page/L.png',
					'right-sidebar' => SWIFTCART_CORE_IMG . '/page/R.png',
				),
				'default' => 'right-sidebar'
			),
		)
	));
	// blog single option
	CSF::createSection($swiftcart_prefix . '_theme_options', array(
		'title'  => esc_html__('Blog Single Page', 'swiftcart'),
		'id'     => 'single_page',
		'icon'   => 'fa fa-ellipsis-h',
		'parent' => 'pages_and_template',
		'fields' => array(
			array(
				'type'    => 'subheading',
				'content' => '<h3>' . esc_html__('Blog Single Page Option', 'swiftcart') . '</h3>'
			),
			array(
				'id'      => $swiftcart_prefix . '_single_page_layout',
				'type'    => 'image_select',
				'title'   => esc_html__('Select Page Layout', 'swiftcart'),
				'options' => array(
					'full-width'    => SWIFTCART_CORE_IMG . '/page/D.png',
					'left-sidebar'  => SWIFTCART_CORE_IMG . '/page/L.png',
					'right-sidebar' => SWIFTCART_CORE_IMG . '/page/R.png',
				),
				'default' => 'right-sidebar'
			),
		)
	));


	// archive page option
	CSF::createSection($swiftcart_prefix . '_theme_options', array(
		'title'  => esc_html__('Archive  Page', 'swiftcart'),
		'id'     => 'archive_page',
		'icon'   => 'fa fa-ellipsis-h',
		'parent' => 'pages_and_template',
		'fields' => array(
			array(
				'type'    => 'subheading',
				'content' => '<h3>' . esc_html__('Archive Page Option', 'swiftcart') . '</h3>'
			),
			array(
				'id'      => $swiftcart_prefix . '_archive_layout',
				'type'    => 'image_select',
				'title'   => esc_html__('Select Page Layout', 'swiftcart'),
				'options' => array(
					'full-width'    => SWIFTCART_CORE_IMG . '/page/D.png',
					'left-sidebar'  => SWIFTCART_CORE_IMG . '/page/L.png',
					'right-sidebar' => SWIFTCART_CORE_IMG . '/page/R.png',
				),
				'default' => 'right-sidebar'
			),
		)
	));

	// search page option
	CSF::createSection($swiftcart_prefix . '_theme_options', array(
		'title'  => esc_html__('Search  Page', 'swiftcart'),
		'id'     => 'search_page',
		'icon'   => 'fa fa-ellipsis-h',
		'parent' => 'pages_and_template',
		'fields' => array(
			array(
				'type'    => 'subheading',
				'content' => '<h3>' . esc_html__('Search Page Option', 'swiftcart') . '</h3>'
			),
			array(
				'id'      => $swiftcart_prefix . '_search_layout',
				'type'    => 'image_select',
				'title'   => esc_html__('Select Page Layout', 'swiftcart'),
				'options' => array(
					'full-width'    => SWIFTCART_CORE_IMG . '/page/D.png',
					'left-sidebar'  => SWIFTCART_CORE_IMG . '/page/L.png',
					'right-sidebar' => SWIFTCART_CORE_IMG . '/page/R.png',
				),
				'default' => 'right-sidebar'
			),
		)
	));


	/*  404 page options */
	CSF::createSection($swiftcart_prefix . '_theme_options', array(
		'id'     => '404_page',
		'title'  => esc_html__('404 Page', 'swiftcart'),
		'parent' => 'pages_and_template',
		'icon'   => 'fa fa-exclamation-triangle',
		'fields' => array(
			array(
				'type'    => 'subheading',
				'content' => '<h3>' . esc_html__('404 Page Options', 'swiftcart') . '</h3>',
			),
			array(
				'id'         => '404_title',
				'title'      => esc_html__('Title', 'swiftcart'),
				'type'       => 'text',
				'attributes' => array('placeholder' => esc_html__('404', 'swiftcart'))
			),
			array(
				'id'         => '404_subtitle',
				'title'      => esc_html__('Sub Title', 'swiftcart'),
				'type'       => 'text',
				'attributes' => array('placeholder' => esc_html__('Sorry. we couldn\'t find that page', 'swiftcart'))
			),
			array(
				'id'         => '404_button_text',
				'title'      => esc_html__('Button Text', 'swiftcart'),
				'type'       => 'text',
				'attributes' => array('placeholder' => esc_html__('Go Back', 'swiftcart'))
			),
			array(
				'id'    => 'swiftcart_404_image',
				'type'  => 'upload',
				'title' => esc_html__('Upload Image', 'swiftcart'),
			),
		)
	));

	/*-------------------------------------------------------
	   ** Typography  Options
  --------------------------------------------------------*/
	CSF::createSection($swiftcart_prefix . '_theme_options', array(
		'id'     => 'typography',
		'title'  => esc_html__('Typography', 'swiftcart'),
		'icon'   => 'fa fa-text-width',
		'fields' => array(
			array(
				'type'    => 'subheading',
				'content' => '<h3>' . esc_html__('Body Font Options', 'swiftcart') . '</h3>',
			),
			array(
				'type'    => 'switcher',
				'id'      => 'body_font_enable',
				'title'   => esc_html__('Body Font', 'swiftcart'),
				'desc'    => esc_html__('you can set yes to select different body font', 'swiftcart'),
				'default' => false
			),
			array(
				'type'           => 'typography',
				'title'          => esc_html__('Typography', 'swiftcart'),
				'id'             => 'swiftcart_body_font',
				'default'        => array(
					'font-family' => 'Rubik',
					'font-size'   => '16',
					'line-height' => '26',
					'unit'        => 'px',
					'type'        => 'google',
				),
				'color'          => false,
				'subset'         => false,
				'text_align'     => false,
				'text_transform' => false,
				'letter_spacing' => false,
				'desc'           => esc_html__('you can set font for all html tags (if not use different heading font)', 'swiftcart'),
				'dependency'     => array('body_font_enable', '==', 'true')
			),
			array(
				'type'    => 'subheading',
				'content' => '<h3>' . esc_html__('Heading Font Options', 'swiftcart') . '</h3>',
			),
			array(
				'type'    => 'switcher',
				'id'      => 'heading_font_enable',
				'title'   => esc_html__('Heading Font', 'swiftcart'),
				'desc'    => esc_html__('you can set yes to select different heading font', 'swiftcart'),
				'default' => false
			),
			array(
				'type'           => 'typography',
				'title'          => esc_html__('Typography', 'swiftcart'),
				'id'             => 'heading_font',
				'default'        => array(
					'font-family' => 'Rubik',
					'type'        => 'google',
				),
				'color'          => false,
				'subset'         => false,
				'text_align'     => false,
				'text_transform' => false,
				'letter_spacing' => false,
				'font_size'      => false,
				'line_height'    => false,
				'desc'           => esc_html__('you can set font for for heading tag .eg: h1,h2mh3,h4,h5,h6', 'swiftcart'),
				'dependency'     => array('heading_font_enable', '==', 'true')
			),
		)
	));

	/*-------------------------------------------------------
		 ** Footer  Options
	--------------------------------------------------------*/
	CSF::createSection($swiftcart_prefix . '_theme_options', array(
		'title'  => esc_html__('Footer', 'swiftcart'),
		'id'     => 'footer_options',
		'icon'   => 'fa fa-copyright',
		'fields' => array(
			array(
				'type'    => 'subheading',
				'content' => '<h3>' . esc_html__('Footer Options', 'swiftcart') . '</h3>'
			),
			array(
				'id'         => 'enable_footer_builder',
				'title'      => esc_html__('Enable Footer Builder', 'swiftcart'),
				'type'       => 'switcher',
				'desc'       => esc_html__('You can set Yes / No to use footer builder', 'swiftcart'),
				'default'    => false,
			),
			array(
				'id'          => 'footer-builder-id',
				'type'        => 'select',
				'title'       => esc_html__('Select Footer', 'swiftcart'),
				'placeholder' => esc_html__('Select a Footer', 'swiftcart'),
				'options'     => swiftcart_get_footer_builder_library(),
				'desc'        => esc_html__("You need to create first footer from footer builder", 'swiftcart'),
				'dependency'  => array('enable_footer_builder', '==', true)
			),
			array(
				'id'         => 'copyright_text',
				'title'      => esc_html__('Copyright Area Text', 'swiftcart'),
				'type'       => 'text',
				'desc'       => esc_html__('enter copyright text', 'swiftcart'),
				'dependency' => array('enable_footer_builder', '==', false)
			),
		)
	));

	// Backup section
	CSF::createSection($swiftcart_prefix . '_theme_options', array(
		'title'  => esc_html__('Backup', 'swiftcart'),
		'id'     => 'backup_options',
		'icon'   => 'fa fa-window-restore',
		'fields' => array(
			array(
				'type' => 'backup',
			),
		)
	));
}
