<?php
if (!function_exists('swiftcart_dynamic_styles')) {

	function swiftcart_dynamic_styles()
	{

		ob_start();


		/*------------------------------------------------------------------------------------
		 * body font
		------------------------------------------------------------------------------------ */

		if (1 == swiftcart_get_option('body_font_enable', 0)) :

			$swiftcart_body_font = swiftcart_get_option('swiftcart_body_font');
			$font_weight = isset($swiftcart_body_font['font-weight']) ? $swiftcart_body_font['font-weight'] : "normal";
?>

			body{
			font-family:<?php echo esc_attr($swiftcart_body_font['font-family']); ?>;
			font-weight:<?php echo esc_attr($font_weight); ?>;
			font-size:<?php echo esc_attr($swiftcart_body_font['font-size']); ?>px;
			}

		<?php

		endif;

		/*------------------------------------------------------------------------------------
		 * body font
		------------------------------------------------------------------------------------ */

		if (1 == swiftcart_get_option('heading_font_enable', 0)) :

			$swiftcart_heading_font = swiftcart_get_option('heading_font');
			$font_weight = isset($swiftcart_heading_font['font-weight']) ? $swiftcart_heading_font['font-weight'] : "normal";
		?>

			h1,h2,h3,h4,h5,h6{
			font-family:<?php echo esc_attr($swiftcart_heading_font['font-family']); ?>;
			font-weight:<?php echo esc_attr($font_weight); ?>;
			}

		<?php

		endif;


		/*------------------------------------------------------------------------------------
		  blog page spacing
		 ------------------------------------------------------------------------------------ */

		if (1 == swiftcart_get_option('blog_spacing_enable', 0)) :

		?>

			.swiftcart-blog-page{
			margin-top:<?php echo esc_attr(swiftcart_get_option('blog_top_padding')); ?>px;
			margin-bottom:<?php echo esc_attr(swiftcart_get_option('blog_bottom_padding')); ?>px;
			}

		<?php

		endif;

		/*------------------------------------------------------------------------------------
		 blog details page spacing
		------------------------------------------------------------------------------------ */

		if (1 == swiftcart_get_option('blog_details_spacing_enable', 0)) :

		?>

			.swiftcart-blog-details{
			margin-top:<?php echo esc_attr(swiftcart_get_option('single_top_padding')); ?>px;
			margin-bottom:<?php echo esc_attr(swiftcart_get_option('single_bottom_padding')); ?>px;
			}

		<?php

		endif;


		/*------------------------------------------------------------------------------------
		  archive page spacing
		 ------------------------------------------------------------------------------------ */

		if (1 == swiftcart_get_option('archive_page_spacing_enable', 0)) :

		?>

			.swiftcart-archive-page{
			margin-top:<?php echo esc_attr(swiftcart_get_option('archive_top_padding')); ?>px;
			margin-bottom:<?php echo esc_attr(swiftcart_get_option('archive_bottom_padding')); ?>px;
			}

		<?php

		endif;

		/*------------------------------------------------------------------------------------
		 search page spacing
		------------------------------------------------------------------------------------ */

		if (1 == swiftcart_get_option('search_page_spacing_enable', 0)) :

		?>

			.swiftcart-search-page{
			margin-top:<?php echo esc_attr(swiftcart_get_option('search_top_padding')); ?>px;
			margin-bottom:<?php echo esc_attr(swiftcart_get_option('search_bottom_padding')); ?>px;
			}

		<?php

		endif;

		/*------------------------------------------------------------------------------------
		  footer top spacing
		------------------------------------------------------------------------------------ */

		if (1 == swiftcart_get_option('footer_spacing', 0)) :

		?>

			.swiftcart-footer-top{
			margin-top:<?php echo esc_attr(swiftcart_get_option('footer_top_spacing')); ?>px;
			margin-bottom:<?php echo esc_attr(swiftcart_get_option('footer_bottom_spacing')); ?>px;
			}

		<?php

		endif;

		/*------------------------------------------------------------------------------------
		  footer bottom spacing
		------------------------------------------------------------------------------------ */

		if (1 == swiftcart_get_option('copyright_area_spacing', 0)) :

		?>

			.footer-bottom{
			padding-top:<?php echo esc_attr(swiftcart_get_option('copyright_area_top_spacing')); ?>px;
			padding-bottom:<?php echo esc_attr(swiftcart_get_option('copyright_area_bottom_spacing')); ?>px;
			}

		<?php

		endif;

		?>

		.page-banner-wrapper{
		background-image:url( <?php echo esc_url(swiftcart_get_option('banner_shape')); ?> );
		}

		<?php

		/*------------------------------------------------------------------------------------
		  From customizer
	   ------------------------------------------------------------------------------------ */

		//primary color

		if (!empty(swiftcart_get_customize_option('main_color'))) :
		?>
			:root {
			--blue-color: <?php echo esc_attr(swiftcart_get_customize_option('main_color')); ?>;
			}
<?php endif;

		$output = ob_get_clean();

		return $output;
	} //end  swiftcart_dynamic_styles

} //endif


function swiftcart_style_method()
{

	$custom_css = swiftcart_dynamic_styles();

	wp_add_inline_style('swiftcart-style', $custom_css);
}

add_action('wp_enqueue_scripts', 'swiftcart_style_method', 99);
