<?php


class Swiftcart_Utility {
    public function __construct() {
        $this->register_image_size();
        add_filter('wpcf7_autop_or_not', '__return_false');
        //widget init
        add_action('init', array($this, 'elementor_cpt_support'));
    }
    public function register_image_size() {
        
        add_image_size('swiftcart_blog_85X85', 85, 85, true);
        add_image_size('swiftcart_blog_416X277', 416, 277, true); 
        add_image_size('swiftcart_product_60x60', 60, 60, true);
        add_image_size('swiftcart_product_100x110', 100, 110, true);
        add_image_size('swiftcart_product_180x180', 180, 180, true);
        add_image_size('swiftcart_product_270x340', 270, 340, true);
        add_image_size('swiftcart_product_420x580', 420, 580, true);
    }
    /**
     *cpt in elementor
     * @since 1.0.0
     * */
    public function elementor_cpt_support() {

        //if exists, assign to $cpt_support var
        $cpt_support = get_option('elementor_cpt_support');

        //check if option DOESN'T exist in db
        if (!$cpt_support) {
            $cpt_support = ['page', 'post', 'footer-builder', 'header-builder']; //create array of our default supported post types
            update_option('elementor_cpt_support', $cpt_support); //write it to the database
        }

        //if it DOES exist, but footer is NOT defined
        else if (!in_array('footer-builder', $cpt_support)) {
            $cpt_support[] = 'footer-builder'; //append to array
            update_option('elementor_cpt_support', $cpt_support); //update database
        }

        //if it DOES exist, but header is NOT defined
        else if (!in_array('header-builder', $cpt_support)) {
            $cpt_support[] = 'header-builder'; //append to array
            update_option('elementor_cpt_support', $cpt_support); //update database
        }
    }
}

new Swiftcart_Utility();
