<?php
// Control core classes for avoid errors
if (class_exists('CSF')) {

  //
  // Recent widget
  //
  CSF::createWidget('about_info_widget', array(
    'title'       => esc_html__('About Widget', 'swiftcart-core'),
    'classname'   => 'widget_catagory',
    'description' => esc_html__('Add About', 'swiftcart-core'),
    'fields'      => array(
      array(
        'id'      => 'title', //title
        'type'    => 'text',
        'title'   => esc_html__('About Sidebar', 'swiftcart-core'),
        'default' => esc_html__('About Me', 'swiftcart-core')
      ),
      array(
        'id'      => 'img', //title
        'type'    => 'media',
        'library' => 'image',
        'title'   => esc_html__('Image', 'swiftcart-core'),
      ),
      array(
        'id'      => 'name', //title
        'type'    => 'textarea',
        'title'   => esc_html__('Name', 'swiftcart-core'),
        'default' => 'Samrat Islam Tushar'
      ),
      array(
        'id'      => 'bio', //title
        'type'    => 'textarea',
        'title'   => esc_html__('Bio', 'swiftcart-core'),
        'default' => 'Lorem ipsum dolor amet, Lore ipsum dolor sit amet, consectetur et eiLorem ipsum dolor sit amet'
      ),
      array(
        'id'         => 'social_item',
        'type'       => 'repeater',
        'title'      => esc_html__('Add About Social', 'swiftcart-core'),
        'fields'     => array(
          array(
            'id'         => 'icon',
            'title'      => esc_html__('Icon', 'swiftcart-core'),
            'type'       => 'icon',
            'default'    => 'fab fa-facebook-f',
          ),
          array(
            'id'         => 'link',
            'title'      => esc_html__('Social URl', 'swiftcart-core'),
            'type'       => 'text',
            'default'    => '#',
          ),

        ),
      )
    )
  ));

  //
  // Front-end display of widget example 1
  // Attention: This function named considering above widget base id.
  //
  if (!function_exists('about_info_widget')) {
    function about_info_widget($args, $instance)
    {

      echo $args['before_widget'];
?> 
      <div class="widget-author text-center">
        <?php if (!empty($instance['title'])) {
          echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'];
        } ?>
        <div class="thumb">
          <img src="<?php echo $instance['img']['url']; ?>" alt="<?php echo esc_attr('img') ?>">
        </div>
        <div class="details">
          <h5><?php echo $instance['name']; ?></h5>
          <p><?php echo $instance['bio']; ?></p>
          <ul>
            <?php if (is_array($instance['social_item'])) :
              foreach ($instance['social_item'] as $item) : ?>
                <li>
                  <a href="<?php echo esc_html($item['link']); ?>" target="_blank">
                    <i class="<?php echo esc_attr($item['icon']); ?>" aria-hidden="true"></i>
                  </a>
                </li>
            <?php endforeach;
            endif ?>
          </ul>
        </div>
      </div>
<?php
      echo $args['after_widget'];
    }
  }
}
