<?php
// Control core classes for avoid errors
if (class_exists('CSF')) {

  //
  // Recent widget
  //
  CSF::createWidget('swiftcart_categories_widget', array(
    'title'       => esc_html__('Swiftcart Categories Widget', 'swiftcart-core'),
    'classname'   => 'widget widget-category',
    'description' => esc_html__('Add Categories List', 'swiftcart-core'),
    'fields'      => array(
      array(
        'id'      => 'title', //title
        'type'    => 'text',
        'title'   => esc_html__('Title', 'swiftcart-core'),
        'default' => esc_html__('Categories', 'swiftcart-core')
      ),
    )
  ));

  //
  // Front-end display of widget example 1
  // Attention: This function named considering above widget base id.
  //
  if (!function_exists('swiftcart_categories_widget')) {
    function swiftcart_categories_widget($args, $instance) {

      echo $args['before_widget'];

      if (!empty($instance['title'])) {
        echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'];
      }
      $categories = get_categories();
      echo '<div class="sw-sidebar__widget-content">';
        echo '<ul class="sw-sidebar__categories">';
        foreach ($categories as $index => $category) {
          echo '<li><a href="' . get_category_link($category->term_id) . '">' . $category->name . '<span>' . $category->count . '</span></a></li>';
        }

        echo '</ul>';
      echo '</div>'
?>

<?php
      echo $args['after_widget'];
    }
  }
}
