<?php
// Control core classes for avoid errors
if (class_exists('CSF')) {

  //
  // Recent widget
  //
  CSF::createWidget('donation_widget', array(
    'title'       => esc_html__('Donation Widget', 'swiftcart-core'),
    'classname'   => 'widget_catagory',
    'description' => esc_html__('Donation Widget', 'swiftcart-core'),
    'fields'      => array(
      array(
        'id'      => 'title', //title
        'type'    => 'text',
        'title'   => esc_html__('Donation Title', 'swiftcart-core'),
        'default' => esc_html__('Donation Title', 'swiftcart-core')
      ),
      array(
        'id'         => 'button_lebel',
        'title'      => esc_html__('Button Label', 'swiftcart-core'),
        'type'       => 'text',
        'default'    => 'Donation',
      ),
      array(
        'id'         => 'url',
        'title'      => esc_html__('Url', 'swiftcart-core'),
        'type'       => 'text',
        'default'    => '#',
      ),
      array(
        'id'    => 'bg_img',
        'type'  => 'upload',
        'title' => esc_html__('Background Image', 'swiftcart-core'),
      ),
    )
  ));

  //
  // Front-end display of widget example 1
  // Attention: This function named considering above widget base id.
  //
  if (!function_exists('donation_widget')) {
    function donation_widget($args, $instance)
    {

      echo $args['before_widget'];
?>
      <div class="widget widget_cta">
        <div class="cta-widget-inner" style="background-image: url(<?php echo esc_url($instance['bg_img']); ?>);">
          <h5><?php echo esc_html($instance['title']); ?></h5>
          <a class="btn ml-5" href="<?php echo esc_url($instance['url']); ?>"><?php echo esc_html($instance['button_lebel']); ?></a>
        </div>
      </div>
<?php
      echo $args['after_widget'];
    }
  }
}
