<?php
// Control core classes for avoid errors
if (class_exists('CSF')) {

  //
  // Recent widget
  //
  CSF::createWidget('map_widget', array(
    'title'       => esc_html__('Map Widget', 'swiftcart-core'),
    'classname'   => 'widget_catagory',
    'description' => esc_html__('Add Map List', 'swiftcart-core'),
    'fields'      => array(
      array(
        'id'      => 'title', //title
        'type'    => 'text',
        'title'   => esc_html__('Event Sidebar', 'swiftcart-core'),
        'default' => esc_html__('Event Info ', 'swiftcart-core')
      ),
      array(
        'id'         => 'url',
        'title'      => esc_html__('Map Url', 'swiftcart-core'),
        'type'       => 'text',
        'default'    => '#',
      ),
    )
  ));

  //
  // Front-end display of widget example 1
  // Attention: This function named considering above widget base id.
  //
  if (!function_exists('map_widget')) {
    function map_widget($args, $instance)
    {

      echo $args['before_widget'];
?>
      <div class="widget widget_location">
        <?php if (!empty($instance['title'])) {
          echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'];
        } ?>
        <iframe src="<?php echo $instance['url'] ?>" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
      </div>
<?php
      echo $args['after_widget'];
    }
  }
}
