<?php
// Control core classes for avoid errors
if (class_exists('CSF')) {

  //
  // Recent widget
  //
  CSF::createWidget('swiftcart_recent_event_widget', array(
    'title'       => esc_html__('Swiftcart Recent Event Widget', 'swiftcart-core'),
    'classname'   => 'widget-recent-post',
    'description' => esc_html__('Recent Event Widget', 'swiftcart-core'),
    'fields'      => array(

      array(
        'id'      => 'title', //title
        'type'    => 'text',
        'title'   => esc_html__('Title', 'swiftcart-core'),
        'default' => esc_html__('Recent Event ', 'swiftcart-core')
      ),
      array(
        'id'      => 'ppp', //post per page
        'type'    => 'text',
        'title'   => esc_html__('How Many Event Display ?', 'swiftcart-core'),
        'default' => '3'
      ),
      array(
        'id'          => 'category',
        'type'        => 'select',
        'placeholder' => esc_html__('Select a category', 'swiftcart-core'),
        'title'       => esc_html__('Category', 'swiftcart-core'),
        'options'     => 'categories',
      ),
      array(
        'id'      => 'orderby',
        'type'    => 'select',
        'title'   => esc_html__('Order By', 'swiftcart-core'),
        'options' => array(
          'author' => esc_html__('Author', 'swiftcart-core'),
          'title' => esc_html__('Title', 'swiftcart-core'),
          'date' => esc_html__('Date', 'swiftcart-core'),
          'rand' => esc_html__('Random', 'swiftcart-core'),
        ),
        'default' => 'date'
      ),
      array(
        'id'      => 'order',
        'type'    => 'select',
        'title'   =>  esc_html__('Order', 'swiftcart-core'),
        'options' => array(
          'desc' => esc_html__('DESC', 'swiftcart-core'),
          'asc' => esc_html__('ASC', 'swiftcart-core'),
        ),
      ),
    )
  ));

  //
  // Front-end display of widget example 1
  // Attention: This function named considering above widget base id.
  //
  if (!function_exists('swiftcart_recent_event_widget')) {
    function swiftcart_recent_event_widget($args, $instance)
    {

      echo $args['before_widget'];
?>
      <div class="widget widget-upcoming-event">
        <?php if (!empty($instance['title'])) {
          echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'];
        } ?>
        <ul class="ul-0">
          <?php
          $arg = array(
            'post_type'             => 'event',
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => $instance['ppp'],
          );
          $arg['orderby'] = $instance['orderby'];
          $arg['order'] = $instance['order'];

          if (!empty($instance['category'])) {
            $arg['tax_query'][] = array(
              'taxonomy'           => 'category',
              'field' => 'id',
              'terms' => $instance['category']
            );
          }

          $blog = new \WP_Query($arg);
          if ($blog->have_posts()) :
            while ($blog->have_posts()) : $blog->the_post();
              $event_meta = get_post_meta(get_the_ID(), 'swiftcart_event_meta', true);
          ?>
              <li>
                <?php if (has_post_thumbnail()) : ?>
                  <div class="image">
                    <?php the_post_thumbnail('swiftcart_blog_97X99'); ?>
                  </div>
                <?php endif; ?>
                <div class="content">
                  <h6><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h6>
                  <ul class="blog-meta">
                    <li><i class="flaticon-map"></i><?php echo esc_html($event_meta['event_location_name_link']['text']); ?></li>
                    <li><i class="flaticon-calendar"></i><?php echo get_the_date(); ?></li>
                  </ul>
                </div>
              </li>
          <?php endwhile;
            wp_reset_postdata();
          endif; ?>
        </ul>
      </div>
<?php
      echo $args['after_widget'];
    }
  }
}
