<?php
// Control core classes for avoid errors
if (class_exists('CSF')) {

  //
  // Recent widget
  //
  CSF::createWidget('swiftcart_recent_post_widget', array(
    'title'       => esc_html__('Swiftcart Recent Post Widget', 'swiftcart-core'),
    'classname'   => 'widget-recent-post',
    'description' => esc_html__('Recent Post Widget', 'swiftcart-core'),
    'fields'      => array(

      array(
        'id'      => 'title', //title
        'type'    => 'text',
        'title'   => esc_html__('Title', 'swiftcart-core'),
        'default' => esc_html__('Recent News ', 'swiftcart-core')
      ),
      array(
        'id'      => 'ppp', //post per page
        'type'    => 'text',
        'title'   => esc_html__('How Many Post Display ?', 'swiftcart-core'),
        'default' => '3'
      ),
      array(
        'id'          => 'category',
        'type'        => 'select',
        'placeholder' => esc_html__('Select a category', 'swiftcart-core'),
        'title'       => esc_html__('Category', 'swiftcart-core'),
        'options'     => 'categories',
      ),
      array(
        'id'      => 'orderby',
        'type'    => 'select',
        'title'   => esc_html__('Order By', 'swiftcart-core'),
        'options' => array(
          'author' => esc_html__('Author', 'swiftcart-core'),
          'title' => esc_html__('Title', 'swiftcart-core'),
          'date' => esc_html__('Date', 'swiftcart-core'),
          'rand' => esc_html__('Random', 'swiftcart-core'),
        ),
        'default' => 'date'
      ),
      array(
        'id'      => 'order',
        'type'    => 'select',
        'title'   =>  esc_html__('Order', 'swiftcart-core'),
        'options' => array(
          'desc' => esc_html__('DESC', 'swiftcart-core'),
          'asc' => esc_html__('ASC', 'swiftcart-core'),
        ),
      ),
    )
  ));

  //
  // Front-end display of widget example 1
  // Attention: This function named considering above widget base id.
  //
  if (!function_exists('swiftcart_recent_post_widget')) {
    function swiftcart_recent_post_widget($args, $instance) {

      echo $args['before_widget'];
?>
      <div class="widget-news sidebar-recent-widget">
        <?php if (!empty($instance['title'])) {
          echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'];
        } ?>

        <?php
        $arg = array(
          'post_type'             => 'post',
          'post_status'           => 'publish',
          'ignore_sticky_posts'   => 1,
          'posts_per_page'        => $instance['ppp'],
        );
        $arg['orderby'] = $instance['orderby'];
        $arg['order'] = $instance['order'];

        if (!empty($instance['category'])) {
          $arg['tax_query'][] = array(
            'taxonomy'           => 'category',
            'field' => 'id',
            'terms' => $instance['category']
          );
        }

        $blog = new \WP_Query($arg); ?>
        <div class="sw-sidebar__widget-content">
          <?php if ($blog->have_posts()) :
            while ($blog->have_posts()) : $blog->the_post();
          ?>
              <div class="sw-sidebar__blog">
                <?php if (has_post_thumbnail()) : ?>
                  <div class="sw-sidebar__blog-thumb">
                    <a href="<?php echo the_permalink(); ?>"><?php the_post_thumbnail('swiftcart_blog_85X85'); ?></a>
                  </div>
                <?php endif; ?>
                <div class="sw-sidebar__blog-content">
                  <div class="sw-sidebar__blog-meta">
                    <span><i class="icon-date"></i><?php echo get_the_date(); ?></span>
                  </div>
                  <h3 class="sw-sidebar__blog-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                </div>
              </div>
          <?php endwhile;
            wp_reset_postdata();
          endif; ?>
        </div>
      </div>
<?php
      echo $args['after_widget'];
    }
  }
}
