<?php
// Control core classes for avoid errors
if (class_exists('CSF')) {

  //
  // Recent widget
  //
  CSF::createWidget('search_widget', array(
    'title'       => esc_html__('Swiftcart Search Widget', 'swiftcart-core'),
    'classname'   => 'widget_catagory',
    'description' => esc_html__('Add Search Widget', 'swiftcart-core'),
    'fields'      => array(
      array(
        'id'      => 'title', //title
        'type'    => 'text',
        'title'   => esc_html__('Search Causes', 'swiftcart-core'),
        'default' => esc_html__('Search Causes', 'swiftcart-core')
      ),
    )
  ));

  //
  // Front-end display of widget example 1
  // Attention: This function named considering above widget base id.
  //
  if (!function_exists('search_widget')) {
    function search_widget($args, $instance)
    {

      echo $args['before_widget'];
?>
      <div class="widget widget-search">
        <?php if (!empty($instance['title'])) {
          echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'];
        } ?>
        <div class="single-search-inner">
          <form class="search-form" action="/" method="get">
            <input type="text" name="s" id="search" placeholder="<?php echo esc_attr__("Search your keyword", 'swiftcart-core') ?>" value="<?php the_search_query(); ?>" />
            <button type="submit"><i class="la la-search"></i></button>
          </form>
        </div>
      </div>
<?php
      echo $args['after_widget'];
    }
  }
}
