<?php

/**
 * @package Swiftcart Core
 * @version 1.0.2
 */
/*
Plugin Name: Swiftcart Core
Plugin URI:
Description: This is a helper plugin for Swiftcart  Theme
Author: SolverWp
Version: 1.0.0
Author URI:https://solverwp.com/
*/
/**  Related Theme Type */


global $related_theme_type;
$related_theme_type = array('SWIFTCART', 'Swiftcart Child');
//define current theme name
$current_theme = !empty(wp_get_theme()) ? wp_get_theme()->get('Name') : '';
define('CURRENT_THEME_NAME', $current_theme);


/*
 * Define Plugin Dir Path
 * @since 1.0.0
 * */
define('SWIFTCART_CORE_SELF_PATH', 'swiftcart-core/swiftcart-core.php');
define('SWIFTCART_CORE_ROOT_PATH', plugin_dir_path(__FILE__));
define('SWIFTCART_CORE_ROOT_URL', plugin_dir_url(__FILE__));
define('SWIFTCART_CORE_LIB', SWIFTCART_CORE_ROOT_PATH . '/lib');
define('SWIFTCART_CORE_INC', SWIFTCART_CORE_ROOT_PATH . '/inc');
define('SWIFTCART_CORE_ADMIN', SWIFTCART_CORE_INC . '/admin');
define('SWIFTCART_CORE_VERDOR', SWIFTCART_CORE_ROOT_URL . 'assets/vendors');
define('SWIFTCART_CORE_ADMIN_ASSETS', SWIFTCART_CORE_ROOT_URL . 'inc/admin/assets');
define('SWIFTCART_CORE_CSS', SWIFTCART_CORE_ROOT_URL . 'assets/css');
define('SWIFTCART_CORE_IMG', SWIFTCART_CORE_ROOT_URL . 'assets/img');
define('SWIFTCART_CORE_JS', SWIFTCART_CORE_ROOT_URL . 'assets/js');
define('SWIFTCART_CORE_ELEMENTOR', SWIFTCART_CORE_INC . '/elementor');
define('SWIFTCART_CORE_SHORTCODES', SWIFTCART_CORE_INC . '/shortcodes');
define('SWIFTCART_CORE_WIDGETS', SWIFTCART_CORE_INC . '/widgets');

/** Plugin version **/
define('SWIFTCART_CORE_VERSION', '1.0.0');


//plugin core file include
if (file_exists(SWIFTCART_CORE_INC . '/class-swiftcart-core-init.php')) {
	require_once SWIFTCART_CORE_INC . '/class-swiftcart-core-init.php';
}


/**
 * Load plugin textdomain.
 */
add_action('plugins_loaded', 'swiftcart_core_language');
if (!function_exists('swiftcart_core_language')) {

	function swiftcart_core_language()
	{
		load_plugin_textdomain('swiftcart-core', false, plugin_basename(dirname(__FILE__)) . '/language');
	}
}


add_filter('template_include', 'custom_search_template');
// Function to load the custom search template
function custom_search_template($template)
{
	if (is_search() && isset($_GET['cpt']) && $_GET['cpt'] === 'property') {
		// Replace 'your_custom_post_type' with your custom post type slug.
		return plugin_dir_path(__FILE__) . '/template/custom-search-template.php';
	}
	return $template;
}
