     <?php

        get_header();

        $query = $wp_query; // Get the current query

        // Keyword search
        $args = array(
            'post_type'           => 'property',
            'post_status'         => 'publish',

        );

        $args['s']       = (null != filter_input(INPUT_GET, 's')) ? sanitize_text_field($_GET['s']) : '';

        $selected_categories = array();

        if (!empty($_GET['cat']) && is_array($_GET['cat'])) {
            foreach ($_GET['cat'] as $category) {
                $selected_categories[] = sanitize_text_field($category);
            }
        }

        if (!empty($selected_categories)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'course-category',
                    'field'    => 'slug',
                    'terms'    => $selected_categories,
                ),
            );
        }

        $selected_course_types = array();
        $selected_course_levels = array();


        if (!empty($_GET['course-type']) && is_array($_GET['course-type'])) {
            $selected_course_types = array_map('sanitize_text_field', $_GET['course-type']);
        }

        if (!empty($_GET['course-level']) && is_array($_GET['course-level'])) {
            $selected_course_levels = array_map('sanitize_text_field', $_GET['course-level']);
        }

        // Set up a meta query to filter by course type
        if (!empty($selected_course_types)) {
            $meta_query[] = array(
                'key'     => '_tutor_course_price_type', // Adjust the meta key to your actual key
                'value'   => $selected_course_types,
                'compare' => 'IN',
            );
        }

        // Set up a meta query to filter by course level
        if (!empty($selected_course_levels)) {
            $meta_query[] = array(
                'key'     => '_tutor_course_level', // Adjust the meta key to your actual key
                'value'   => $selected_course_levels,
                'compare' => 'IN',
            );
        }

        // Add the meta query to the main query
        if (!empty($meta_query)) {
            $args['meta_query'] = $meta_query;
        }

        // Pagination
        $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        $args['paged'] = $paged;

        $query->set('post_type', 'courses'); // Set the post type in the modified query
        $query->query($args); // Modify the query 
        ?>

     <!-- blog area start -->
     <div class="blog-area pd-top-120 pd-bottom-120">
         <div class="container">
             <div class="row">
                 <div class="col-lg-8 order-lg-12">
                     <div class="row">
                         <?php
                            if (have_posts()) :
                                while (have_posts()) : the_post(); ?>
                                 <div class="col-md-6">
                                     <div class="single-course-inner">
                                         <div class="thumb">
                                             <?php the_post_thumbnail(); ?>
                                         </div>
                                         <div class="details">
                                             <div class="details-inner">
                                                 <div class="emt-user">
                                                     <span class="u-thumb"><?php echo get_avatar(get_the_author_meta('ID'), 30); ?></span>
                                                     <span class="align-self-center"><?php the_author(); ?></span>
                                                 </div>
                                                 <h6>
                                                     <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                 </h6>
                                             </div>
                                             <div class="emt-course-meta">
                                                 <div class="row">
                                                     <?php
                                                        $course_rating = tutor_utils()->get_course_rating();
                                                        if (!empty($course_rating)) { ?>
                                                         <?php
                                                            if ($course_rating->rating_avg > 0) { ?>
                                                             <div class="col-6">
                                                                 <div class="rating">
                                                                     <i class="fa fa-star"></i> <?php echo  apply_filters('edumint_course_rating_average', $course_rating->rating_avg); ?>
                                                                     <span>(<?php echo esc_html($course_rating->rating_count); ?>)</span>
                                                                 </div>
                                                             </div>
                                                     <?php }
                                                        } ?>
                                                     <div class="col-6">
                                                         <div class="price text-right">
                                                             <?php tutor_course_loop_price(); ?>
                                                         </div>
                                                     </div>
                                                 </div>
                                             </div>
                                         </div>
                                     </div>
                                 </div>
                         <?php endwhile;

                                echo '<div class="pagination">';
                                echo paginate_links(array(
                                    'total' => $query->max_num_pages,
                                    'current' => $paged,
                                ));
                                echo '</div>';

                            else :

                                get_template_part('template-parts/content', 'none');

                            endif; ?>
                     </div>
                 </div>
                 <div class="col-lg-4 order-lg-1 col-12">
                     <div class="td-sidebar mt-5 mt-lg-0">
                         <form action="<?php echo esc_url(home_url()); ?>" method="GET" id="filter-form">
                             <input type="hidden" name="cpt" value="courses" />
                             <div class="search-form single-input-inner">
                                 <div class="widget widget_search_course">
                                     <h4 class="widget-title">Search</h4>
                                     <input type="text" name="s" placeholder="Search here" value="<?php the_search_query(); ?>">
                                     <button class="btn btn-base w-100 mt-3" type="submit"><i class="fa fa-search"></i>SEARCH</button>
                                 </div>
                             </div>
                             <div class="widget widget_catagory">
                                 <h4 class="widget-title">Catagory</h4>
                                 <div class="widget widget_checkbox_list">
                                     <?php
                                        // Get the list of available categories
                                        $categories = get_terms('course-category', array('hide_empty' => false));
                                        foreach ($categories as $category) {
                                            $checked = in_array($category->slug, $selected_categories) ? 'checked' : '';
                                            echo '<label class="single-checkbox">';
                                            echo '<input type="checkbox" name="cat[]" value="' . $category->slug . '" ' . $checked . '>';
                                            echo '<span class="checkmark"></span>';
                                            echo $category->name;
                                            echo '</label>';
                                        }
                                        ?>
                                 </div>
                             </div>
                             <div class="widget widget_checkbox_list">
                                 <h4 class="widget-title">Price</h4>
                                 <?php
                                    $courseTypes = array(
                                        'free' => 'Free Courses',
                                        'paid' => 'Paid Courses',
                                    );
                                    foreach ($courseTypes as $typeSlug => $typeName) {
                                        $checked = in_array($typeSlug, $selected_course_types) ? 'checked' : '';
                                        echo '<label class="single-checkbox">';
                                        echo '<input type="checkbox" name="course-type[]" value="' . $typeSlug . '" ' . $checked . '>';
                                        echo '<span class="checkmark"></span>';
                                        echo $typeName;
                                        echo '</label>';
                                    }
                                    ?>
                             </div>
                             <div class="widget widget_checkbox_list">
                                 <h4 class="widget-title">Level</h4>
                                 <?php
                                    $courseLevels = array(
                                        'all_levels' => 'All Levels',
                                        'beginner' => 'Beginner',
                                        'intermediate' => 'Intermediate',
                                        'advanced' => 'Advanced',
                                    );
                                    foreach ($courseLevels as $levelSlug => $levelName) {
                                        $checked = in_array($levelSlug, $selected_course_levels) ? 'checked' : '';
                                        echo '<label class="single-checkbox">';
                                        echo '<input type="checkbox" name="course-level[]" value="' . $levelSlug . '" ' . $checked . '>';
                                        echo '<span class="checkmark"></span>';
                                        echo $levelName;
                                        echo '</label>';
                                    }
                                    ?>
                             </div>
                         </form>
                     </div>
                 </div>
             </div>
         </div>
     </div>
     <!-- blog area end -->
     <?php get_footer(); ?>