<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package swiftcart
 */

get_header();
$swiftcart_404_title    = !empty(swiftcart_get_option('404_title')) ? swiftcart_get_option('404_title') : __('Page Not Found', 'swiftcart');
$swiftcart_404_subtitle = !empty(swiftcart_get_option('404_subtitle')) ? swiftcart_get_option('404_subtitle') : __('The Page You Are Looking For Is Not Available Or Doesnot Belong This Website!', 'swiftcart');
$swiftcart_back_home    = !empty(swiftcart_get_option('404_button_text')) ? swiftcart_get_option('404_button_text') : __('Go to Home', 'swiftcart');
?>
<div class="sw-error-one pb-80 pt-80">
    <div class="container">
        <div class="row justify-content-center ">
            <div class="col-12">
                <div class="sw-error-one__content text-center">
                    <?php if (!empty(swiftcart_get_option('swiftcart_404_image'))) : ?>
                        <div class="m-img">
                            <img src="<?php echo swiftcart_get_option('swiftcart_404_image'); ?>" alt="<?php echo esc_attr('Error Image', 'swiftcart'); ?>">
                        </div>
                    <?php endif; ?>
                    <h1 class="sw-error-one__title"><?php echo esc_html__('Oops! Page Not Found.', 'swiftcart'); ?></h1>
                    <p class="sw-error-one__info"><?php echo wp_kses($swiftcart_404_subtitle, 'swiftcart_core_allowed_tags'); ?></p>
                    <a href="<?php echo esc_url(home_url('/')); ?>" class="swiftcart-btn"><?php echo esc_html($swiftcart_back_home); ?></a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
get_footer();
