<?php

/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package swiftcart
 */

get_header();
$swiftcart_layout = swiftcart_page_layout_options('single_page');

?>
<div id="primary" class="content-area swiftcart-archive-page pt-80 pb-80">
	<main id="main" class="site-main">
		<div class="blog-page-area">
			<div class="container">
				<div class="row gutter-y-60">
					<div class="<?php echo esc_attr($swiftcart_layout['main_content_class']); ?>">
						<div class="row gutter-y-40">
							<?php
							if (have_posts()) :

								/* Start the Loop */
								while (have_posts()) :
									the_post();

									/*
									 * Include the Post-Type-specific template for the content.
									 * If you want to override this in a child theme, then include a file
									 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
									 */
									get_template_part('template-parts/content', get_post_format());

								endwhile;

							?>
								<div class="wp-pagination sw-pagination">
									<?php swiftcart_pagination(); ?>
								</div>
							<?php

							else :

								get_template_part('template-parts/content', 'none');

							endif;
							?>
						</div>
					</div>
					<?php if ($swiftcart_layout['sidebar_enable']) : ?>
						<div class="<?php echo esc_attr($swiftcart_layout['sidebar_class']); ?>">
							<?php get_sidebar(); ?>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</main><!-- #main -->
</div><!-- #primary -->

<?php

get_footer();
