/*-----------------------------------------------------------------------------------
    
    Template Name: AIcraft - AI Application & Generator HTML Template
    Author:  SolverWp
    Support: support.solverwp@gmail.com
    Description: AIcraft - AI Application & Generator HTML Template
    Version: 1.0

    Note: This is Main Js file
-----------------------------------------------------------------------------------
    Js INDEX
    ===================
    ## Main Menu
    ## Document Ready
    ## Nav Overlay
    ## Preloader
    ## Sticky
    ## Back to top
    ## Magnific-popup js
    ## Slick Slider
    ## Isotope Js
    ## WOW Js
    
-----------------------------------------------------------------------------------*/

(function ($) {
    'use strict';
    var windowOn = $(window);
    //===== Main Menu
    $(window).on("load", function () {
        if ($(".sw-preloader").length) {
            $(".sw-preloader").fadeOut(500);
        }

        if ($(".vs-shop-product-grid").length) {
            $(".vs-shop-product-grid").imagesLoaded(function () {
                $(".vs-shop-product-grid").isotope({
                    layoutMode: "masonry"
                });
            });
        }
    });

    /* -----------------------------------------------------
    Mobile Menu 
  ----------------------------------------------------- */
    $('#mobile-menu').meanmenu({
        meanMenuContainer: '.sw-mobile-nav__menu',
        meanScreenWidth: "1199",
        meanExpand: ['<i class="fal fa-plus"></i>'],
    });

    if ($(".sw-main-menu").length) {
        let menuElement = $(".sw-main-menu");
        let currentMenuItem = menuElement.find("li.current-menu-item");
        let currentMenuParent = menuElement.find("li.current-menu-parent");
        let currentMenuAncestor = menuElement.find("li.current-menu-ancestor");
        let currentPageItem = menuElement.find("li.current_page_item");
        currentMenuItem.addClass("current");
        currentMenuParent.addClass("current");
        currentMenuAncestor.addClass("current");
        currentPageItem.addClass("current");
    }

    /* -----------------------------------------------------
          Offcanvas 
        ----------------------------------------------------- */
    $(".sw-offcanvas-btn").on("click", function () {
        $(".sw-mobile-nav__wrapper").toggleClass("opened");
        $("body").toggleClass("scoroll-locked");
    });

    if ($(".sw-close-toggler").length) {
        $(".sw-close-toggler").on("click", function (e) {
            e.preventDefault();
            $(".sw-search-popup").removeClass("open");
            $(".sw-mobile-nav__wrapper").removeClass("opened");
            $("body").removeClass("scoroll-locked");
            $(".sw-body-overlay").removeClass("active");
        });
    }

    // 07. Back Top Top 
    var btn = $('#sw_back-to-top');
    var btn_wrapper = $('.sw-back-to-top-wrapper');

    windowOn.scroll(function () {
        if (windowOn.scrollTop() > 300) {
            btn_wrapper.addClass('sw-back-to-top-btn-show');
        } else {
            btn_wrapper.removeClass('sw-back-to-top-btn-show');
        }
    });
    btn.on('click', function (e) {
        e.preventDefault();
        $('html, body').animate({
            scrollTop: 0
        }, '300');
    });

    let dynamicyearElm = $(".sw-dynamic-year");
    if (dynamicyearElm.length) {
        let currentYear = new Date().getFullYear();
        dynamicyearElm.html(currentYear);
    }

    // Quantity plus and minus buttons
    $('.sw-cart-plus, .sw-cart-minus').on('click', function () {
        // Find the quantity input within the same container
        var $qty = $(this).closest('.quantity').find('.qty');
        // Get current value and attributes
        var currentVal = parseFloat($qty.val());
        var max = parseFloat($qty.attr('max'));
        var min = parseFloat($qty.attr('min'));
        var step = parseFloat($qty.attr('step')) || 1;
        // Validate and normalize values
        if (isNaN(currentVal)) currentVal = 0;
        if (isNaN(max)) max = Infinity;
        if (isNaN(min)) min = 0;
        // Calculate decimal places in step for proper rounding
        var decimalPlaces = (function () {
            var stepStr = step.toString();
            var decimal = stepStr.indexOf('.');
            return decimal === -1 ? 0 : stepStr.length - decimal - 1;
        })();
        // Adjust the value
        if ($(this).hasClass('sw-cart-plus')) {
            // Increment but don't exceed max
            if (max === Infinity || currentVal < max) {
                $qty.val((Math.min(max, currentVal + step)).toFixed(decimalPlaces));
            }
        } else {
            // Decrement but don't go below min
            if (currentVal > min) {
                $qty.val((Math.max(min, currentVal - step)).toFixed(decimalPlaces));
            }
        }
        // Trigger change event to update any dependent elements
        $qty.trigger('change');
    });

})(jQuery);