<?php

/**
 * swiftcart functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package swiftcart
 */

/**
 * Define Const for theme Dir
 * @since 1.0.0
 * */
define('SWIFTCART_ROOT_PATH', get_template_directory());
define('SWIFTCART_ROOT_URL', get_template_directory_uri());
define('SWIFTCART_CSS', SWIFTCART_ROOT_URL . '/assets/css');
define('SWIFTCART_FONTS', SWIFTCART_ROOT_URL . '/assets/fonts');
define('SWIFTCART_VENDORS', SWIFTCART_ROOT_URL . '/assets/vendors');
define('SWIFTCART_JS', SWIFTCART_ROOT_URL . '/assets/js');
define('SWIFTCART_INC', SWIFTCART_ROOT_PATH . '/inc');
define('SWIFTCART_THEME_OPTIONS', SWIFTCART_INC . '/theme-options');
define('SWIFTCART_THEME_STYLESHEETS', SWIFTCART_INC . '/theme-stylesheets');


/**
 * define theme info
 * @since 1.0.0
 * */
if (is_child_theme()) {
	$swiftcart_theme        = wp_get_theme();
	$swiftcart_parent_theme = $swiftcart_theme->Template;
	$swiftcart_theme_info   = wp_get_theme($swiftcart_parent_theme);
} else {
	$swiftcart_theme_info = wp_get_theme();
}
define('SWIFTCART_DEV_MODE', false);
$swiftcart_version = SWIFTCART_DEV_MODE ? time() : $swiftcart_theme_info->get('Version');
define('SWIFTCART_NAME', $swiftcart_theme_info->get('Name'));
define('SWIFTCART_VERSION', $swiftcart_version);
define('SWIFTCART_AUTHOR', $swiftcart_theme_info->get('Author'));
define('SWIFTCART_AUTHOR_URI', $swiftcart_theme_info->get('AuthorURI'));

/*
* Include theme options helper functions
* @since 1.0.0
*/
if (file_exists(SWIFTCART_INC . '/get-theme-options.php')) {
	require_once SWIFTCART_INC . '/get-theme-options.php';
}


/*
* Include theme init file
* @since 1.0.0
*/
if (file_exists(SWIFTCART_INC . '/class-swiftcart-init.php')) {
	require_once SWIFTCART_INC . '/class-swiftcart-init.php';
}


/*
* template functions
* @since 1.0.0
*/
if (file_exists(SWIFTCART_INC . '/template-functions.php')) {
	require_once SWIFTCART_INC . '/template-functions.php';
}

/*
* template tags
* @since 1.0.0
*/
if (file_exists(SWIFTCART_INC . '/template-tags.php')) {
	require_once SWIFTCART_INC . '/template-tags.php';
}

if (class_exists('WooCommerce')) {
	require_once SWIFTCART_INC . '/woocommerce/woo-hooks-functions.php';
}

/**
 * Add theme support for various features
 */
function swiftcart_theme_support()
{
	// Add support for block styles
	add_theme_support('wp-block-styles');

	// Add support for responsive embeds
	add_theme_support('responsive-embeds');

	// Add support for custom header
	add_theme_support('custom-header', array(
		'default-image'          => '',
		'width'                  => 1000,
		'height'                 => 250,
		'flex-height'            => true,
		'flex-width'             => true,
		'uploads'                => true,
		'random-default'         => false,
		'header-text'            => true,
		'default-text-color'     => '444',
	));

	// Add support for wide and full alignment
	add_theme_support('align-wide');
}
add_action('after_setup_theme', 'swiftcart_theme_support');

/**
 * Register block styles
 */
function swiftcart_register_block_styles()
{
	// Register block styles for core blocks
	register_block_style('core/paragraph', array(
		'name'         => 'swiftcart-paragraph',
		'label'        => __('SwiftCart Style', 'swiftcart'),
		'inline_style' => '.wp-block-paragraph.is-style-swiftcart-paragraph { margin-bottom: 1.5em; }',
	));
}
add_action('init', 'swiftcart_register_block_styles');

/**
 * Register block patterns
 */
function swiftcart_register_block_patterns()
{
	// Register a custom pattern
	register_block_pattern(
		'swiftcart/hero-section',
		array(
			'title'       => __('Hero Section', 'swiftcart'),
			'description' => __('A hero section with image and text', 'swiftcart'),
			'content'     => '<!-- wp:group {"className":"swiftcart-hero-section"} -->
                <div class="wp-block-group swiftcart-hero-section">
                    <!-- wp:heading {"level":1} -->
                    <h1>Welcome to SwiftCart</h1>
                    <!-- /wp:heading -->
                    <!-- wp:paragraph -->
                    <p>Your one-stop shop for all your needs</p>
                    <!-- /wp:paragraph -->
                </div>
                <!-- /wp:group -->',
			'categories'  => array('swiftcart'),
		)
	);
}
add_action('init', 'swiftcart_register_block_patterns');
