<?php

/**
 * theme Hook class
 * */
if (!defined('ABSPATH')) {
	exit(); //exit if access directly
}

if (!class_exists('Swiftcart_General_Hook')) {

	class Swiftcart_General_Hook {

		private static $instance;

		public function __construct() {
			//add serach in  nav bar

			add_action('swiftcart_before_site_content', array($this, 'preloader')); //preloader

			add_action('swiftcart_before_site_content', array($this, 'breadcrumb')); //breadcrumb

			add_action('swiftcart_before_footer', array($this, 'back_to_top')); //back to top button

		}


		/**
		 * getInstance();
		 * @since 1.0.0
		 * */
		public static function getInstance() {
			if (null == self::$instance) {
				self::$instance = new self();
			}

			return self::$instance;
		}


		/**
		 * search popup;
		 * @since 1.0.0
		 *
		 */
		public function breadcrumb() {
			swiftcart_breadcrumb();
		}

		/**
		 * back to top
		 * @since 1.0.0
		 * */
		public function back_to_top() {
			if (swiftcart_switcher_option('back_top_enable') == 1) :
?>

				<!-- back to top area end -->
				<div class="sw-back-to-top-wrapper">
					<button id="sw_back-to-top" type="button" class="sw-back-to-top-btn">
						<svg width="12" height="7" viewBox="0 0 12 7" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M11 6L6 1L1 6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
						</svg>
						<span class="sw-back-to-top-progress"></span>
					</button>
				</div>
			<?php
			endif;
		}

		/**
		 * pre loadaer
		 * @since 1.0.0
		 * */
		public function preloader() {
			if (swiftcart_switcher_option('preloader_enable') == 1) :

			?>

				<div class="sw-preloader">
					<div class="sw-preloader__image">
						<?php if (!empty(swiftcart_get_option('swiftcart_preloader_iamge'))) : ?>
							<img src="<?php echo esc_url(swiftcart_get_option('swiftcart_preloader_iamge')); ?>" alt="<?php echo esc_attr("preloader", 'swiftcart') ?>">
						<?php endif; ?>
					</div>
				</div>
<?php
			endif;
		}
	} //end class

	Swiftcart_General_Hook::getInstance();
} //endif