<?php

/**
 * theme init class
 * */
if (!defined('ABSPATH')) {
	exit(); //exit if access directly
}

if (!class_exists('Swiftcart_Init')) {

	class Swiftcart_Init {

		private static $instance;

		public function __construct() {
			//theme setup
			add_action('after_setup_theme', array($this, 'theme_setup'));
			//widget init
			add_action('widgets_init', array($this, 'widgets_init'));
			//theme assets
			add_action('wp_enqueue_scripts', array($this, 'theme_assets'), 98);
		}

		/**
		 * getInstance();
		 * @since 1.0.0
		 * */
		public static function getInstance() {
			if (null == self::$instance) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * theme setup
		 * @since 1.0.0
		 * */
		public function theme_setup() {
			/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on swiftcart, use a find and replace
		 * to change 'swiftcart' to the name of your theme in all the template files.
		 */
			load_theme_textdomain('swiftcart', get_template_directory() . '/languages');

			// Add default posts and comments RSS feed links to head.
			add_theme_support('automatic-feed-links');

			/*
			 * Let WordPress manage the document title.
			 * By adding theme support, we declare that this theme does not use a
			 * hard-coded <title> tag in the document head, and expect WordPress to
			 * provide it for us.
			 */
			add_theme_support('title-tag');

			// Set post thumbnail size.
			set_post_thumbnail_size(856, 450, true);

			/*
			/*
			 * Enable support for Post Thumbnails on posts and pages.
			 *
			 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
			 */
			add_theme_support('post-thumbnails');


			// This theme uses wp_nav_menu() in one location.
			register_nav_menus(array(
				'main-menu' => esc_html__('Primary Menu', 'swiftcart'),
			));

			// editor style
			add_editor_style();

			/*
			 * Switch default core markup for search form, comment form, and comments
			 * to output valid HTML5.
			 */
			add_theme_support('html5', array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
			));

			// Set up the WordPress core custom background feature.
			add_theme_support('custom-background', apply_filters('swiftcart_custom_background_args', array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)));

			// Add theme support for selective refresh for widgets.
			add_theme_support('customize-selective-refresh-widgets');

			/**
			 * Add support for core custom logo.
			 *
			 * @link https://codex.wordpress.org/Theme_Logo
			 */
			add_theme_support('custom-logo', array(
				'height'      => 150,
				'width'       => 300,
				'flex-width'  => true,
				'flex-height' => true,
			));

			// This variable is intended to be overruled from themes.
			// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
			// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
			$GLOBALS['content_width'] = apply_filters('swiftcart_content_width', 640);


			//load theme dependency files
			$this->include_files();
		}


		/**
		 * widgets_init
		 * @since 1.0.0
		 * */
		public function widgets_init() {

			register_sidebar(array(
				'name'          => esc_html__('Sidebar', 'swiftcart'),
				'id'            => 'sidebar-1',
				'description'   => esc_html__('Add Sidebar widgets here.', 'swiftcart'),
				'before_widget' => '<div id="%1$s" class="sw-sidebar__widget widget %2$s widget-border">',
				'after_widget'  => '</div>',
				'before_title'  => '<h4 class="widget-title sw-sidebar__widget-title">',
				'after_title'   => '</h4>',
			));
			register_sidebar(array(
				'name' => esc_html__('Product Sidebar', 'swiftcart'),
				'id' => 'product-sidebar',
				'before_widget' => '<div id="%1$s" class="sw-sidebar__widget product-widgets side-cat %2$s mb-45">',
				'after_widget' => '</div>',
				'before_title' => '<h6 class="product-widget-title sw-sidebar__widget-title">',
				'after_title' => '</h6>',
			));
		}

		/**
		 * include files
		 * @since 1.0.0
		 * */
		public function include_files() {

			require_once get_template_directory() . '/inc/breadcrumb.php';

			require_once get_template_directory() . '/inc/class-swiftcart-general-hooks.php';

			require_once get_template_directory() . '/inc/plugins/tgma/activate.php';
		}

		/**
		 * theme assets
		 * @since 1.0.0
		 * */
		public function theme_assets() {
			$this->theme_css();
			$this->theme_js();
		}

		/*
		*swiftcart load font
		*/
		public static function swiftcart_fonts_url() {

			$font_url = '';

			/*
			Translators: If there are characters in your language that are not supported
			by chosen font(s), translate this to 'off'. Do not translate into your own language.
			 */
			if ('off' !== _x('on', 'Google font: on or off', 'swiftcart')) {
				$font_families = array(
					'Public Sans:300,300i,400,400i,500,500i,600,600i,700,700i',
					'Inter:300,300i,400,400i,500,500i,600,600i,700,700i',
				);

				$familyArgs = array(
					'family' => urlencode(implode('|', $font_families)),
					'subset' => urlencode('latin,latin-ext'),
				);

				$fontUrl = add_query_arg($familyArgs, '//fonts.googleapis.com/css');
			}
			return esc_url_raw($fontUrl);
		}

		/**
		 * theme css
		 * @since 1.0.0
		 * */
		public function theme_css() {
			wp_enqueue_style('swiftcart-font', self::swiftcart_fonts_url(), array(), SWIFTCART_VERSION, 'all');
			wp_enqueue_style('swiftcart-custom-icon', SWIFTCART_VENDORS . '/swiftcart-icons/style.css', array(), SWIFTCART_VERSION, 'all');
			wp_enqueue_style('fontawesome', SWIFTCART_VENDORS . '/fontawesome/css/all.min.css', array(), SWIFTCART_VERSION, 'all');
			wp_enqueue_style('bootstrap', SWIFTCART_VENDORS . '/bootstrap/css/bootstrap.min.css', array(), SWIFTCART_VERSION, 'all');
			wp_enqueue_style('spacing', SWIFTCART_VENDORS . '/spacing/spacing.css', array(), SWIFTCART_VERSION, 'all');
			wp_enqueue_style('meanmenu', SWIFTCART_VENDORS . '/meanmenu/css/meanmenu.css', array(), SWIFTCART_VERSION, 'all');

			$swiftcart_dynamic_rtl_mode_status = isset($_GET['rtl']) ? $_GET['rtl'] : 'no';

			if (1 == swiftcart_switcher_option('rtl_enable') || ('yes' == $swiftcart_dynamic_rtl_mode_status)) {
				wp_enqueue_style('swiftcart-main-rtl-style', SWIFTCART_CSS . '/swiftcart-rtl.css', array(), SWIFTCART_VERSION, 'all');
				wp_enqueue_style('swiftcart-rtl-style', get_theme_file_uri() . '/style-rtl.css', array(), SWIFTCART_VERSION, 'all');
				wp_enqueue_style('swiftcart-custom-rtl', SWIFTCART_CSS . '/custom-rtl.css', array(), SWIFTCART_VERSION, 'all');
			} else {
				wp_enqueue_style('swiftcart-main-style', SWIFTCART_CSS . '/swiftcart.css', array(), SWIFTCART_VERSION, 'all');
				wp_enqueue_style('swiftcart-custom-style', SWIFTCART_CSS . '/swiftcart-custom.css', array(), SWIFTCART_VERSION, 'all');
				wp_enqueue_style('swiftcart-style', get_stylesheet_uri());
			}
		}

		/**
		 * theme js
		 * @since 1.0.0
		 * */
		public function theme_js() {

			wp_enqueue_script('bootstrap',  SWIFTCART_VENDORS . '/bootstrap/js/bootstrap.bundle.min.js', array('jquery'), SWIFTCART_VERSION, true);
			wp_enqueue_script('meanmenu',  SWIFTCART_VENDORS . '/meanmenu/js/meanmenu.js', array('jquery'), SWIFTCART_VERSION, true);
			wp_enqueue_script('isotope',  SWIFTCART_VENDORS . '/isotope/isotope.js', array('jquery'), SWIFTCART_VERSION, true);
			wp_enqueue_script('swiftcart-main-script',  SWIFTCART_JS . '/main.js', array('jquery'), SWIFTCART_VERSION, true);

			if (is_singular() && comments_open() && get_option('thread_comments')) {
				wp_enqueue_script('comment-reply');
			}
		}
	} //end class

	Swiftcart_Init::getInstance();
}
