<?php

/**
 *
 * @package swiftcart
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 *
 * @return array
 */


add_filter('body_class',  'swiftcart_body_classes');
add_action('wp_head',  'swiftcart_pingback_header');


/**
 * swiftcart_body_classes
 * @since 1.0.0
 * */
if (!function_exists('swiftcart_body_classes')) :
	function swiftcart_body_classes($classes)
	{
		// Adds a class of hfeed to non-singular pages.
		if (!is_singular()) {
			$classes[] = 'hfeed';
		}

		// Adds a class of no-sidebar when there is no sidebar present.
		if (!is_active_sidebar('sidebar-1')) {
			$classes[] = 'no-sidebar';
		}

		return $classes;
	}
endif;

if (!function_exists('swiftcart_post_query')) {
	function swiftcart_post_query($post_type)
	{
		$post_list = get_posts(array(
			'post_type' => $post_type,
			'showposts' => -1,
		));
		$posts = array();

		if (!empty($post_list) && !is_wp_error($post_list)) {
			foreach ($post_list as $post) {
				$options[$post->ID] = $post->post_title;
			}
			return $options;
		}
	}
}

if (!function_exists('swiftcart_givewp_excerpt')) :

	// Post's excerpt text
	function swiftcart_givewp_excerpt($get_limit_value, $echo = true)
	{
		$opt = $get_limit_value;
		$excerpt_limit = !empty($opt) ? $opt : 40;
		$excerpt = wp_trim_words(get_the_excerpt(), $excerpt_limit, '');
		if ($echo == true) {
			echo esc_html($excerpt);
		} else {
			return esc_html($excerpt);
		}
	}

endif;

/**
 * pingback_header
 * @since 1.0.0
 * */
if (!function_exists('swiftcart_pingback_header')) :
	function swiftcart_pingback_header()
	{
		if (is_singular() && pings_open()) {
			printf('<link rel="pingback" href="%s">', esc_url(get_bloginfo('pingback_url')));
		}
	}

endif;

/*
* Pages Links
*
* @since 1.0.0
*/
if (!function_exists('swiftcart_link_pages')) :
	function swiftcart_link_pages()
	{
		$defaults = array(
			'before'         => '<div class="wp-link-pages"><span>' . esc_html__('Pages:', 'swiftcart') . '</span>',
			'after'          => '</div>',
			'link_before'    => '',
			'link_after'     => '',
			'next_or_number' => 'number',
			'separator'      => ' ',
			'pagelink'       => '%',
			'echo'           => 1
		);
		wp_link_pages($defaults);
	}

endif;



if (!function_exists('swiftcart_excerpt')) :
	// Post excerpt
	function swiftcart_excerpt($get_limit_value = 40, $echo = true)
	{
		$opt = $get_limit_value;
		$excerpt_limit = !empty($opt) ? $opt : 40;
		$excerpt = wp_trim_words(get_the_content(), $excerpt_limit, '');
		if ($echo == true) {
			echo esc_html($excerpt);
		} else {
			return esc_html($excerpt);
		}
	}
endif;

// custom kses allowed html
if (!function_exists('swiftcart_core_allowed_tags')) :
	function swiftcart_core_allowed_tags($tags, $context)
	{
		switch ($context) {
			case 'swiftcart_core_allowed_tags':
				$tags = array(
					'a' => array('href' => array(), 'class' => array()),
					'b' => array(),
					'br' => array(),
					'span' => array('class' => array(), 'data-count' => array()),
					'img' => array('class' => array()),
					'i' => array('class' => array()),
					'p' => array('class' => array()),
					'ul' => array('class' => array()),
					'li' => array('class' => array()),
					'div' => array('class' => array()),
					'strong' => array()
				);
				return $tags;
			default:
				return $tags;
		}
	}

	add_filter('wp_kses_allowed_html', 'swiftcart_core_allowed_tags', 10, 2);

endif;

/**
 * Swiftcart layout options
 * @since 1.0.0
 * */
if (!function_exists('swiftcart_pagination')) :
	function swiftcart_pagination()
	{
		global $wp_query;
		$links = paginate_links(array(
			'current'   => max(1, get_query_var('paged')),
			'total'     => $wp_query->max_num_pages,
			'prev_text' => '<i class="fa-solid fa-angle-left"></i>',
			'next_text' => '<i class="fa-solid fa-angle-right"></i>',
		));

		// Check if $links is not null before passing to wp_kses
		if ($links !== null) {
			echo wp_kses($links, 'swiftcart_core_allowed_tags');
		}
	}
endif;

/*
*header
*
* @since 1.0.0
* */

if (!function_exists('swiftcart_get_header')) :
	function swiftcart_get_header()
	{

		$swiftcart_header_style = get_post_meta(get_queried_object_id(), 'swiftcart_page_meta', true); // only for page
		$enable_header_builder = swiftcart_get_option('enable_header_builder');

		if (is_page() && isset($swiftcart_header_style['enable_header_builder']) && $swiftcart_header_style['enable_header_builder']) {
			get_template_part('template-parts/header/header-builder');
		} elseif ($enable_header_builder) {
			get_template_part('template-parts/header/header-builder');
		} else {
			get_template_part('template-parts/header/default-header');
		}
	}

endif;


if (!function_exists('swiftcart_get_footer')) :
	function swiftcart_get_footer()
	{
		$swiftcart_footer_style = get_post_meta(get_queried_object_id(), 'swiftcart_page_meta', true); // only for page
		$enable_footer_builder = swiftcart_get_option('enable_footer_builder');

		if (is_page() && isset($swiftcart_footer_style['enable_footer_builder']) && $swiftcart_footer_style['enable_footer_builder']) {
			get_template_part('template-parts/footer/footer-builder');
		} elseif ($enable_footer_builder) {
			get_template_part('template-parts/footer/footer-builder');
		} else {
			get_template_part('template-parts/footer/default-footer');
		}
	}

endif;

/*
*  header builder
*/
if (!function_exists('swiftcart_get_header_builder_library')) :
	function swiftcart_get_header_builder_library()
	{

		$pageslist = get_posts(array(
			'post_type'      => 'header-builder',
			'posts_per_page' => -1
		));

		$pagearray = array();
		if (!empty($pageslist)) {
			foreach ($pageslist as $page) {
				$pagearray[$page->ID] = $page->post_title;
			}
		}

		return $pagearray;
	}

endif;


/*
*  header builder
*/
if (!function_exists('swiftcart_get_footer_builder_library')) :
	function swiftcart_get_footer_builder_library()
	{

		$pageslist = get_posts(array(
			'post_type'      => 'footer-builder',
			'posts_per_page' => -1
		));

		$pagearray = array();
		if (!empty($pageslist)) {
			foreach ($pageslist as $page) {
				$pagearray[$page->ID] = $page->post_title;
			}
		}

		return $pagearray;
	}
endif;

/*
* meta query
* @since 1.0.0
* */
if (!function_exists('swiftcart_meta_query')) :
	function swiftcart_meta_query($prefix, $id)
	{
		global $post;
		$meta = '';
		if (!empty($post->ID)) {
			$meta = get_post_meta($post->ID, $prefix, true);
			$meta = (isset($meta[$id]) && !empty($meta[$id])) ? $meta[$id] : '';
		}

		return $meta;
	}

endif;

if (!function_exists('swiftcart_entry_footer')) :
	function swiftcart_entry_footer()
	{
		if ('post' === get_post_type()) :
?>

			<div class="sw-postbox__cats catscloud">
				<?php /* translators: used between list items, there is a space after the comma */
				$categories_list = get_the_category_list(esc_html__(' ', 'swiftcart'));
				if ($categories_list) {
					/* translators: 1: list of categories. */
					printf('<span>' . esc_html__('Categories: ', 'swiftcart') . '</span> %1$s', '' . $categories_list); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				} ?>
			</div>
			<div class="sw-postbox__tags tagcloud">
				<?php
				$tags_list = get_the_tag_list('', ' ');
				if ($tags_list) {
					/* translators: 1: list of tags. */
					printf('<div class="tags d-inline-block"><span>' . esc_html__('Tags: ', 'swiftcart') . '</span> %1$s </div>', '' . $tags_list); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				}
				?>
			</div>

	<?php endif;
	}

endif;

/**
 * Swiftcart layout options
 * @since 1.0.0
 * */
if (!function_exists('swiftcart_page_layout_options')) :
	function swiftcart_page_layout_options($arg)
	{
		$return_var = [];
		$sidebar = is_active_sidebar('sidebar-1') ? true : false;
		$default_sidebar = $sidebar ? 'right-sidebar' : '';
		$return_var['layout'] = swiftcart_get_option('swiftcart_' . $arg . '_layout') ? swiftcart_get_option('swiftcart_' . $arg . '_layout')  : $default_sidebar;
		$return_var['sidebar_enable'] = ('left-sidebar' == $return_var['layout'] || 'right-sidebar' == $return_var['layout']) ? true : false;
		$return_var['main_content_class'] = ('left-sidebar' == $return_var['layout'] || 'right-sidebar' == $return_var['layout'])  ? 'col-lg-8' : 'col-lg-12';
		$return_var['sidebar_class'] = ('left-sidebar' == $return_var['layout'] || 'right-sidebar' == $return_var['layout'])  ? 'col-lg-4' : 'col-lg-4';
		$return_var['sidebar_class'] = 'left-sidebar' == $return_var['layout'] ? 'col-lg-4 order-first' : $return_var['sidebar_class'];
		$return_var['sidebar_class'] = (isset($_GET['sidebar']) && $_GET['sidebar'] == 'left-align') ? 'col-lg-4 order-first' : $return_var['sidebar_class'];

		return $return_var;
	}

endif;
if (!function_exists('swiftcart_property_layout_options')) :
	function swiftcart_property_layout_options($arg)
	{
		$return_var = [];
		$sidebar = is_active_sidebar('property') ? true : false;
		$default_sidebar = $sidebar ? 'right-sidebar' : '';
		$return_var['layout'] = swiftcart_get_option('swiftcart_' . $arg . '_layout') ? swiftcart_get_option('swiftcart_' . $arg . '_layout')  : $default_sidebar;
		$return_var['sidebar_enable'] = ('left-sidebar' == $return_var['layout'] || 'right-sidebar' == $return_var['layout']) ? true : false;
		$return_var['main_content_class'] = ('left-sidebar' == $return_var['layout'] || 'right-sidebar' == $return_var['layout'])  ? 'col-lg-8' : 'col-lg-12';
		$return_var['sidebar_class'] = ('left-sidebar' == $return_var['layout'] || 'right-sidebar' == $return_var['layout'])  ? 'col-lg-4' : 'col-lg-4';
		$return_var['sidebar_class'] = 'left-sidebar' == $return_var['layout'] ? 'col-lg-4 order-first' : $return_var['sidebar_class'];
		$return_var['sidebar_class'] = (isset($_GET['sidebar']) && $_GET['sidebar'] == 'left-align') ? 'col-lg-4 order-first' : $return_var['sidebar_class'];

		return $return_var;
	}

endif;


add_filter('comment_form_fields', 'swiftcart_move_comment_field_to_bottom', 99, 1);
function swiftcart_move_comment_field_to_bottom($fields)
{
	$comment_field   = $fields['comment'];
	$comment_cookies = $fields['cookies'];
	unset($fields['comment']);
	unset($fields['cookies']);
	$fields['comment'] = $comment_field;
	$fields['cookies'] = $comment_cookies;

	return $fields;
}


if (!function_exists('swiftcart_custom_query_pagination')) :
	/**
	 * Prints HTML with post pagination links.
	 */
	function swiftcart_custom_query_pagination($paged = '', $max_page = '')
	{
		global $wp_query;
		$big = 999999999; // need an unlikely integer
		if (!$paged)
			$paged = get_query_var('paged');
		if (!$max_page)
			$max_page = $wp_query->max_num_pages;

		$links = paginate_links(array(
			'base'       => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
			'format'     => '?paged=%#%',
			'current'    => max(1, $paged),
			'total'      => $max_page,
			'mid_size'   => 1,
			'prev_text' => '<i class="fa fa-angle-left"></i>',
			'next_text' => '<i class="fa fa-angle-right"></i>',
		));

		echo wp_kses($links, 'swiftcart_core_allowed_tags');
	}
endif;


// Ajax Cart Count
add_filter('woocommerce_add_to_cart_fragments', 'swiftcart_refresh_mini_cart_count');
function swiftcart_refresh_mini_cart_count($fragments)
{
	ob_start();
	?>
	<span class="badge cart-count"><?php echo esc_html(WC()->cart->get_cart_contents_count()); ?></span>
<?php
	$fragments['.cart-count'] = ob_get_clean();
	return $fragments;
}
