<?php

/**
 * WooCommerce Compatibility File
 *
 * @link https://woocommerce.com/
 *
 * @package swiftcart
 */

/**
 * WooCommerce setup function.
 *
 * @link https://docs.woocommerce.com/document/third-party-custom-theme-compatibility/
 * @link https://github.com/woocommerce/woocommerce/wiki/Enabling-product-gallery-features-(zoom,-swipe,-lightbox)
 * @link https://github.com/woocommerce/woocommerce/wiki/Declaring-WooCommerce-support-in-themes
 *
 * @return void
 */
function swiftcart_woocommerce_setup() {
    add_theme_support(
        'woocommerce',
        array(
            'thumbnail_image_width' => 180,
            'single_image_width'    => 600,
            'product_grid'          => array(
                'default_rows'    => 3,
                'min_rows'        => 1,
                'default_columns' => 3,
                'min_columns'     => 1,
                'max_columns'     => 6,
            ),
        )
    );
    add_theme_support('wc-product-gallery-zoom');
    add_theme_support('wc-product-gallery-lightbox');
    add_theme_support('wc-product-gallery-slider');
}
add_action('after_setup_theme', 'swiftcart_woocommerce_setup');


/**
 * WooCommerce specific scripts & stylesheets.
 *
 * @return void
 */
function swiftcart_woocommerce_scripts() {
    $font_path   = WC()->plugin_url() . '/assets/fonts/';
    $inline_font = '@font-face {
			font-family: "star";
			src: url("' . $font_path . 'star.eot");
			src: url("' . $font_path . 'star.eot?#iefix") format("embedded-opentype"),
				url("' . $font_path . 'star.woff") format("woff"),
				url("' . $font_path . 'star.ttf") format("truetype"),
				url("' . $font_path . 'star.svg#star") format("svg");
			font-weight: normal;
			font-style: normal;
		}';

    wp_add_inline_style('swiftcart-style', $inline_font);
}
add_action('wp_enqueue_scripts', 'swiftcart_woocommerce_scripts', 99);

/**
 * Disable the default WooCommerce stylesheet.
 *
 * Removing the default WooCommerce stylesheet and enqueing your own will
 * protect you during WooCommerce core updates.
 *
 * @link https://docs.woocommerce.com/document/disable-the-default-stylesheet/
 */

add_filter('woocommerce_enqueue_styles', '__return_empty_array');

// shop page hooks
// breadcrumb remove
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
// remove ordering
remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);
// remove shop sidebar
remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar', 10);

// content-product hooks--
// action remove
remove_action('woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);
remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10);
remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10);
remove_action('woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10);
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5);
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);


// single product
add_action('woocommerce_single_product_summary', 'swiftcart_woo_rating', 5);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10);
add_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 15);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
add_action('woocommerce_after_add_to_cart_form', 'swiftcart_details_wishlish', 40);
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 41);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50);
if (function_exists('swiftcart_blog_social_share')) {
    add_action('woocommerce_single_product_summary', 'swiftcart_blog_social_share', 50);
}

add_action('woocommerce_before_add_to_cart_form', 'woocommerce_before_add_to_cart_form_action');

function woocommerce_before_add_to_cart_form_action() {
    echo "<div class='product__details-action d-flex flex-wrap align-items-end'>";
}

function swiftcart_details_wishlish() {
    if (class_exists('WPCleverWoosw')) {
        echo do_shortcode('[woosw]');
    }
    if (class_exists('WPCleverWoosq')) {
        echo do_shortcode('[woosq]');
    }
    echo '</div>';
}



// woocommerce mini cart content
add_filter('woocommerce_add_to_cart_fragments', function ($fragments) {
    ob_start();
?>
    <div class="mini-shopping-cart-box">
        <?php woocommerce_mini_cart(); ?>
    </div>
    <?php $fragments['.mini-shopping-cart-box'] = ob_get_clean();
    return $fragments;
});

// woocommerce mini cart count icon
if (! function_exists('swiftcart_header_add_to_cart_fragment')) {
    function swiftcart_header_add_to_cart_fragment($fragments) {
        ob_start();
    ?>
        <span class="cart__count" id="generic-el-cart-item">
            <?php echo esc_html(WC()->cart->cart_contents_count); ?>
        </span>
    <?php
        $fragments['#generic-el-cart-item'] = ob_get_clean();

        return $fragments;
    }
}
add_filter('woocommerce_add_to_cart_fragments', 'swiftcart_header_add_to_cart_fragment');


// product-content
if (!function_exists('swiftcart_loop_product_thumbnail')) {
    function swiftcart_loop_product_thumbnail() {
        global $product;
        global $post;
        global $woocommerce;
        $rating = wc_get_rating_html($product->get_average_rating());
        $ratingcount = $product->get_review_count();
    ?>
        <div class="sw-product-six__item">
            <?php if (has_post_thumbnail()) : ?>
                <div class="sw-product-six__img">
                    <?php if (function_exists('woocommerce_template_loop_product_thumbnail')) : ?>
                        <?php woocommerce_template_loop_product_thumbnail(); ?>
                    <?php endif; ?>
                    <?php
                    $regular_price = (float) $product->get_regular_price();
                    $sale_price    = (float) $product->get_sale_price();
                    $percentage = '';
                    if ($sale_price != 0 || ! empty($sale_price)) {
                        $percentage    = round(100 - ($sale_price / $regular_price * 100)) . '%';
                    } ?>
                    <?php if (!empty($percentage)): ?>
                        <span class="sw-product-six__offer"><?php echo esc_html($percentage); ?></span>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <h5 class="sw-product-six__price"><?php echo woocommerce_template_loop_price(); ?></h5>
            <h3 class="sw-product-six__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
            <div class="sw-product-six__ratting">
                <?php echo swiftcart_woo_rating(); ?>
            </div>
            <div class="sw-product-six__btns">
                <?php woocommerce_template_loop_add_to_cart(); ?>
                <?php
                if (class_exists('WPCleverWoosw')) {
                    echo do_shortcode('[woosw]');
                }
                ?>
            </div>
        </div>
    <?php
    }
}
add_action('woocommerce_before_shop_loop_item', 'swiftcart_loop_product_thumbnail', 10);

add_filter('woosq_button_html', 'swiftcart_woosq_button_html', 10, 2);
function swiftcart_woosq_button_html($output, $prodid) {
    return $output = '<button class="icon-btn woosq-btn product-action-btn woosq-btn-' . esc_attr($prodid) . ' ' . get_option('woosq_button_class') . '" data-id="' . esc_attr($prodid) . '" data-effect="mfp-3d-unfold"><i class="icon-eye"></i></button>';
}



// add to cart button
function woocommerce_template_loop_add_to_cart($args = array()) {
    global $product;
    if ($product) { ?>
        <div class="product__add-to-cart">
            <?php
            global $product;
            $swiftcart_ajax_cart_class = (get_option('woocommerce_enable_ajax_add_to_cart') == 'yes' ? 'swiftcart_ajax' : '');
            if ($product->is_type('variable')) {

                echo sprintf(
                    '<a href="%s" class="%s">%s</a>',
                    esc_url($product->add_to_cart_url()),
                    esc_attr(implode(' ', array_filter(array(
                        'button',
                        'product_type_' . $product->get_type(),
                        'swiftcart-btn-black add_to_cart_button'
                    )))),
                    esc_html($product->add_to_cart_text())
                );
            } else {
                echo sprintf(
                    '<a href="%s" data-quantity="1" class="%s" %s>%s</a>',
                    esc_url($product->add_to_cart_url()),
                    esc_attr(implode(' ', array_filter(array(
                        'button',
                        'product_type_' . $product->get_type(),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                        $product->supports('ajax_add_to_cart') ? 'swiftcart-btn-black product__all-btn add_to_cart_button ajax_add_to_cart' : 'swiftcart-btn-black shop-one__cart add_to_cart_button ',
                        $swiftcart_ajax_cart_class
                    )))),
                    wc_implode_html_attributes(array(
                        'data-product_id'  => $product->get_id(),
                        'data-product_sku' => $product->get_sku(),
                        'aria-label'       => $product->add_to_cart_description(),
                        'rel'              => 'nofollow',
                    )),
                    esc_html($product->add_to_cart_text())
                );
            }
            ?>
        </div>
<?php }
}


/**
 * [swiftcart_woo_rating description]
 * @return [type] [description]
 */


function swiftcart_woo_rating() {
    global $product;
    $rating = $product->get_average_rating();
    $review = 'Rating ' . $rating . ' out of 5';
    $review_count = $product->get_review_count();
    $html   = '';
    $html   .= '<div class="details-rating mb-10" title="' . $review . '">';
    for ($i = 0; $i <= 4; $i++) {
        if ($i < floor($rating)) {
            $html .= '<i class="fas fa-star"></i> ';
        } else {
            $html .= '<i class="far fa-star"></i> ';
        }
    }
    // $html .= '<span>( ' . $rating . ' out of 5 )</span>';
    $html .= '<span>( ' . $review_count . ' )</span>';
    $html .= '</div>';
    print swiftcart_woo_rating_html($html);
}

function swiftcart_woo_rating_html($html) {
    return $html;
}

function swiftcart_woo_cart_one($args = array()) {
    global $product;

    if ($product) {
        $defaults = array(
            'quantity'   => 1,
            'class'      => implode(
                ' ',
                array_filter(
                    array(
                        'sw-product-eight__action',
                        'product_type_' . $product->get_type(),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                        $product->supports('ajax_add_to_cart') && $product->is_purchasable() && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
                    )
                )
            ),
            'classtwo'      => implode(
                ' ',
                array_filter(
                    array(
                        'cart-btn',
                        'product_type_' . $product->get_type(),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                        $product->supports('ajax_add_to_cart') && $product->is_purchasable() && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
                    )
                )
            ),
            'attributes' => array(
                'data-product_id'  => $product->get_id(),
                'data-product_sku' => $product->get_sku(),
                'aria-label'       => $product->add_to_cart_description(),
                'rel'              => 'nofollow',
            ),
        );

        $args = wp_parse_args($args, $defaults);

        if (isset($args['attributes']['aria-label'])) {
            $args['attributes']['aria-label'] = wp_strip_all_tags($args['attributes']['aria-label']);
        }
    }

    echo sprintf(
        '<a href="%s" class="%s" data-quantity="%s" %s ><i class="icon-shopping-cart"></i><em class="sw-product-eight__tooltip">%s</em></a>',
        esc_url($product->add_to_cart_url()),
        esc_attr(isset($args['class']) ? $args['class'] : 'cart-button'),
        esc_attr(isset($args['quantity']) ? $args['quantity'] : 1),
        isset($args['attributes']) ? wc_implode_html_attributes($args['attributes']) : '',
        esc_html__('Add To Cart', 'swiftcart-core'),
    );
}
function swiftcart_woo_cart_two($args = array()) {
    global $product;

    if ($product) {
        $defaults = array(
            'quantity'   => 1,
            'class'      => implode(
                ' ',
                array_filter(
                    array(
                        '',
                        'product_type_' . $product->get_type(),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                        $product->supports('ajax_add_to_cart') && $product->is_purchasable() && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
                    )
                )
            ),
            'classtwo'      => implode(
                ' ',
                array_filter(
                    array(
                        'cart-btn',
                        'product_type_' . $product->get_type(),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                        $product->supports('ajax_add_to_cart') && $product->is_purchasable() && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
                    )
                )
            ),
            'attributes' => array(
                'data-product_id'  => $product->get_id(),
                'data-product_sku' => $product->get_sku(),
                'aria-label'       => $product->add_to_cart_description(),
                'rel'              => 'nofollow',
            ),
        );

        $args = wp_parse_args($args, $defaults);

        if (isset($args['attributes']['aria-label'])) {
            $args['attributes']['aria-label'] = wp_strip_all_tags($args['attributes']['aria-label']);
        }
    }

    echo sprintf(
        '<a href="%s" class="%s" data-quantity="%s" %s ><i class="icon-grocery-store"></i></a>',
        esc_url($product->add_to_cart_url()),
        esc_attr(isset($args['class']) ? $args['class'] : 'cart-button'),
        esc_attr(isset($args['quantity']) ? $args['quantity'] : 1),
        isset($args['attributes']) ? wc_implode_html_attributes($args['attributes']) : '',
    );
}
