<?php

/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package swiftcart
 */
get_header();
$swiftcart_layout = swiftcart_page_layout_options('single_page');
?>
<div id="primary" class="content-area swiftcart-blog-details pb-80 pt-80">
	<main id="main" class="site-main">
		<div class="single-blog-page">
			<div class="container">
				<div class="row">
					<div class="<?php echo esc_attr($swiftcart_layout['main_content_class']); ?>">
						<div class="blog-details-page-content">
							<?php
							while (have_posts()) :
								the_post();

								get_template_part('template-parts/content', 'single');

								// If comments are open or we have at least one comment, load up the comment template.
								if (comments_open() || get_comments_number()) :
									comments_template();
								endif;

							endwhile; // End of the loop.
							?>
						</div>
					</div>
					<?php if ($swiftcart_layout['sidebar_enable']) : ?>
						<div class="<?php echo esc_attr($swiftcart_layout['sidebar_class']); ?>">
							<?php get_sidebar(); ?>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</main><!-- #main -->
</div><!-- #primary -->

<?php get_footer();
