<?php
get_header(); // Include the header

// Start the Loop
if (have_posts()) : ?>
    <header class="page-header">
        <h1 class="page-title"><?php printf(__('Search Results for: %s', 'swiftcart'), '<span>' . get_search_query() . '</span>'); ?></h1>
    </header>

    <div class="products-grid">
        <?php
        while (have_posts()) : the_post();
            // Check if the post type is 'product'
            if ('product' === get_post_type()) {
                wc_get_template_part('content', 'product'); // Use WooCommerce's template part for products
            }
        endwhile; ?>
    </div>

<?php
    // Pagination
    the_posts_navigation();
else : ?>
    <p><?php _e('No products found matching your search criteria.', 'swiftcart'); ?></p>
<?php endif;

get_footer(); // Include the footer