<?php

/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package swiftcart
 */

get_header();
$swiftcart_layout = swiftcart_page_layout_options('single_page');
?>

<div id="primary" class="content-area swiftcart-blog-details pb-80 pt-80">
    <main id="main" class="site-main">
        <div class="single-blog-page">
            <div class="container">
                <div class="row gutter-y-60">
                    <div class="<?php echo esc_attr($swiftcart_layout['main_content_class']); ?>">
                        <div class="row gutter-y-40">
                            <div class="blog-details-page-inner pb-lg-5">
                                <div class="single-blog-inner bg-none">
                                    <?php
                                    while (have_posts()) :
                                        the_post();

                                        get_template_part('template-parts/content', 'single');

                                        // If comments are open or we have at least one comment, load up the comment template.
                                        if (comments_open() || get_comments_number()) :
                                            comments_template();
                                        endif;

                                    endwhile; // End of the loop.
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php if ($swiftcart_layout['sidebar_enable']) : ?>
                        <div class="<?php echo esc_attr($swiftcart_layout['sidebar_class']); ?>">
                            <?php get_sidebar(); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </main><!-- #main -->
</div><!-- #primary -->
<?php get_footer();
