<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package swiftcart
 */

?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="sw-blog-details__wrapper single-blog-inner">
		<?php if (has_post_thumbnail()): ?>
			<div class="sw-blog-list__thumb mb-0 w-img">
				<?php swiftcart_post_thumbnail(); ?>
			</div>
		<?php endif; ?>
		<?php if ('post' === get_post_type()) : ?>
			<ul class="sw-blog-list__meta list-unstyled">
				<?php $cats =  get_the_category(); ?>
				<?php if (!empty($cats[0]->name)) : ?>
					<li class="sw-post-cat">
						<a href="<?php echo esc_url(get_category_link($cats[0]->term_id)); ?>"><i class="fas fa-tag"></i> <?php echo esc_html($cats[0]->name); ?></a>
					</li>
				<?php endif; ?>
				<li class="sw-post-comment">
					<span><i class="fas fa-comment"></i><?php comments_popup_link(); ?></span>
				</li>
				<?php $word_count = str_word_count(strip_tags(get_the_content()));
				$reading_speed = 200; // average reading speed in words per minute
				$minutes = ceil($word_count / $reading_speed);
				$read_time = $minutes . ' min read'; ?>
				<li><span class="sw-post-view"><i class="fa-solid fa-clock"></i> <?php echo esc_html($read_time, 'swiftcart'); ?></span></li>
			</ul>
		<?php endif; ?>
		<h3 class="sw-postbox__title d-none"><?php the_title(); ?></h3>
		<div class="swiftcart-page-inner-content">
			<?php
			the_content(
				sprintf(
					wp_kses(
						/* translators: %s: Name of current post. Only visible to screen readers */
						esc_html__('Continue reading', 'swiftcart') . '<span class="screen-reader-text"> "%s"</span>',
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					wp_kses_post(get_the_title())
				)
			);

			wp_link_pages(
				array(
					'before' => '<div class="link-page">' . esc_html__('Pages:', 'swiftcart'),
					'after'  => '</div>',
				)
			);
			?>
		</div>
		<?php if (has_tag() || has_category()) : ?>
			<footer class="sw-blog-details_tag">
				<?php swiftcart_entry_footer();  ?>
			</footer><!-- .entry-footer -->
		<?php endif; ?>
	</div>


</article>