<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package swiftcart
 */

?>
<!--===  Blog Post Item  ===-->

<?php $has_post_thumbnail = has_post_thumbnail() ? '' : 'no_post_thumbnail'; ?>
<article id="post-<?php the_ID(); ?>" <?php post_class('sw-blog-article'); ?>>
	<div class="sw-blog">
		<div class="sw-blog-list__item wow swfadeUp" data-wow-delay='100ms'>
			<?php if (has_post_thumbnail()): ?>
				<div class="sw-blog-list__thumb sw-blog-list__thumb-size w-img">
					<!-- "sw-blog-list__thumb-size" remove this on wp -->
					<?php swiftcart_post_thumbnail(); ?>
					<div class="sw-blog-list__meta-2">
						<span><?php echo swiftcart_posted_by(); ?></span>
						<span><?php echo get_the_date(); ?></span>
					</div>
				</div>
			<?php endif; ?>
			<div class="sw-blog-list__content">
				<h3 class="sw-blog-list__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
				<ul class="sw-blog-list__meta list-unstyled">
					<?php $cats =  get_the_category(); ?>
					<?php if (!empty($cats[0]->name)) : ?>
						<li class="sw-post-cat">
							<a href="<?php echo esc_url(get_category_link($cats[0]->term_id)); ?>"><i class="fas fa-tag"></i> <?php echo esc_html($cats[0]->name); ?></a>
						</li>
					<?php endif; ?>
					<li class="sw-post-comment">
						<span><i class="fas fa-comment"></i><?php comments_popup_link(); ?></span>
					</li>
					<?php $word_count = str_word_count(strip_tags(get_the_content()));
					$reading_speed = 200; // average reading speed in words per minute
					$minutes = ceil($word_count / $reading_speed);
					$read_time = $minutes . ' min read'; ?>
					<li><span class="sw-post-view"><i class="fa-solid fa-clock"></i> <?php echo esc_html($read_time, 'swiftcart'); ?></span></li>
				</ul>
				<p class="sw-blog-list__eswept"><?php echo get_the_excerpt(); ?></p>

				<div class="sw-blog-list__btn">
					<a class="swiftcart-btn swiftcart-border-btn" href="<?php the_permalink(); ?>"><?php echo esc_html__("READ MORE", 'swiftcart'); ?></a>
				</div>
			</div>
		</div>
	</div>
</article>
<!--===  Blog Post Item  ===-->