<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package swiftcart
 */

?>
<!-- default Header -->
<header>
    <div class="sw-header-landing sw-default-header">
        <div class="container">
            <div class="sw-header-two__wrapper">
                <div class="sw-header-two__logo">
                    <?php
                    if (has_custom_logo()) {
                        the_custom_logo();
                    } else {
                        printf('<h3 class="sw-site-title"><a href="%1$s">%2$s</a></h3>', esc_url(site_url('/')), esc_html(get_bloginfo('name')));
                    }
                    ?>
                </div>
                <div class="sw-header-two__right">
                    <div class="sw-header-one__menu sw-main-menu">
                        <nav id="mobile-menu">
                            <?php
                            if (has_nav_menu('main-menu')) {
                                wp_nav_menu(array(
                                    'theme_location'  => 'main-menu',
                                    'items_wrap'      => '<ul class="ul-0">%3$s</ul>',
                                    'container'      => '',
                                    'container_class' => '',
                                    'menu_class'      => 'menu',
                                ));
                            }
                            ?>
                        </nav>
                    </div>
                </div>
                <!-- mobile drawer  -->
                <div class="sw-header-two__hamburger d-lg-none">
                    <button class="sw-offcanvas-btn sw-header-two__btn">
                        <i class="icon-menu text-black"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>
</header>
<!-- default Header end -->

<!-- body Overlay  -->
<div class="sw-body-overlay sw-close-toggler"></div>
<!-- body Overlay End -->
<div class="sw-mobile-nav__wrapper">
    <div class="sw-mobile-nav__overlay sw-close-toggler"></div>
    <!-- /.mobile-nav__overlay -->
    <div class="sw-mobile-nav__content">
        <a href="#" class="sw-mobile-nav__close sw-search-popup__close sw-close-toggler"></a>
        <div class="logo-box">
            <?php
            if (has_custom_logo()) {
                the_custom_logo();
            } else {
                printf('<h3 class="sw-site-title text-white"><a href="%1$s">%2$s</a></h3>', esc_url(site_url('/')), esc_html(get_bloginfo('name')));
            }
            ?>
        </div>
        <!-- /.logo-box -->
        <div class="sw-mobile-nav__menu"></div>
        <!-- /.mobile-nav__container -->
    </div>
    <!-- /.mobile-nav__content -->
</div>