<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


// Add custom style in theme settings
function rivax_theme_settings_style () {
	wp_enqueue_style('rivax_settings_style', RIVAX_THEME_URI . '/admin/assets/css/settings.css', array(), null);
}
add_action( 'redux/page/rivax_syron_options/enqueue', 'rivax_theme_settings_style' );




add_action('after_setup_theme', 'rivax_redux_config' );
function rivax_redux_config() {

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    $theme = wp_get_theme(); // For use with some settings. Not necessary.
    $theme = $theme->parent() ?: $theme;

    // This is your option name where all the Redux data is stored.
    $opt_name = "rivax_syron_options";

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * */
    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'submenu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => esc_html__('Theme Settings', 'syron'),
        'page_title'           => esc_html__('Theme Settings', 'syron'),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => false,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => false,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-hammer',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => false,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => 72,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'rivax-dashboard',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => 'rivax-settings',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        'output_location'                  => array( 'frontend', 'admin' ),
	    // Admin area: Enqueue dynamic CSS and Google fonts.
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

    );

// Add content after the form.
    $args['footer_text'] = '<p>' . esc_html__('Designed by: ', 'syron') . '<a href="' . esc_url('https://themeforest.net/user/rivaxstudio/') . '" target="_blank">Rivax Studio</a>.</p>';

    Redux::set_args( $opt_name, $args );

    /*
 * ---> END ARGUMENTS
 */

 /*
 *
 * ---> START SECTIONS
 *
 */

    Redux::set_section( $opt_name, array(
        'title'            =>  esc_html__('General', 'syron'),
        'id'               => 'general_section',
        'desc'             =>  esc_html__('General settings for site', 'syron'),
        'icon'             => 'el el-cog',
        'fields'           => array(
            array(
                'id'       => 'site-width',
                'type'     => 'slider',
                'title'    => esc_html__('Site Width', 'syron'),
                'subtitle' => esc_html__('Choose the site width.', 'syron'),
                'desc'     => esc_html__('Default: 1400.', 'syron'),
                'default'  => 1400,
                'min'       => 1200,
                'step'      => 10,
                'max'       => 1800,
            ),
            array(
                'id'       => 'sticky-sidebar',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Sticky Sidebar', 'syron'),
                'subtitle' => esc_html__('Make sidebar sticky.', 'syron'),
                'desc'     => '',
                'default'  => true,
            ),

            array(
                'id'       => 'site-preloader',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Preloader', 'syron'),
                'subtitle' => esc_html__('Show site preloader transition before site loaded.', 'syron'),
                'desc'     => '',
                'default'  => false,
            ),

            array(
                'id'       => 'smooth-scroll',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Smooth Scroll', 'syron'),
                'subtitle' => esc_html__('Smooth scroll in website.', 'syron'),
                'desc'     => '',
                'default'  => true,
            ),

            array(
                'id'       => 'full-size-gif',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Full Size Gif Images', 'syron'),
                'subtitle' => esc_html__('Use full image size for Gif. It is useful to show gif animation in thumbnail.', 'syron'),
                'desc'     => '',
                'default'  => true,
            ),
            array(
                'id'       => 'cursor-effect',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Cursor Effect', 'syron'),
                'subtitle' => esc_html__('Custom cursor effect for website.', 'syron'),
                'desc'     => '',
                'default'  => true,
            ),
            array(
                'id'       => 'posts-animation',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Posts Animation', 'syron'),
                'subtitle' => esc_html__('Global enable or disable posts image animation.', 'syron'),
                'desc'     => '',
                'default'  => true,
            ),

        )
    ) );

    Redux::set_section( $opt_name, array(
        'title'            =>  esc_html__('Header', 'syron'),
        'id'               => 'header_section',
        'desc'             =>  esc_html__('General settings for header', 'syron'),
        'icon'             => 'el el-website',
        'fields'           => array(

            array(
                'id'       => 'site-header',
                'type'     => 'select',
                'title'    => esc_html__('Site Header Template', 'syron'),
                'subtitle' => esc_html__('Select header template for your site.', 'syron'),
                'data'  => 'callback',
                'args' => 'rivax_get_templates_list',
                'desc'     => sprintf(esc_html__('You can create your custom template in %1$s Rivax Templates %2$s section.', 'syron'), '<a target="_blank" href="' . admin_url("edit.php?post_type=rivax-template") . '"><b>', '</b></a>'),
                'default' => '0',
                'select2'  => array( 'allowClear' => false ),
            ),

            array(
                'id'       => 'single-post-header',
                'type'     => 'select',
                'title'    => esc_html__('Single Post Header Template', 'syron'),
                'subtitle' => esc_html__('Select header template for the single post.', 'syron'),
                'data'  => 'callback',
                'args' => 'rivax_get_templates_list',
                'desc'     => sprintf(esc_html__('Default inherit from site header template. You can create your custom template in %1$s Rivax Templates %2$s section.', 'syron'), '<a target="_blank" href="' . admin_url("edit.php?post_type=rivax-template") . '"><b>', '</b></a>'),
                'default' => '0',
                'select2'  => array( 'allowClear' => false ),
            ),

            array(
                'id'       => 'sticky-header-status',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Sticky Header', 'syron'),
                'subtitle' => esc_html__('Enable sticky header for your site.', 'syron'),
                'desc'     => '',
                'default'  => false,
            ),

            array(
                'id'       => 'site-sticky-header',
                'type'     => 'select',
                'required' => array( 'sticky-header-status', '=', '1' ),
                'title'    => esc_html__('Site Sticky Header', 'syron'),
                'subtitle' => esc_html__('Select sticky header for the site.', 'syron'),
                'data'  => 'callback',
                'args' => 'rivax_get_templates_list',
                'desc'     => sprintf(esc_html__('You can create your custom template in %1$s Rivax Templates %2$s section.', 'syron'), '<a target="_blank" href="' . admin_url("edit.php?post_type=rivax-template") . '"><b>', '</b></a>'),
                'default' => '0',
                'select2'  => array( 'allowClear' => false ),
            ),

	        array(
		        'id'       => 'single-post-sticky-header',
		        'type'     => 'select',
		        'required' => array( 'sticky-header-status', '=', '1' ),
		        'title'    => esc_html__('Single Post Sticky Header Template', 'syron'),
		        'subtitle' => esc_html__('Select sticky header template for the single post.', 'syron'),
		        'data'  => 'callback',
		        'args' => 'rivax_get_templates_list',
		        'desc'     => sprintf(esc_html__('Default inherit from site sticky header template. You can create your custom template in %1$s Rivax Templates %2$s section.', 'syron'), '<a target="_blank" href="' . admin_url("edit.php?post_type=rivax-template") . '"><b>', '</b></a>'),
		        'default' => '0',
		        'select2'  => array( 'allowClear' => false ),
	        ),

        )
    ) );

    Redux::set_section( $opt_name, array(
        'title'            =>  esc_html__('Footer', 'syron'),
        'id'               => 'footer_section',
        'desc'             =>  esc_html__('General settings for footer', 'syron'),
        'icon'             => 'el el-credit-card',
        'fields'           => array(
            array(
                'id'       => 'site-footer',
                'type'     => 'select',
                'title'    => esc_html__('Site Footer', 'syron'),
                'subtitle' => esc_html__('Select footer for the site.', 'syron'),
                'data'  => 'callback',
                'args' => 'rivax_get_templates_list',
                'desc'     => sprintf(esc_html__('You can create your custom template in %1$s Rivax Templates %2$s section.', 'syron'), '<a target="_blank" href="' . admin_url("edit.php?post_type=rivax-template") . '"><b>', '</b></a>'),
                'default' => '0',
                'select2'  => array( 'allowClear' => false ),
            ),
            array(
                'id'       => 'back-to-top',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Back to Top Button', 'syron'),
                'subtitle' => esc_html__('Enable or disable back to top button.', 'syron'),
                'desc'     => '',
                'default'  => false,
            ),
	        array(
		        'id'       => 'back-to-top-text',
		        'type'     => 'text',
		        'required' => array( 'back-to-top', '=', '1' ),
		        'title'    => esc_html__('Back to Top Text', 'syron'),
		        'default'  => esc_html__('Scroll', 'syron'),
	        ),

            array(
                'id'       => 'footer-canvas-menu-bg',
                'type'     => 'color',
                'transparent'     => false,
                'title'    => esc_html__('Footer Canvas Menu Background', 'syron'),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '',
                'validate' => 'color',
            ),
            array(
                'id'       => 'footer-canvas-menu-color',
                'type'     => 'color',
                'transparent'     => false,
                'title'    => esc_html__('Footer Canvas Menu Link Color', 'syron'),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '',
                'validate' => 'color',
            ),
            array(
                'id'       => 'footer-canvas-menu-color-hover',
                'type'     => 'color',
                'transparent'     => false,
                'title'    => esc_html__('Footer Canvas Menu Link Hover Color', 'syron'),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '',
                'validate' => 'color',
            ),
        )
    ) );


    Redux::set_section( $opt_name, array(
        'title'            =>  esc_html__('Sidebar', 'syron'),
        'id'               => 'sidebar_section',
        'desc'             =>  esc_html__('General settings for sidebar', 'syron'),
        'icon'             => 'el el-align-left',
        'fields'           => array(
            array(
                'id'       => 'subtitle-756694',
                'type'     => 'raw',
                'full_width'     => true,
                'content'     => '<h4>' . esc_html__('Single Page Sidebar', 'syron') . '</h4>',
            ),
            array(
                'id'       => 'single-page-sidebar-position',
                'type'     => 'select',
                'title'    => esc_html__('Single Page Sidebar Position', 'syron'),
                'subtitle' => esc_html__('Select sidebar position for pages.', 'syron'),
                'desc'     => '',
                'options'  => array(
                    'left' => esc_html__('Left', 'syron'),
                    'right' => esc_html__('Right', 'syron'),
                    'none' => esc_html__('No Sidebar', 'syron'),
                    'none-narrow' => esc_html__('No Sidebar + Narrow Content', 'syron'),
                ),
                'select2'  => array( 'allowClear' => false ),
                'default'  => 'none',
            ),
            array(
                'id'       => 'single-page-sidebar-template',
                'type'     => 'select',
                'title'    => esc_html__('Single Page Sidebar Template', 'syron'),
                'subtitle' => esc_html__('Select template for this sidebar.', 'syron'),
                'data'  => 'callback',
                'args' => 'rivax_get_templates_list',
                'desc'     => sprintf(esc_html__('You can create your custom template in %1$s Rivax Templates %2$s section.', 'syron'), '<a target="_blank" href="' . admin_url("edit.php?post_type=rivax-template") . '"><b>', '</b></a>'),
                'default' => '0',
                'select2'  => array( 'allowClear' => false ),
            ),

            array(
                'id'       => 'subtitle-355494',
                'type'     => 'raw',
                'full_width'     => true,
                'content'     => '<h4>' . esc_html__('Single Post Sidebar', 'syron') . '</h4>',
            ),
            array(
                'id'       => 'single-post-sidebar-position',
                'type'     => 'select',
                'title'    => esc_html__('Single Post Sidebar Position', 'syron'),
                'subtitle' => esc_html__('Select sidebar position for single post.', 'syron'),
                'desc'     => '',
                'options'  => array(
                    'left' => esc_html__('Left', 'syron'),
                    'right' => esc_html__('Right', 'syron'),
                    'none' => esc_html__('No Sidebar', 'syron'),
                    'none-narrow' => esc_html__('No Sidebar + Narrow Content', 'syron'),
                ),
                'select2'  => array( 'allowClear' => false ),
                'default'  => 'none',
            ),
            array(
                'id'       => 'single-post-sidebar-template',
                'type'     => 'select',
                'title'    => esc_html__('Single Post Sidebar Template', 'syron'),
                'subtitle' => esc_html__('Select template for this sidebar.', 'syron'),
                'data'  => 'callback',
                'args' => 'rivax_get_templates_list',
                'desc'     => sprintf(esc_html__('You can create your custom template in %1$s Rivax Templates %2$s section.', 'syron'), '<a target="_blank" href="' . admin_url("edit.php?post_type=rivax-template") . '"><b>', '</b></a>'),
                'default' => '0',
                'select2'  => array( 'allowClear' => false ),
            ),

            array(
                'id'       => 'subtitle-755494',
                'type'     => 'raw',
                'full_width'     => true,
                'content'     => '<h4>' . esc_html__('Blog Sidebar', 'syron') . '</h4>',
            ),
            array(
                'id'       => 'blog-sidebar-position',
                'type'     => 'select',
                'title'    => esc_html__('Blog Sidebar Position', 'syron'),
                'subtitle' => esc_html__('Select sidebar position for blog archive.', 'syron'),
                'desc'     => '',
                'options'  => array(
                    'left' => esc_html__('Left', 'syron'),
                    'right' => esc_html__('Right', 'syron'),
                    'none' => esc_html__('No Sidebar', 'syron'),
                ),
                'select2'  => array( 'allowClear' => false ),
                'default'  => 'none',
            ),
            array(
                'id'       => 'blog-sidebar-template',
                'type'     => 'select',
                'title'    => esc_html__('Blog Sidebar Template', 'syron'),
                'subtitle' => esc_html__('Select template for this sidebar.', 'syron'),
                'data'  => 'callback',
                'args' => 'rivax_get_templates_list',
                'desc'     => sprintf(esc_html__('You can create your custom template in %1$s Rivax Templates %2$s section.', 'syron'), '<a target="_blank" href="' . admin_url("edit.php?post_type=rivax-template") . '"><b>', '</b></a>'),
                'default' => '0',
                'select2'  => array( 'allowClear' => false ),
            ),

            array(
                'id'       => 'subtitle-756794',
                'type'     => 'raw',
                'full_width'     => true,
                'content'     => '<h4>' . esc_html__('Woocommerce Sidebar', 'syron') . '</h4>',
            ),
            array(
                'id'       => 'woocommerce-shop-sidebar-position',
                'type'     => 'select',
                'title'    => esc_html__('Woocommerce Shop Sidebar Position', 'syron'),
                'subtitle' => esc_html__('Select sidebar position for woocommerce shop.', 'syron'),
                'desc'     => '',
                'options'  => array(
                    'left' => esc_html__('Left', 'syron'),
                    'right' => esc_html__('Right', 'syron'),
                    'none' => esc_html__('No Sidebar', 'syron'),
                ),
                'select2'  => array( 'allowClear' => false ),
                'default'  => 'none',
            ),
	        array(
		        'id'       => 'woocommerce-archive-sidebar-position',
		        'type'     => 'select',
		        'title'    => esc_html__('Woocommerce Archive Sidebar Position', 'syron'),
		        'subtitle' => esc_html__('Select sidebar position for woocommerce archive.', 'syron'),
		        'desc'     => '',
		        'options'  => array(
			        'left' => esc_html__('Left', 'syron'),
			        'right' => esc_html__('Right', 'syron'),
			        'none' => esc_html__('No Sidebar', 'syron'),
		        ),
		        'select2'  => array( 'allowClear' => false ),
		        'default'  => 'none',
	        ),
            array(
                'id'       => 'woocommerce-sidebar-template',
                'type'     => 'select',
                'title'    => esc_html__('Woocommerce Sidebar Template', 'syron'),
                'subtitle' => esc_html__('Select template for this sidebar.', 'syron'),
                'data'  => 'callback',
                'args' => 'rivax_get_templates_list',
                'desc'     => sprintf(esc_html__('You can create your custom template in %1$s Rivax Templates %2$s section.', 'syron'), '<a target="_blank" href="' . admin_url("edit.php?post_type=rivax-template") . '"><b>', '</b></a>'),
                'default' => '0',
                'select2'  => array( 'allowClear' => false ),
            ),

        )
    ) );



    Redux::set_section( $opt_name, array(
        'title'            =>  esc_html__('Styling', 'syron'),
        'id'               => 'styling_section',
        'desc'             =>  esc_html__('Styling settings', 'syron'),
        'icon'             => 'el el-brush',
        'fields'           => array(
            array(
                'id'       => 'accent-color',
                'type'     => 'color',
                'transparent'     => false,
                'title'    => esc_html__('Accent Color', 'syron'),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '',
                'validate' => 'color',
            ),
            array(
                'id'       => 'second-color',
                'type'     => 'color',
                'transparent'     => false,
                'title'    => esc_html__('Second Color', 'syron'),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '',
                'validate' => 'color',
            ),
            array(
                'id'       => 'body-bg',
                'type'     => 'color',
                'transparent'     => false,
                'title'    => esc_html__('Body Background Color', 'syron'),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '',
                'validate' => 'color',
            ),
            array(
                'id'       => 'body-color',
                'type'     => 'color',
                'transparent'     => false,
                'title'    => esc_html__('Body Text Color', 'syron'),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '',
                'validate' => 'color',
            ),
            array(
                'id'       => 'heading-color',
                'type'     => 'color',
                'transparent'     => false,
                'title'    => esc_html__('Headings Color', 'syron'),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '',
                'validate' => 'color',
            ),
            array(
                'id'       => 'button-bg-hover',
                'type'     => 'color',
                'transparent'     => false,
                'title'    => esc_html__('Button Background Hover', 'syron'),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '',
                'validate' => 'color',
            ),



        )
    ) );


    Redux::set_section( $opt_name, array(
        'title'            => esc_html__('Typography', 'syron'),
        'id'               => 'typography',
        'desc'             => esc_html__('Typography settings', 'syron'),
        'subsection'       => false,
        'icon'             => 'el el-fontsize',
        'fields'           => array(
            array(
                'id'            => 'typography-body',
                'type'          => 'typography',
				'all_styles'    => true,
                'google'        => true,
                'color'         => false,
                'text-align'    => false,
                'subsets'       => false,
                'letter-spacing' => true,
                'line-height-unit' =>'em',
                'title'         => esc_html__('Body Typography', 'syron'),
            ),
            array(
                'id'       => 'typography-heading',
                'type'     => 'typography',
                'google'      => true,
                'color'      => false,
                'text-align'      => false,
                'subsets'      => false,
                'letter-spacing' => true,
                'line-height-unit' =>'em',
                'font-size'      => false,
                'title'    => esc_html__('Headings Typography', 'syron'),
            ),            
	        array(
		        'id'       => 'typography-terms',
		        'type'     => 'typography',
		        'google'      => true,
		        'color'      => false,
		        'text-align'      => false,
		        'subsets'      => false,
		        'line-height'      => false,
		        'font-size'      => false,
		        'title'    => esc_html__('Terms Typography', 'syron'),
	        ),
            array(
                'id'       => 'typography-menu',
                'type'     => 'typography',
                'google'      => true,
                'color'      => false,
                'text-align'      => false,
                'subsets'      => false,
                'line-height'      => false,
                'font-size'      => false,
                'title'    => esc_html__('Menu Typography', 'syron'),
            ),
            array(
                'id'       => 'title-font-size-9856',
                'type'     => 'raw',
                'full_width'     => true,
                'content'     => '<h2>' . esc_html__('Font Size', 'syron') . '</h2>',
            ),
            array(
                'id'       => 'h1-font-size',
                'type'     => 'text',
                'title'    => esc_html__('H1 Font Size', 'syron'),
                'subtitle' => esc_html__('Enter H1 font size. Example: 28px or 1.8rem', 'syron'),
            ),
            array(
                'id'       => 'h2-font-size',
                'type'     => 'text',
                'title'    => esc_html__('H2 Font Size', 'syron'),
                'subtitle' => esc_html__('Enter H2 font size. Example: 28px or 1.8rem', 'syron'),
            ),
            array(
                'id'       => 'h3-font-size',
                'type'     => 'text',
                'title'    => esc_html__('H3 Font Size', 'syron'),
                'subtitle' => esc_html__('Enter H3 font size. Example: 28px or 1.8rem', 'syron'),
            ),
            array(
                'id'       => 'h4-font-size',
                'type'     => 'text',
                'title'    => esc_html__('H4 Font Size', 'syron'),
                'subtitle' => esc_html__('Enter H4 font size. Example: 28px or 1.8rem', 'syron'),
            ),
            array(
                'id'       => 'h5-font-size',
                'type'     => 'text',
                'title'    => esc_html__('H5 Font Size', 'syron'),
                'subtitle' => esc_html__('Enter H5 font size. Example: 28px or 1.8rem', 'syron'),
            ),
            array(
                'id'       => 'h6-font-size',
                'type'     => 'text',
                'title'    => esc_html__('H6 Font Size', 'syron'),
                'subtitle' => esc_html__('Enter H6 font size. Example: 28px or 1.8rem', 'syron'),
            ),

            array(
                'id'       => 'title-font-size-984556',
                'type'     => 'raw',
                'full_width'     => true,
                'content'     => '<h2>' . esc_html__('Font Size In Responsive', 'syron') . '</h2>',
            ),
            array(
                'id'       => 'h1-font-size-responsive',
                'type'     => 'text',
                'title'    => esc_html__('H1 Font Size In Mobile And Tablet', 'syron'),
                'subtitle' => esc_html__('Enter H1 font size. Example: 28px or 1.8rem', 'syron'),
            ),
            array(
                'id'       => 'h2-font-size-responsive',
                'type'     => 'text',
                'title'    => esc_html__('H2 Font Size In Mobile And Tablet', 'syron'),
                'subtitle' => esc_html__('Enter H2 font size. Example: 28px or 1.8rem', 'syron'),
            ),
            array(
                'id'       => 'h3-font-size-responsive',
                'type'     => 'text',
                'title'    => esc_html__('H3 Font Size In Mobile And Tablet', 'syron'),
                'subtitle' => esc_html__('Enter H3 font size. Example: 28px or 1.8rem', 'syron'),
            ),
            array(
                'id'       => 'h4-font-size-responsive',
                'type'     => 'text',
                'title'    => esc_html__('H4 Font Size In Mobile And Tablet', 'syron'),
                'subtitle' => esc_html__('Enter H4 font size. Example: 28px or 1.8rem', 'syron'),
            ),
            array(
                'id'       => 'h5-font-size-responsive',
                'type'     => 'text',
                'title'    => esc_html__('H5 Font Size In Mobile And Tablet', 'syron'),
                'subtitle' => esc_html__('Enter H5 font size. Example: 28px or 1.8rem', 'syron'),
            ),
            array(
                'id'       => 'h6-font-size-responsive',
                'type'     => 'text',
                'title'    => esc_html__('H6 Font Size In Mobile And Tablet', 'syron'),
                'subtitle' => esc_html__('Enter H6 font size. Example: 28px or 1.8rem', 'syron'),
            ),


        )
    ) );


    Redux::set_section( $opt_name, array(
        'title'            => esc_html__('Single Post', 'syron'),
        'id'               => 'single_post_section',
        'desc'             => esc_html__('Single Post settings', 'syron'),
        'subsection'       => false,
        'icon'             => 'el el-pencil',
    ) );


    Redux::set_section( $opt_name, array(
        'title'            => esc_html__('General', 'syron'),
        'id'               => 'single_post_general',
        'desc'             => esc_html__('Single Post general settings', 'syron'),
        'subsection'       => true,
        'icon'             => 'el el-cog',
        'fields'           => array(

            array(
                'id'       => 'single-post-top-content-template',
                'type'     => 'select',
                'title'    => esc_html__('Top Content', 'syron'),
                'subtitle' => esc_html__('Select template to show in top of the post.', 'syron'),
                'data'  => 'callback',
                'args' => 'rivax_get_templates_list',
                'desc'     => sprintf(esc_html__('You can create your custom template in %1$s Rivax Templates %2$s section.', 'syron'), '<a target="_blank" href="' . admin_url("edit.php?post_type=rivax-template") . '"><b>', '</b></a>'),
                'default' => '0',
                'select2'  => array( 'allowClear' => false ),
            ),
            array(
                'id'       => 'single-post-bottom-content-template',
                'type'     => 'select',
                'title'    => esc_html__('Bottom Content', 'syron'),
                'subtitle' => esc_html__('Select template to show in bottom of the post.', 'syron'),
                'data'  => 'callback',
                'args' => 'rivax_get_templates_list',
                'desc'     => sprintf(esc_html__('You can create your custom template in %1$s Rivax Templates %2$s section.', 'syron'), '<a target="_blank" href="' . admin_url("edit.php?post_type=rivax-template") . '"><b>', '</b></a>'),
                'default' => '0',
                'select2'  => array( 'allowClear' => false ),
            ),
	        array(
		        'id'       => 'compact-comments',
		        'type'     => 'switch',
		        'on'     => esc_html__('Enable', 'syron'),
		        'off'     => esc_html__('Disable', 'syron'),
		        'title'    => esc_html__('Compact Comments', 'syron'),
		        'subtitle' => esc_html__('Show comments in compact view.', 'syron'),
		        'desc'     => '',
		        'default'  => true,
	        ),
			array(
                'id'       => 'disable-comments',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Disable Comments', 'syron'),
                'subtitle' => esc_html__('Disable comments list and form.', 'syron'),
                'desc'     => '',
            ),
			array(
                'id'       => 'disable-tags',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Disable Tags', 'syron'),
                'subtitle' => esc_html__('Disable showing tags from the bottom of posts.', 'syron'),
                'desc'     => '',
            ),
            array(
                'id'       => 'single-post-share-box',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Show Share Box', 'syron'),
                'subtitle' => esc_html__('Show share box in the single post.', 'syron'),
                'desc'     => '',
                'default'  => true,
            ),
	        array(
		        'id'       => 'single-post-share-box-title',
		        'type'     => 'text',
		        'required' => array( 'single-post-share-box', '=', '1' ),
		        'title'    => esc_html__('Share Box Title', 'syron'),
		        'subtitle' => esc_html__('Enter your title for the share box.', 'syron'),
		        'desc'     => esc_html__('Default value: Share Article', 'syron'),
		        'default'  => esc_html__('Share Article', 'syron'),
	        ),
            array(
                'id'       => 'single-post-share-box-options',
                'type'     => 'checkbox',
                'required' => array( 'single-post-share-box', '=', '1' ),
                'title'    => esc_html__('Share Box Options', 'syron'),
                'subtitle' => esc_html__('Select share box options.', 'syron'),
                'desc'     => '',
                'options'  => array(
                    'facebook' => esc_html__('Facebook', 'syron'),
                    'twitter' => esc_html__('Twitter', 'syron'),
                    'linkedin' => esc_html__('Linkedin', 'syron'),
                    'pinterest' => esc_html__('Pinterest', 'syron'),
                    'telegram' => esc_html__('Telegram', 'syron'),
                    'email' => esc_html__('Email', 'syron'),
                    'whatsapp' => esc_html__('WhatsApp', 'syron'),
                    'link' => esc_html__('Link Box', 'syron'),
                ),
                'default' => array(
                    'facebook' => '1',
                    'twitter' => '1',
                    'linkedin' => '0',
                    'pinterest' => '1',
                    'telegram' => '0',
                    'email' => '1',
                    'whatsapp' => '1',
                    'link' => '1',
                )
            ),
            array(
                'id'       => 'single-post-author-box',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Show Author Box', 'syron'),
                'subtitle' => esc_html__('Show author box in the single post.', 'syron'),
                'desc'     => '',
                'default'  => true,
            ),
            array(
                'id'       => 'single-post-next-prev-posts',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Show Next and Previous Posts', 'syron'),
                'subtitle' => esc_html__('Show next and Previous posts in the single post.', 'syron'),
                'desc'     => '',
                'default'  => true,
            ),
            array(
                'id'       => 'single-next-prev-posts-title',
                'type'     => 'text',
                'required' => array( 'single-post-next-prev-posts', '=', '1' ),
                'title'    => esc_html__('Next And Previous Posts Title', 'syron'),
                'subtitle' => esc_html__('Enter your title for the next and Previous posts.', 'syron'),
                'desc'     => esc_html__('Default value: Other Articles', 'syron'),
                'default'  => esc_html__('Other Articles', 'syron'),
            ),
            array(
                'id'       => 'reading-time-words-per-minute',
                'type'     => 'slider',
                'title'    => esc_html__('Reading Time Words Per Minute', 'syron'),
                'subtitle' => esc_html__('How many words user can read per minute?', 'syron'),
                'desc'     => esc_html__('Default value: 255', 'syron'),
                'default'  => 255,
                'min'       => 100,
                'step'      => 10,
                'max'       => 500,
            ),


        )
    ) );


    Redux::set_section( $opt_name, array(
        'title'            => esc_html__('Hero Layout', 'syron'),
        'id'               => 'single_post_layout',
        'desc'             => esc_html__('Single post hero layout settings', 'syron'),
        'subsection'       => true,
        'icon'             => 'el el-picture',
        'fields'           => array(
            array(
                'id'       => 'single-post-meta',
                'type'     => 'checkbox',
                'title'    => esc_html__('Post Meta', 'syron'),
                'subtitle' => esc_html__('Select meta for single post.', 'syron'),
                'desc'     => '',
                'options'  => array(
                    'author-name' => esc_html__('Author Name', 'syron'),
                    'author-avatar' => esc_html__('Author Avatar', 'syron'),
                    'date' => esc_html__('Date', 'syron'),
                    'date-updated' => esc_html__('Updated Date', 'syron'),
                    'category' => esc_html__('Category', 'syron'),
                    'comments' => esc_html__('Comments', 'syron'),
                    'views' => esc_html__('Views', 'syron'),
                    'reading-time' => esc_html__('Reading Time', 'syron'),
                ),
                'default' => array(
                    'author-name' => '1',
                    'author-avatar' => '1',
                    'date' => '1',
                    'date-updated' => '0',
                    'category' => '1',
                    'comments' => '1',
                    'views' => '0',
                    'reading-time' => '1',
                )
            ),

            array(
                'id'       => 'title-8145',
                'type'     => 'raw',
                'full_width'     => true,
                'content'     => '<h2>' . esc_html__('Standard Post Format', 'syron') . '</h2>',
            ),
            array(
                'id'       => 'single-hero',
                'type'     => 'select',
                'title'    => esc_html__('Standard Post Layout', 'syron'),
                'subtitle' => esc_html__('Select default layout for standard posts. You can customize settings for each layout below.', 'syron'),
                'desc'     => '',
                'options'  => array(
                    '1' => esc_html__('Layout 1', 'syron'),
                    '2' => esc_html__('Layout 2', 'syron'),
                    '3' => esc_html__('Layout 3', 'syron'),
                    '4' => esc_html__('Layout 4', 'syron'),
                    '5' => esc_html__('Layout 5', 'syron'),
                    '6' => esc_html__('Layout 6', 'syron'),
                    '7' => esc_html__('Layout 7', 'syron'),
                    '8' => esc_html__('Layout 8', 'syron'),
                    '9' => esc_html__('Layout 9', 'syron'),
                    '10' => esc_html__('Layout 10', 'syron'),
                    '11' => esc_html__('Layout 11', 'syron'),
                ),
                'select2'  => array( 'allowClear' => false ),
                'default'  => '1',
            ),

	        array(
		        'id'       => 'single-hero-1-fit',
		        'type'     => 'checkbox',
		        'required' => array( 'single-hero', '=', '1' ),
		        'title'    => esc_html__('Layout 1: Fit Image', 'syron'),
		        'subtitle' => '',
		        'desc'     => '',
		        'default' => '0'
	        ),
	        array(
		        'id'       => 'single-hero-1-full-img',
		        'type'     => 'checkbox',
		        'required' => array( 'single-hero', '=', '1' ),
		        'title'    => esc_html__('Layout 1: Full Height Image', 'syron'),
		        'subtitle' => '',
		        'desc'     => '',
		        'default' => '0'
	        ),
            array(
                'id'       => 'single-hero-2-disable-img',
                'type'     => 'checkbox',
                'required' => array( 'single-hero', '=', '2' ),
                'title'    => esc_html__('Layout 2: Disable Image', 'syron'),
                'subtitle' => '',
                'desc'     => '',
                'default' => '0'
            ),
	        array(
		        'id'       => 'single-hero-3-disable-img',
		        'type'     => 'checkbox',
		        'required' => array( 'single-hero', '=', '3' ),
		        'title'    => esc_html__('Layout 3: Disable Image', 'syron'),
		        'subtitle' => '',
		        'desc'     => '',
		        'default' => '0'
	        ),
	        array(
		        'id'       => 'single-hero-6-full-img',
		        'type'     => 'checkbox',
		        'required' => array( 'single-hero', '=', '6' ),
		        'title'    => esc_html__('Layout 6: Full Height Image', 'syron'),
		        'subtitle' => '',
		        'desc'     => '',
		        'default' => '0'
	        ),
	        array(
		        'id'       => 'single-hero-7-full-img',
		        'type'     => 'checkbox',
		        'required' => array( 'single-hero', '=', '7' ),
		        'title'    => esc_html__('Layout 7: Full Height Image', 'syron'),
		        'subtitle' => '',
		        'desc'     => '',
		        'default' => '0'
	        ),
	        array(
		        'id'       => 'single-hero-11-fit',
		        'type'     => 'checkbox',
		        'required' => array( 'single-hero', '=', '11' ),
		        'title'    => esc_html__('Layout 11: Fit Image', 'syron'),
		        'subtitle' => '',
		        'desc'     => '',
		        'default' => '0'
	        ),


            array(
                'id'       => 'title-8545',
                'type'     => 'raw',
                'full_width'     => true,
                'content'     => '<h2>' . esc_html__('Gallery Post Format', 'syron') . '</h2>',
            ),
            array(
                'id'       => 'single-format-gallery-position',
                'type'     => 'select',
                'title'    => esc_html__('Gallery Position', 'syron'),
                'subtitle' => esc_html__('Select gallery position.', 'syron'),
                'desc'     => '',
                'options'  => array(
                    'inside' => esc_html__('Inside content', 'syron'),
                    'outside' => esc_html__('Outside Content', 'syron'),
                ),
                'select2'  => array( 'allowClear' => false ),
                'default'  => 'inside',
            ),

        )
    ) );


    Redux::set_section( $opt_name, array(
        'title'            => esc_html__('Table Of Content', 'syron'),
        'id'               => 'toc_section',
        'desc'             => esc_html__('Insert table of content for single post automatically or use Toc Elementor widget in the sidebar.', 'syron'),
        'subsection'       => true,
        'icon'             => 'el el-list-alt',
        'fields'           => array(
            array(
                'id'       => 'toc',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Table Of Content', 'syron'),
                'desc'     => esc_html__('Enable table of content.', 'syron'),
            ),
            array(
                'id'       => 'toc-inline',
                'type'     => 'switch',
				'required' => array( 'toc', '=', '1' ),
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Insert Automatically', 'syron'),
                'desc'     => esc_html__('Add table of content to single posts automatically.', 'syron'),
            ),
            array(
                'id'       => 'toc-hierarchically',
                'type'     => 'switch',
				'required' => array( 'toc', '=', '1' ),
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Show hierarchically', 'syron'),
                'desc'     => esc_html__('Show the table of content items hierarchically.', 'syron'),
            ),
            array(
                'id'       => 'toc-counter',
                'type'     => 'switch',
				'required' => array( 'toc', '=', '1' ),
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Show Counter', 'syron'),
                'desc'     => esc_html__('Show counter for table of content items.', 'syron'),
            ),
            array(
                'id'       => 'toc-collapsable',
                'type'     => 'switch',
				'required' => array( 'toc', '=', '1' ),
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Collapsable', 'syron'),
                'desc'     => esc_html__('Show a collapsable button to toggle the table of content items.', 'syron'),
            ),
			array(
                'id'       => 'toc-collapsed-default',
                'type'     => 'switch',
                'required' => array( 'toc', '=', '1' ),
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Collapsed By Default', 'syron'),
                'desc'     => '',
            ),
			array(
                'id'       => 'toc-disable-in-amp',
                'type'     => 'switch',
				'required' => array( 'toc', '=', '1' ),
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Disable In AMP', 'syron'),
                'desc'     => esc_html__('Disable table of content in AMP version.', 'syron'),
            ),
            array(
                'id'       => 'toc-title',
                'type'     => 'text',
				'required' => array( 'toc', '=', '1' ),
                'title'    => esc_html__('Title', 'syron'),
                'default'  => esc_html__('Table Of Content', 'syron'),
                'desc'     => esc_html__('Leave empty to hide title.', 'syron'),
            ),
            array(
                'id'       => 'toc-exclude-class',
                'type'     => 'text',
                'required' => array( 'toc', '=', '1' ),
                'title'    => esc_html__('Exclude Classes', 'syron'),
                'subtitle' => esc_html__('Exclude headings with these CSS classes.', 'syron'),
                'desc'     => esc_html__('Separate classes with space.', 'syron'),
            ),
            array(
                'id'       => 'toc-position',
                'type'     => 'select',
				'required' => array( 'toc', '=', '1' ),
                'title'    => esc_html__('Position', 'syron'),
                'subtitle' => esc_html__('Select the table of content position.', 'syron'),
                'desc'     => '',
                'options'  => array(
                    'top'       => esc_html__('Top', 'syron'),
                    'after-p'   => esc_html__('After the first paragraph', 'syron'),
                ),
                'select2'  => array( 'allowClear' => false ),
                'default'  => 'after-p',
            ),
            array(
                'id'       => 'toc-min-count',
                'type'     => 'select',
				'required' => array( 'toc', '=', '1' ),
                'title'    => esc_html__('Minimum Headings Count', 'syron'),
                'subtitle' => esc_html__('Minimum headings count to show the table of content.', 'syron'),
                'desc'     => '',
                'options'  => array(
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ),
                'select2'  => array( 'allowClear' => false ),
                'default'  => '3',
            ),
            array(
                'id'       => 'toc-headings-support',
                'type'     => 'checkbox',
				'required' => array( 'toc', '=', '1' ),
                'title'    => esc_html__('Headings Support', 'syron'),
                'subtitle' => esc_html__('Select headings to include in table of content.', 'syron'),
                'desc'     => '',
                'options'  => array(
                    '2' => 'H2',
                    '3' => 'H3',
                    '4' => 'H4',
                    '5' => 'H5',
                    '6' => 'H6',
                ),
                'default' => array(
                    '2' => '1',
                    '3' => '1',
                    '4' => '1',
                    '5' => '0',
                    '6' => '0',
                )
            ),


        )
    ) );


    Redux::set_section( $opt_name, array(
        'title'            => esc_html__('AMP', 'syron'),
        'id'               => 'amp_section',
        'desc'             => sprintf(esc_html__('If you interested to have an AMP version for your site, please install the %1$s AMP Plugin %2$s. Select Reader Mode for template and Legacy theme and select Posts for Supported Templates.', 'syron'), '<a target="_blank" href="https://wordpress.org/plugins/amp/"><b>', '</b></a>'),
        'subsection'       => true,
        'icon'             => 'el el-compass',
        'fields'           => array(
            array(
                'id'       => 'amp-logo',
                'type'     => 'media',
                'url'      => true,
                'title'    => esc_html__('AMP Logo', 'syron'),
                'subtitle' => esc_html__('Select your logo for the header.', 'syron'),
                'desc'     => '',
                'default'  => '',
            ),
            array(
                'id'       => 'amp-logo-width',
                'type'     => 'slider',
                'title'    => esc_html__('AMP Logo Width', 'syron'),
                'subtitle' => esc_html__('Select the logo width.', 'syron'),
                'desc'     => esc_html__('Default value: 100', 'syron'),
                'default'  => 100,
                'min'       => 60,
                'step'      => 5,
                'max'       => 300,
            ),
            array(
                'id'       => 'amp-sidebar-search',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Sidebar Search', 'syron'),
                'desc'     => '',
                'default'  => true,
            ),
            array(
                'id'       => 'amp-back-top',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Footer Back to Top', 'syron'),
                'desc'     => '',
                'default'  => true,
            ),
            array(
                'id'       => 'amp-copyright',
                'type'     => 'text',
                'title'    => esc_html__('Footer Copyright', 'syron'),
                'default'  => esc_html__('Designed by Rivax Studio. All Rights Reserved.', 'syron'),
            ),

        )
    ) );


    Redux::set_section( $opt_name, array(
        'title'            => esc_html__('Blog Archive', 'syron'),
        'id'               => 'blog_section',
        'desc'             => esc_html__('Blog settings', 'syron'),
        'subsection'       => false,
        'icon'             => 'el el-th-list',
        'fields'           => array(
            array(
                'id'       => 'archive-template',
                'type'     => 'select',
                'title'    => esc_html__('Blog Archive Template', 'syron'),
                'subtitle' => esc_html__('Select template for blog archive.', 'syron'),
                'data'  => 'callback',
                'args' => 'rivax_get_templates_list',
                'desc'     => sprintf(esc_html__('You can create your custom template in %1$s Rivax Templates %2$s section.', 'syron'), '<a target="_blank" href="' . admin_url("edit.php?post_type=rivax-template") . '"><b>', '</b></a>'),
                'default' => '0',
                'select2'  => array( 'allowClear' => false ),
            ),

	        array(
		        'id'       => 'subtitle-6340587',
		        'type'     => 'raw',
		        'full_width'     => true,
		        'content'     => '<h4>' . esc_html__('Search Settings', 'syron') . '</h4>',
	        ),
	        array(
		        'id'       => 'search-post-types',
		        'type'     => 'select',
		        'multi'    => true,
		        'title'    => esc_html__('Search Post Types', 'syron'),
		        'subtitle' => esc_html__('Limit search for custom post types.', 'syron'),
		        'data'  => 'post_types',
		        'desc'     => esc_html__('WordPress search in all post types by default.', 'syron'),
				'args'  => array(
						'exclude_from_search'      => false,
					),
	        ),

        )
    ) );


    Redux::set_section( $opt_name, array(
        'title'            => esc_html__('Page 404', 'syron'),
        'id'               => 'page404_section',
        'desc'             => esc_html__('Page 404 settings', 'syron'),
        'subsection'       => false,
        'icon'             => 'el el-ban-circle',
        'fields'           => array(
            array(
                'id'       => 'page-404-template',
                'type'     => 'select',
                'title'    => esc_html__('Page 404 Template', 'syron'),
                'subtitle' => esc_html__('Select template for page 404.', 'syron'),
                'data'  => 'callback',
                'args' => 'rivax_get_templates_list',
                'desc'     => sprintf(esc_html__('You can create your custom template in %1$s Rivax Templates %2$s section.', 'syron'), '<a target="_blank" href="' . admin_url("edit.php?post_type=rivax-template") . '"><b>', '</b></a>'),
                'default' => '0',
                'select2'  => array( 'allowClear' => false ),
            ),

        )
    ) );


    Redux::set_section( $opt_name, array(
        'title'            => esc_html__('Dark Mode', 'syron'),
        'id'               => 'dark_mode_section',
        'desc'             => esc_html__('Dark Mode settings', 'syron'),
        'subsection'       => false,
        'icon'             => 'el el-idea-alt',
        'fields'           => array(
            array(
                'id'       => 'dark-mode',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Dark Mode', 'syron'),
                'subtitle'     => esc_html__('Enable dark mode for your site.', 'syron'),
            ),
	        array(
		        'id'       => 'default-theme-scheme',
		        'type'     => 'button_set',
		        'title'    => esc_html__('Default Scheme', 'syron'),
		        'desc'     => '',
		        'options'  => array(
			        'light' => esc_html__('Light', 'syron'),
			        'dark'  => esc_html__('Dark', 'syron'),
			        'device'    => esc_html__('Base on Device', 'syron'),
		        ),
		        'default'  => 'light',
		        'required' => array( 'dark-mode', '=', '1' ),
	        ),
			array(
                'id'       => 'always-dark-mode',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Always Dark Mode', 'syron'),
                'subtitle'     => esc_html__('Always load site in dark style and disable the dark mode switcher.', 'syron'),
                'required' => array( 'dark-mode', '=', '1' ),
            ),
            array(
                'id'       => 'accent-color-dark',
                'type'     => 'color',
                'transparent'     => false,
                'title'    => esc_html__('Accent Color', 'syron'),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '',
                'validate' => 'color',
                'required' => array( 'dark-mode', '=', '1' ),
            ),
            array(
                'id'       => 'second-color-dark',
                'type'     => 'color',
                'transparent'     => false,
                'title'    => esc_html__('Second Color', 'syron'),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '',
                'validate' => 'color',
                'required' => array( 'dark-mode', '=', '1' ),
            ),
            array(
                'id'       => 'body-bg-dark',
                'type'     => 'color',
                'transparent'     => false,
                'title'    => esc_html__('Body Background Color', 'syron'),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '',
                'validate' => 'color',
                'required' => array( 'dark-mode', '=', '1' ),
            ),
            array(
                'id'       => 'body-color-dark',
                'type'     => 'color',
                'transparent'     => false,
                'title'    => esc_html__('Body Text Color', 'syron'),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '',
                'validate' => 'color',
                'required' => array( 'dark-mode', '=', '1' ),
            ),
            array(
                'id'       => 'heading-color-dark',
                'type'     => 'color',
                'transparent'     => false,
                'title'    => esc_html__('Headings Color', 'syron'),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '',
                'validate' => 'color',
                'required' => array( 'dark-mode', '=', '1' ),
            ),
            array(
                'id'       => 'button-bg-hover-dark',
                'type'     => 'color',
                'transparent'     => false,
                'title'    => esc_html__('Button Background Hover', 'syron'),
                'subtitle' => '',
                'desc'     => '',
                'default'  => '',
                'validate' => 'color',
                'required' => array( 'dark-mode', '=', '1' ),
            ),

        )
    ) );


    Redux::set_section( $opt_name, array(
        'title'            => esc_html__('Privacy Notice', 'syron'),
        'id'               => 'privacy_notice_section',
        'desc'             => esc_html__('Privacy notice settings', 'syron'),
        'subsection'       => false,
        'icon'             => 'el el-bullhorn',
        'fields'           => array(
            array(
                'id'       => 'privacy-notice',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Privacy Notice', 'syron'),
                'subtitle'     => esc_html__('Show privacy notice popup.', 'syron'),
                'default'  => false,
            ),
            array(
                'id'       => 'privacy-text',
                'type'     => 'textarea',
                'title'    => esc_html__('Privacy Notice Text', 'syron'),
                'subtitle' => esc_html__('Input your privacy or cookie notice text, HTML allowed.', 'syron'),
                'desc'     => '',
                'default'  => html_entity_decode( esc_html__( 'Our site uses cookies. By using this site, you agree to the <a href="#">Privacy Policy</a> and <a href="#">Terms of Use</a>.', 'syron' ) ),
                'required' => array( 'privacy-notice', '=', '1' ),
            ),
            array(
                'id'       => 'privacy-btn-text',
                'type'     => 'text',
                'title'    => esc_html__('Button Text', 'syron'),
                'subtitle' => '',
                'default' => esc_html__('Accept', 'syron'),
                'required' => array( 'privacy-notice', '=', '1' ),
            ),
            array(
                'id'       => 'privacy-position',
                'type'     => 'select',
                'title'    => esc_html__('Privacy Notice Position', 'syron'),
                'subtitle' => esc_html__('Select position for privacy notice bar.', 'syron'),
                'desc'     => '',
                'options'  => array(
                    'bottom-left' => esc_html__('Bottom Left', 'syron'),
                    'bottom-center' => esc_html__('Bottom Center', 'syron'),
                ),
                'select2'  => array( 'allowClear' => false ),
                'default'  => 'bottom-left',
                'required' => array( 'privacy-notice', '=', '1' ),
            ),

        )
    ) );


    Redux::set_section( $opt_name, array(
        'title'            => esc_html__('Breadcrumb', 'syron'),
        'id'               => 'breadcrumb_section',
        'desc'             => esc_html__('Breadcrumb Bar settings', 'syron'),
        'subsection'       => false,
        'icon'             => 'el el-bold',
        'fields'           => array(
            array(
                'id'       => 'breadcrumb',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Breadcrumb', 'syron'),
                'subtitle'     => esc_html__('Show breadcrumb bar.', 'syron'),
                'default'  => false,
            ),
            array(
                'id'       => 'breadcrumb-schema',
                'type'     => 'switch',
                'on'     => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'    => esc_html__('Breadcrumb Schema', 'syron'),
                'subtitle'     => esc_html__('Output breadcrumb structure data.', 'syron'),
                'default'  => false,
                'required' => array( 'breadcrumb', '=', '1' ),
            ),

        )
    ) );


	Redux::set_section( $opt_name, array(
		'title'            => esc_html__('Credentials', 'syron'),
		'id'               => 'credentials_section',
		'desc'             => esc_html__('Credentials settings', 'syron'),
		'subsection'       => false,
		'icon'             => 'el el-globe',
		'fields'           => array(
			array(
				'id'       => 'mailchimp-api-key',
				'type'     => 'text',
				'title'    => esc_html__('Mailchimp Api Key', 'syron'),
				'desc'     => sprintf(esc_html__('The API key for connecting with your Mailchimp account. %1$s Get your API key here. %2$s', 'syron'), '<a target="_blank" href="https://admin.mailchimp.com/account/api"><b>', '</b></a>'),
			),
			array(
				'id'       => 'mailchimp-double-opt-in',
				'type'     => 'switch',
				'on'     => esc_html__('Enable', 'syron'),
				'off'     => esc_html__('Disable', 'syron'),
				'title'    => esc_html__('Enable Mailchimp Double Opt In?', 'syron'),
			),
			array(
                'id'       => 'gtm-id',
                'type'     => 'text',
                'placeholder'     => 'GTM-XXXXXX',
                'title'    => esc_html__('Google Tag Manager Container ID', 'syron'),
                'desc'     => esc_html__('Formatted as GTM-XXXXXX. You can find your container ID in the Google Tag Manager interface.', 'syron'),
            ),
            array(
                'id'       => 'gtag-id',
                'type'     => 'text',
                'placeholder'     => 'G-XXXXXXXXXX',
                'title'    => esc_html__('Google Analytics 4 Measurement ID', 'syron'),
                'desc'     => esc_html__('Formatted as G-XXXXXXXXXX. You can find this ID in the Google Analytics interface. If GTM is filled, this field will be skipped.', 'syron'),
            ),

		)
	) );


	Redux::set_section( $opt_name, array(
		'title'            => esc_html__('Performance', 'syron'),
		'id'               => 'performance_section',
		'desc'             => esc_html__('Performance settings', 'syron'),
		'subsection'       => false,
		'icon'             => 'el el-broom',
		'fields'           => array(
			array(
				'id'       => 'disable-elementor-google-font',
				'type'     => 'switch',
				'on'     => esc_html__('Enable', 'syron'),
				'off'     => esc_html__('Disable', 'syron'),
				'title'    => esc_html__('Disable Load Elementor Google Font', 'syron'),
				'desc'    => esc_html__('If you don\'t use google fonts from the elementor, enable this option to prevent loading unused google fonts.', 'syron'),
			),
			array(
				'id'       => 'disable-emojis',
				'type'     => 'switch',
				'on'     => esc_html__('Enable', 'syron'),
				'off'     => esc_html__('Disable', 'syron'),
				'title'    => esc_html__('Disable Emojis', 'syron'),
				'desc'    => esc_html__('If you don\'t use emojis, enable this option to disable emojis.', 'syron'),
			),
			array(
				'id'       => 'disable-woocommerce-assets-out-of-shop',
				'type'     => 'switch',
				'on'     => esc_html__('Enable', 'syron'),
				'off'     => esc_html__('Disable', 'syron'),
				'title'    => esc_html__('Disable Woocommerce Assets out Of Shop', 'syron'),
				'desc'    => esc_html__('By default woocommerce css/js load on entire site. Enable this option to load them just on woocommerce pages.', 'syron'),
			),
			array(
				'id'       => 'disable-gutenberg-assets',
				'type'     => 'switch',
				'on'     => esc_html__('Enable', 'syron'),
				'off'     => esc_html__('Disable', 'syron'),
				'title'    => esc_html__('Disable Gutenberg Assets Out of Posts', 'syron'),
				'desc'    => esc_html__('By default gutenberg css load on entire site. Enable this option to disable load them from homepage, category & tag archives and pages build with Elementor.', 'syron'),
			),
			array(
				'id'       => 'move-jquery-footer',
				'type'     => 'switch',
				'on'     => esc_html__('Enable', 'syron'),
				'off'     => esc_html__('Disable', 'syron'),
				'title'    => esc_html__('Move JQuery to Footer', 'syron'),
				'desc'    => esc_html__('Move jQuery to the footer for logged-out users. Some plugins may have an issue with this movement.', 'syron'),
			),
			array(
				'id'       => 'disable-jquery-migrate',
				'type'     => 'switch',
				'on'     => esc_html__('Enable', 'syron'),
				'off'     => esc_html__('Disable', 'syron'),
				'title'    => esc_html__('Disable JQuery Migrate', 'syron'),
				'desc'    => esc_html__('Disable JQuery migrate for logged-out users.', 'syron'),
			),
            array(
                'id'      => 'disable-xmlrpc',
                'type'    => 'switch',
                'on'      => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'   => esc_html__('Disable XML-RPC + Pingback', 'syron'),
                'desc'    => esc_html__('Disable support for third-party application access.', 'syron'),
            ),
            array(
                'id'      => 'disable-rsdlink',
                'type'    => 'switch',
                'on'      => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'   => esc_html__('Disable RSD', 'syron'),
                'desc'    => esc_html__('Disable the Really Simple Discovery (RSD) tag. If you edit your site from your browser then you do not need it.', 'syron'),
            ),
            array(
                'id'      => 'disable-shortlink',
                'type'    => 'switch',
                'on'      => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'   => esc_html__('Disable Short Link', 'syron'),
                'desc'    => esc_html__('Disable the Short Link from the head.', 'syron'),
            ),
            array(
                'id'      => 'disable-rssfeeds',
                'type'    => 'switch',
                'on'      => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'   => esc_html__('Disable RSS Feeds', 'syron'),
                'desc'    => esc_html__('Disable the RSS feed links and disable it.', 'syron'),
            ),
            array(
                'id'      => 'disable-generator-tag',
                'type'    => 'switch',
                'on'      => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'   => esc_html__('Disable Generator Tag', 'syron'),
                'desc'    => esc_html__('Disable the generator tag.', 'syron'),
            ),
            array(
                'id'      => 'disable-rest-api',
                'type'    => 'switch',
                'on'      => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'   => esc_html__('Disable REST API', 'syron'),
                'desc'    => esc_html__('Disable REST API for none logged in users. Some plugins need Rest API. If your plugins are not working correctly, disable this option.', 'syron'),
            ),
            array(
                'id'      => 'disable-revisions',
                'type'    => 'switch',
                'on'      => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'   => esc_html__('Disable Revisions', 'syron'),
                'desc'    => esc_html__('Reduce your database size by not storing revisions of posts.', 'syron'),
            ),
            array(
                'id'      => 'disable-oembed',
                'type'    => 'switch',
                'on'      => esc_html__('Enable', 'syron'),
                'off'     => esc_html__('Disable', 'syron'),
                'title'   => esc_html__('Disable Oembeds', 'syron'),
                'desc'    => esc_html__('Prevent other websites from embedding your site.', 'syron'),
            ),

		)
	) );


    Redux::set_section( $opt_name, array(
        'title'            => esc_html__('Custom Code', 'syron'),
        'id'               => 'custom_code_section',
        'desc'             => esc_html__('Customize your site with some custom code', 'syron'),
        'subsection'       => false,
        'icon'             => 'el el-css',
        'fields'           => array(
            array(
                'id'       => 'custom-css',
                'type'     => 'ace_editor',
                'title'    => esc_html__('Custom CSS', 'syron'),
                'mode'     => 'css',
            ),
        )
    ) );


	Redux::set_section( $opt_name, array(
		'title'            => esc_html__('Translate', 'syron'),
		'id'               => 'translate_section',
		'desc'             => esc_html__('Translate some frontend strings', 'syron'),
		'subsection'       => false,
		'icon'             => 'el el-flag',
		'fields'           => array(
			array(
				'id'       => 'translate-author',
				'type'     => 'text',
				'title'    => esc_html__('Author', 'syron'),
			),
			array(
				'id'       => 'translate-follow-me',
				'type'     => 'text',
				'title'    => esc_html__('Follow Me', 'syron'),
			),
			array(
				'id'       => 'translate-by',
				'type'     => 'text',
				'title'    => esc_html__('By', 'syron'),
			),
			array(
				'id'       => 'translate-one-min-read',
				'type'     => 'text',
				'title'    => esc_html__('One Min Read', 'syron'),
			),
			array(
				'id'       => 'translate-min-read',
				'type'     => 'text',
				'title'    => esc_html__('Min Read', 'syron'),
			),
			array(
				'id'       => 'translate-views',
				'type'     => 'text',
				'title'    => esc_html__('Views', 'syron'),
			),
			array(
				'id'       => 'translate-comments',
				'type'     => 'text',
				'title'    => esc_html__('Comments', 'syron'),
			),
			array(
				'id'       => 'translate-comment',
				'type'     => 'text',
				'title'    => esc_html__('Comment', 'syron'),
			),
			array(
				'id'       => 'translate-browse',
				'type'     => 'text',
				'title'    => esc_html__('Browse', 'syron'),
			),
			array(
				'id'       => 'translate-browse-category',
				'type'     => 'text',
				'title'    => esc_html__('Browse Category', 'syron'),
			),
			array(
				'id'       => 'translate-browse-tag',
				'type'     => 'text',
				'title'    => esc_html__('Browse Tag', 'syron'),
			),
			array(
				'id'       => 'translate-search-for',
				'type'     => 'text',
				'title'    => esc_html__('Search Result for', 'syron'),
			),
			array(
				'id'       => 'translate-our-articles',
				'type'     => 'text',
				'title'    => esc_html__('Our Articles', 'syron'),
			),
			array(
				'id'       => 'translate-article',
				'type'     => 'text',
				'title'    => esc_html__('Article', 'syron'),
			),
			array(
				'id'       => 'translate-articles',
				'type'     => 'text',
				'title'    => esc_html__('Articles', 'syron'),
			),
			array(
				'id'       => 'translate-search-3dot',
				'type'     => 'text',
				'title'    => esc_html__('Search ...', 'syron'),
			),
			array(
				'id'       => 'translate-next',
				'type'     => 'text',
				'title'    => esc_html__('Next', 'syron'),
			),
			array(
				'id'       => 'translate-previous',
				'type'     => 'text',
				'title'    => esc_html__('Previous', 'syron'),
			),
			array(
				'id'       => 'translate-nothing-found',
				'type'     => 'text',
				'title'    => esc_html__('Nothing found!', 'syron'),
			),
			array(
				'id'       => 'translate-looks-like-nothing-found',
				'type'     => 'text',
				'title'    => esc_html__('It looks like nothing was found here!', 'syron'),
			),
			array(
                'id'       => 'translate-return-home',
                'type'     => 'text',
                'title'    => esc_html__('Return to Home Page', 'syron'),
            ),
			array(
				'id'       => 'translate-tags',
				'type'     => 'text',
				'title'    => esc_html__('Tags:', 'syron'),
			),
			array(
				'id'       => 'translate-home',
				'type'     => 'text',
				'title'    => esc_html__('Home', 'syron'),
			),
			array(
				'id'       => 'translate-show-comments',
				'type'     => 'text',
				'title'    => esc_html__('Show Comments', 'syron'),
			),
			array(
				'id'       => 'translate-no-comment-be-the-first',
				'type'     => 'text',
				'title'    => esc_html__('No Comment! Be the first one.', 'syron'),
			),
			array(
				'id'       => 'translate-one-comment',
				'type'     => 'text',
				'title'    => esc_html__('One Comment', 'syron'),
			),
			array(
				'id'       => 'translate-name',
				'type'     => 'text',
				'title'    => esc_html__('Name', 'syron'),
			),
			array(
				'id'       => 'translate-email',
				'type'     => 'text',
				'title'    => esc_html__('Email', 'syron'),
			),
			array(
				'id'       => 'translate-website',
				'type'     => 'text',
				'title'    => esc_html__('Website', 'syron'),
			),
			array(
				'id'       => 'translate-updated-on',
				'type'     => 'text',
				'title'    => esc_html__('Updated On', 'syron'),
			),
		)
	) );


}