<?php

$alignwide_max = 940;
?>
:root {
    --accent-color: <?php echo rivax_get_option('accent-color')?: '#ff5671'; ?>;
    --accent-color-alt: #FFF;
    --second-color: <?php echo rivax_get_option('second-color')?: '#ff5671'; ?>;
    --second-color-alt: #FFF;
    --body-color: #474c5d;
    --headings-color: #35344b;
    --shadow-soft: 0 4px 25px #25252e1f;
    --soft-radius: 12px;
}

.container {
    padding-left: 15px;
    padding-right: 15px;
    max-width: 840px;
    margin: 0 auto;
}

body {
    color: var(--body-color);
    background: #fff;
    font-family: <?php echo rivax_get_option('typography-body', 'font-family')?: 'Inter'; ?>, sans-serif;
    font-weight: <?php echo rivax_get_option('typography-body', 'font-weight')?: '400'; ?>;
    font-style: <?php echo rivax_get_option('typography-body', 'font-style')?: 'normal'; ?>;
    line-height: 2;
	letter-spacing: 0.5px;
}

h1, h2, h3, h4, h5, h6, .h1, .h2, .h3, .h4, .h5, .h6 {
    color: var(--headings-color);
    font-family: <?php echo rivax_get_option('typography-heading', 'font-family')?: 'inherit'; ?>;
    font-weight: <?php echo rivax_get_option('typography-heading', 'font-weight')?: '600'; ?>;
    font-style: <?php echo rivax_get_option('typography-heading', 'font-style')?: 'normal'; ?>;
}

a {
    color: var(--accent-color);
    transition: all ease 0.3s;
    text-decoration: none;
}

a:hover {
    color: inherit;
}

/* Generic WP styling */

.alignnone,
.aligncenter,
.alignleft,
.alignright,
.alignwide {
	margin-top: 1em;
	margin-right: auto;
	margin-bottom: 1em;
	margin-left: auto;
}

.alignright {
	float: right;
}

.alignleft {
	float: left;
}

.aligncenter {
	display: block;
	text-align: center;
	margin-left: auto;
	margin-right: auto;
}

.alignwide {
	width: 100%;
}

@media (min-width: 792px) {
	.alignwide {
		width: calc(100vw - 48px);
		max-width: calc(100vw - 48px);
		margin-left: calc(50% - 50vw + 24px);
		margin-right: calc(50% - 50vw + 24px);
	}
}

@media (min-width: <?php echo sprintf( '%dpx', $alignwide_max ); ?>) {
	.alignwide {
		width: calc(<?php echo sprintf( '%dpx', $alignwide_max ); ?> - 48px);
		max-width: calc(<?php echo sprintf( '%dpx', $alignwide_max ); ?> - 48px);
		margin-left: calc(calc(50% - <?php echo sprintf( '%dpx', $alignwide_max ); ?> / 2) + 24px);
		margin-right: calc(calc(50% - <?php echo sprintf( '%dpx', $alignwide_max ); ?> / 2) + 24px);
	}
}

.alignfull {
	width: 100vw;
	max-width: 100vw;
	margin-left: calc(50% - 50vw);
	margin-right: calc(50% - 50vw);
}

.amp-wp-enforced-sizes {
	/** Our sizes fallback is 100vw, and we have a padding on the container; the max-width here prevents the element from overflowing. **/
	max-width: 100%;
	margin: 0 auto;
}

/* Template Styles */

.amp-wp-content,
.amp-wp-title-bar div {
	margin: 0 auto;
	max-width: 840px;
}

p,
ol,
ul,
figure {
	margin: 0 0 1em;
	padding: 0;
}


/* Quotes */

blockquote {
	background: rgba(127,127,127,.125);
	border-<?php echo is_rtl() ? 'right' : 'left'; ?>: 2px solid var(--accent-color);
	margin: 8px 0 24px 0;
	padding: 16px;
}

blockquote p:last-child {
	margin-bottom: 0;
}


/* Header */

.amp-wp-header {
    box-shadow: 0 10px 25px #2a2d3f14;
    margin-bottom: 40px;
    background: #fff;
}

.amp-wp-header-wrap {
    padding: 15px 0;
}

.amp-wp-header-wrap {
    display: flex;
    align-items: center;
    justify-content: space-between;
}

#site-logo {
    font-size: 1.4rem;
    line-height: 1;
    display: block;
}

#site-logo amp-img {
    display: block;
	width: <?php echo intval(rivax_get_option('amp-logo-width')) ?: '100' ?>px;

}

.side-nav-opener {
    border: none;
    width: 30px;
    height: 18px;
    box-shadow: none;
    background: transparent;
    padding: 0;
    margin: 0;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    cursor: pointer;
}

.side-nav-opener span {
    height: 2px;
    width: 100%;
    background: #000;
}

.sidebar-left {
    width: 300px;
    max-width: 100%;
    background: #141418;
    padding: 15px;
}

.side-nav-Close {
    border: none;
    width: 26px;
    height: 18px;
    box-shadow: none;
    background: transparent;
    padding: 0;
    margin: 0 0 30px;
    cursor: pointer;
}

.side-nav-Close span {
    height: 1px;
    width: 100%;
    background: #fff;
    display: block;
    transform: rotate(45deg);
}

.side-nav-Close span + span {
    transform: rotate(-45deg);
}

.amp-nav-wrapper {
    margin-bottom: 50px;
}

.amp-nav-wrapper ul {
    padding: 0;
    margin: 0;
    list-style: none;
}

.amp-nav-wrapper ul ul {
    padding: 0 0 10px 20px;
}

html[dir="rtl"] .amp-nav-wrapper ul ul {
    padding: 0 20px 10px 0;
}

.amp-nav-wrapper li a {
    text-decoration: none;
    color: #9898a3;
    font-size: 0.9rem;
}

.amp-nav > li > a {
    color: #ffffff;
}

.amp-nav > li {
    border-bottom: 1px solid #47474c;
    line-height: 2.2;
}

.search-form {
    display: flex;
    gap: 5px;
    margin-bottom: 30px;
}

.search-form .search-field {
    flex-grow: 1;
    background: transparent;
    border: 1px solid #575762;
    padding: 8px;
    border-radius: 3px;
	color: #fff;
}

.search-form .submit {
    border: none;
    background: #575762;
    color: #fff;
    border-radius: 3px;
    padding: 8px;
    cursor: pointer;
}

/* Article Header */

.single-hero-title {
    margin-bottom: 30px;
}

.single-hero-title .category {
    display: flex;
    flex-wrap: wrap;
    row-gap: 5px;
    column-gap: 15px;
}

.single-hero-title .category a {
    display: flex;
    gap: 2px;
    font-weight: 500;
    white-space: nowrap;
    font-size: 0.9rem;
    position: relative;
    color: var(--body-color);
    transition: 0.3s;
}

.single-hero-title .category a:hover {
    color: var(--term-color, var(--accent-color));
}

.single-hero-title .category a::before {
    content: '#';
    color: var(--term-color, var(--accent-color));
}

.single-hero-title .category a::after {
    content: '';
    position: absolute;
    left: 0;
    bottom: 0;
    width: 100%;
    transform: translateY(3px);
    height: 1px;
    opacity: 0;
    transition: 0.3s;
    background: var(--term-color, var(--accent-color));
}

.single-hero-title .category a:hover::after {
    transform: translateY(0);
    opacity: 1;
}

.single-hero-title .title {
    border-bottom: 1px solid #dfe1ea;
    word-wrap: break-word;
    margin: 5px 0 20px;
}

.single-hero-title .excerpt {
    opacity: 0.8;
    font-style: italic;
}

.single-hero-meta .author-name {
    color: inherit;
    font-weight: 600;
    position: relative;
}

.single-hero-meta .author-name::after {
    content: '';
    position: absolute;
    left: 0;
    bottom: 0;
    width: 100%;
    transform: translateY(3px);
    height: 1px;
    opacity: 0;
    transition: 0.3s;
    background: currentColor;
}

.single-hero-meta .author-name:hover::after {
    transform: translateY(0);
    opacity: 1;
}

.single-hero-meta {
    display: flex;
    align-items: end;
    flex-wrap: wrap;
    gap: 10px;
    font-size: 0.9rem;
    color: #51535a;
}

.single-hero-meta .meta-1 {
    flex-shrink: 0;
}

.single-hero-meta .author-avatar img {
    width: 45px;
    border-radius: 50%;
}

.single-hero-meta .meta-2 {
    flex-grow: 1;
}

.single-hero-meta .meta-item {
    position: relative;
    display: inline-block;
}

.single-hero-meta .meta-2 .meta-item + .meta-item::before {
    content: '/';
    display: inline-block;
    margin: 0 3px;
}

.single-hero-meta .meta-3 {
    display: none;
}

/* Featured image */

.amp-wp-article-featured-image img {
    width: 100%;
    border-radius: var(--soft-radius);
    box-shadow: var(--shadow-soft);

}

.article-featured-link {
    background: #ffefe6;
    border-radius: var(--soft-radius);
    padding: 25px;
    color: var(--headings-color);
    letter-spacing: 1px;
}

.article-featured-link .link {
    font-size: 1.3rem;
    text-overflow: ellipsis;
    white-space: nowrap;
    overflow: hidden;
    color: inherit;
}

.article-featured-link .title {
    margin: 10px 0 0;
    font-style: italic;
}

.article-featured-quote {
    padding: 25px;
    background: #ffefe6;
    border-radius: var(--soft-radius);
    color: var(--headings-color);
}

.article-featured-quote .content {
    font-size: 1.05rem;
    margin: 0;
}

.article-featured-quote .author {
    margin: 10px 0 0;
    font-style: italic;
}

/* Article Content */

.amp-wp-article-content {
	margin: 0 16px;
}

.amp-wp-article-content ul,
.amp-wp-article-content ol {
	margin-<?php echo is_rtl() ? 'right' : 'left'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>: 1em;
}

.amp-wp-article-content .wp-caption {
	max-width: 100%;
}

.amp-wp-article-content amp-img {
	margin: 0 auto;
}

.amp-wp-article-content amp-img.alignright,
.amp-wp-article-content .wp-block-cover.alignright {
	margin: 0 0 1em 16px;
}

.amp-wp-article-content amp-img.alignleft,
.amp-wp-article-content .wp-block-cover.alignleft {
	margin: 0 16px 1em 0;
}

.rivax-toc-wrap {
    border-radius: var(--soft-radius);
    box-shadow: 0 2px 4px #0e0e131f;
    overflow: hidden;
	margin-top: 1rem;
    margin-bottom: 2rem;
}

.rivax-toc-wrap .toc-header {
    padding: 10px;
    background: var(--accent-color);
    color: #fff;
}

.toc-header-title-wrap h3 {
    margin: 0;
    font-size: 1.1rem;
    color: inherit;
}

.toc-header-collapse {
    display: none;
}

.amp-wp-article-content ul.rivax-toc-items, .rivax-toc-items {
    list-style: none;
    margin: 0;
    padding: 20px;
}

.rivax-toc-anchor {
	color: inherit;
}

.rivax-toc-anchor:hover {
    color: var(--accent-color);
    text-decoration: underline;
    text-underline-offset: 4px;
}

.rivax-toc-items.toc-counter li {
    counter-increment: tocCounter;
}
.rivax-toc-items.toc-counter li:before {
    content: counter(tocCounter) ". ";
}

/* Captions */

.wp-caption {
	padding: 0;
}

.wp-caption.alignleft {
	margin-right: 16px;
}

.wp-caption.alignright {
	margin-left: 16px;
}

.wp-caption .wp-caption-text {
	border-bottom: 1px solid var(--accent-color);
	color: #555;
	font-size: .875em;
	line-height: 1.5em;
	margin: 0;
	padding: .66em 10px .75em;
}

/* AMP Media */

.alignwide,
.alignfull {
	clear: both;
}

.amp-wp-article-content amp-carousel amp-img {
	border: none;
}

amp-carousel > amp-img > img {
	object-fit: contain;
}

.amp-wp-iframe-placeholder {
	background: #f3f3f6 url( <?php echo esc_url( $this->get( 'placeholder_image_url' ) ); ?> ) no-repeat center 40%;
	background-size: 48px 48px;
	min-height: 48px;
}

.wp-block-image:not(.is-style-rounded) img,
.wp-block-media-text__media img,
.slide.amp-carousel-slide img {
    border-radius: var(--soft-radius);
}

amp-carousel {
    max-height: 600px;
}

.amp-wp-article-content .wp-block-image figcaption a {
    width: auto;
}

/* Article Footer Meta */

.amp-wp-article-footer {
    border-top: 1px solid #e9e9f1;
}

.amp-wp-article-footer .amp-wp-meta {
	display: block;
}

.amp-wp-tax-category,
.amp-wp-tax-tag {
	font-size: .9rem;
    line-height: 1.5em;
    margin: 1.5em 16px;
    font-weight: 500;
}

.amp-wp-comments-link {
    color: #555;
	font-size: .875em;
	line-height: 1.5em;
	text-align: center;
	margin: 2.25em 0 1.5em;
}

.amp-wp-comments-link a {
    border-radius: 50px;
    background-color: var(--accent-color);
    color: var(--accent-color-alt);
    cursor: pointer;
    display: inline-block;
    letter-spacing: 1px;
    padding: 10px 25px;
    box-shadow: 0 10px 25px var(--accent-color);
}

/* AMP Footer */

.amp-footer {
    border-top: 1px solid #e9e9f1;
    margin: 60px 0 0;
    padding: 30px 0;
    text-align: center;
}

#footer-logo {
    font-size: 1.4rem;
}

#footer-logo amp-img {
    display: block;
    width: <?php echo intval(rivax_get_option('amp-logo-width')) ?: '100' ?>px;
}

.footer-copyright {
    color: #6b6d77;
    font-size: 0.9rem;
    margin: 10px 0;
}

.back-to-top {
    font-size: .85em;
    letter-spacing: 1px;
    font-weight: 600;
    margin-top: 15px;
    display: inline-block;
}

#amp-mobile-version-switcher>a {
    background-color: #262834;
}