<?php
/**
 * Template part for displaying comments list and form
 */

if ( rivax_get_option('disable-comments') ) {
    return;
}

$comments_count = get_comments_number();

// If comments are not open and there is no comment, return
if ( !comments_open() &&  !$comments_count ) {
    return;
}


/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password,
 * return early without loading the comments.
 */
if ( post_password_required() ) {
    return;
}

$compact_view = rivax_get_option('compact-comments') && ($comments_count > 4);
?>

<div class="comments-container" id="comments">
    <div class="comments-area card-layout-w">
        <div class="comments-title">
            <div class="rivax-divider-heading divider-style-1">
                <div class="divider divider-1"></div>
                <div class="divider divider-2"></div>
                <h5 class="title">
                        <span class="title-inner">
                            <span class="title-text">
                                <?php
                                if( $comments_count == 0 ) {
									echo rivax_get_option('translate-no-comment-be-the-first')?: esc_html__( 'No Comment! Be the first one.', 'syron' );
                                }
                                elseif ( $comments_count == 1 ) {
									echo rivax_get_option('translate-one-comment')?: esc_html__( 'One Comment', 'syron' );
                                }
                                else {
									echo intval($comments_count) . ' ';
									echo rivax_get_option('translate-comments')?: esc_html__( 'Comments', 'syron' );
                                }
                                ?>
                            </span>
                        </span>
                </h5>
                <div class="divider divider-3"></div>
                <div class="divider divider-4"></div>
            </div>
        </div>
        <div class="comment-list-wrapper<?php if($compact_view) echo ' compact'; ?>">
            <ol class="comment-list">
		        <?php
		        wp_list_comments(
			        array(
				        'avatar_size' => 60,
				        'style'       => 'ol',
			        )
		        );
		        ?>
            </ol><!-- .comment-list -->
	        <?php
	        the_comments_pagination(
		        array(
			        'prev_text'          => esc_html__( 'Older comments', 'syron' ),
			        'next_text'          => esc_html__( 'Newer comments', 'syron' ),
		        )
	        );
	        ?>
	        <?php 
			if($compact_view) {
				$label = rivax_get_option('translate-show-comments')?: esc_html__( 'Show Comments', 'syron' );
				echo '<span class="comments-compact-btn">' . esc_html($label) . '</span>';
			}
			?>
        </div>

        <?php if ( ! comments_open() ) : ?>
            <p class="comments-closed"><?php esc_html_e( 'Comments are closed.', 'syron' ); ?></p>
        <?php endif; ?>


        <?php
        $commenter = wp_get_current_commenter();

        $req = get_option( 'require_name_email' );
        $aria_req = $req ? " required" : '';
        $req_sign = $req ? ' *' : '';
		$placeholder_name = rivax_get_option('translate-name')?: esc_attr__( 'Name', 'syron' );
		$placeholder_email = rivax_get_option('translate-email')?: esc_attr__( 'Email', 'syron' );
		$placeholder_website = rivax_get_option('translate-website')?: esc_attr__( 'Website', 'syron' );
        $fields =  array(
            'author' => '<input class="form-author" id="author" name="author" type="text" size="30" maxlength="245" placeholder="' . esc_attr($placeholder_name) . $req_sign . '" value="' . esc_attr( $commenter['comment_author'] ) . '" ' . $aria_req . ' >',
            'email' => '<input class="form-email" id="email" name="email" type="email" size="30" maxlength="200" placeholder="' . esc_attr($placeholder_email) . $req_sign . '" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" ' . $aria_req . ' >',
            'url' => '<input class="form-website" id="url" name="url" type="url" size="30" maxlength="200" placeholder="' . esc_attr($placeholder_website). '" value="' . esc_attr( $commenter['comment_author_url'] ) . '" >',
        );

        $fields = apply_filters( 'comment_form_default_fields', $fields );
		$placeholder_comment = rivax_get_option('translate-comment')?: esc_html__( 'Comment', 'syron' );

        $comments_args = array(
            'fields' => $fields,
            'comment_field' => '<textarea id="comment" name="comment" rows="8" class="form-textarea" placeholder="' . esc_attr($placeholder_comment) . '" required></textarea>',
            'format'               => 'html5',
            );

        comment_form($comments_args);
        ?>
    </div>
</div>
