<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

class Rivax_Elementor_Custom_Settings {

    /**
     * A reference to an instance of this class.
     */
    private static $instance = null;


    /**
     * Load Construct
     *
     */
    public function __construct(){

        add_action( 'elementor/element/container/section_layout/after_section_end', array( $this, 'container_settings' ) );
        add_action( 'elementor/frontend/container/before_render',  array( $this, 'container_before_render' ) );
	    add_action( 'elementor/container/print_template',  array( $this, 'container_editor_render' ), 10, 2 );

        add_action( 'elementor/element/common/_section_border/after_section_end', array( $this, 'widgets_common_settings' ) );

        add_action( 'elementor/element/container/section_shape_divider/after_section_end', array( $this, 'container_dark_mode' ) );
        add_action( 'elementor/element/heading/section_title_style/after_section_end', array( $this, 'heading_widget_dark_mode' ) );
        add_action( 'elementor/element/text-editor/section_style/after_section_end', array( $this, 'text_editor_widget_dark_mode' ) );
        add_action( 'elementor/element/image-box/section_style_content/after_section_end', array( $this, 'image_box_widget_dark_mode' ) );
        add_action( 'elementor/element/icon/section_style_icon/after_section_end', array( $this, 'icon_widget_dark_mode' ) );
        add_action( 'elementor/element/icon-box/section_style_content/after_section_end', array( $this, 'icon_box_widget_dark_mode' ) );
        add_action( 'elementor/element/button/section_style/after_section_end', array( $this, 'button_widget_dark_mode' ) );
        add_action( 'elementor/element/icon-list/section_text_style/after_section_end', array( $this, 'icon_list_widget_dark_mode' ) );
        add_action( 'elementor/element/counter/section_title/after_section_end', array( $this, 'counter_widget_dark_mode' ) );
        add_action( 'elementor/element/divider/section_icon_style/after_section_end', array( $this, 'divider_widget_dark_mode' ) );
        add_action( 'elementor/element/nested-accordion/section_content_style/after_section_end', array( $this, 'nested_accordion_widget_dark_mode' ) );
        add_action( 'elementor/element/nested-tabs/section_box_style/after_section_end', array( $this, 'nested_tabs_widget_dark_mode' ) );

    }


    /**
     * Returns the instance.
     *
     * @since  1.0.0
     * @access public
     * @return object
     */
    public static function get_instance() {
        // If the single instance hasn't been set, set it now.
        if ( null == self::$instance ) {
            self::$instance = new self;
        }
        return self::$instance;
    }

    public function container_settings ( $obj ) {

        // Sticky Column
        $obj->start_controls_section(
            'rivax_container_extra_section',
            array(
                'label' => esc_html__( 'Rivax Settings', 'syron' ),
                'tab'   => Controls_Manager::TAB_ADVANCED,
            )
        );

        $obj->add_control(
            'rivax_sticky_column_enable',
            array(
                'label'        => esc_html__( 'Sticky Column', 'syron' ),
                'type'         => Controls_Manager::SWITCHER,
            )
        );


		// particles
	    $obj->add_control(
		    'rivax_particles_enable',
		    [
			    'label'        => esc_html__( 'Particle Background', 'syron' ),
			    'type'         => Controls_Manager::SWITCHER,
			    'render_type'  => 'template',
				'assets' => [
	                'scripts' => [
		                [
			                'name' => 'rivax-particles',
			                'conditions' => [
				                'terms' => [
					                [
						                'name' => 'rivax_particles_enable',
						                'operator' => '!==',
						                'value' => '',
					                ],
				                ],
			                ],
		                ],
	                ],
                ],
		    ]
	    );

	    $obj->add_control(
		    'rivax_particles_zindex',
		    [
			    'label'              => esc_html__('Z-index', 'syron' ),
			    'type'               => Controls_Manager::NUMBER,
			    'selectors' => [
				    '{{WRAPPER}} .rivax-particles-wrapper' => 'z-index: {{VALUE}};',
			    ],
			    'condition'          => [
				    'rivax_particles_enable' => 'yes',
			    ],
		    ]
	    );

	    $obj->add_control(
		    'rivax_particles_opacity',
		    [
			    'label'     => esc_html__( 'Opacity', 'syron' ),
			    'type'      => Controls_Manager::SLIDER,
			    'range'     => [
				    'px' => [
					    'min' => 0,
					    'max' => 1,
					    'step' => 0.1,
				    ],
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .rivax-particles-wrapper' => 'opacity: {{SIZE}};',
			    ],
			    'condition'          => [
				    'rivax_particles_enable' => 'yes',
			    ],
		    ]
	    );

	    $obj->add_control(
		    'rivax_particles_json',
		    [
			    'type'    => Controls_Manager::TEXTAREA,
			    'rows' => 10,
			    'label'   => esc_html__('Add Particle Json', 'syron' ),
			    'description'       => sprintf(esc_html__('%sClick here%s to generate particle JSON. %sSamples%s', 'syron'), '<a href="' . esc_url('https://vincentgarreau.com/particles.js/') . '" target="_blank">', '</a>', '<a href="' . esc_url(RIVAX_THEME_URI . '/assets/js/particles-sample.txt') . '" target="_blank">', '</a>'),
			    'render_type' => 'template',
			    'condition' => [
				    'rivax_particles_enable' => 'yes'
			    ]
		    ]
	    );

        $obj->end_controls_section();

    }


    public function container_dark_mode ( $obj ) {

        $obj->start_controls_section(
            'section_rivax_dark_mode',
            [
                'label' => esc_html__( 'Dark Mode', 'syron' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $obj->add_control(
            'section_background_heading_dark_mode',
            [
                'label'     => esc_html__( 'Background', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $obj->start_controls_tabs( 'tabs_bg_dark_mode' );

        /**
         * Normal.
         */
        $obj->start_controls_tab(
            'tab_background_normal_dark_mode',
            [
                'label' => esc_html__( 'Normal', 'syron' ),
            ]
        );

        $obj->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'bg_dark_mode',
                'selector' => 'html[scheme="dark"] {{WRAPPER}}',
            ]
        );

        $obj->add_control(
            'border_color_dark_mode',
            [
                'label'     => esc_html__( 'border Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_tab();

        /**
         * Hover.
         */
        $obj->start_controls_tab(
            'tab_background_hover_dark_mode',
            [
                'label' => esc_html__( 'Hover', 'syron' ),
            ]
        );

        $obj->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'background_hover_dark_mode',
                'selector' => 'html[scheme="dark"] {{WRAPPER}}:hover',
            ]
        );

        $obj->add_control(
            'border_color_hover_dark_mode',
            [
                'label'     => esc_html__( 'Border Color Hover', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_tab();

        $obj->end_controls_tabs();


        $obj->add_control(
            'section_background_overlay_heading_dark_mode',
            [
                'label'     => esc_html__( 'Background Overlay', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $obj->start_controls_tabs( 'tabs_background_overlay_dark_mode' );

        /**
         * Normal.
         */
        $obj->start_controls_tab(
            'tab_background_overlay_dark_mode',
            [
                'label' => esc_html__( 'Normal', 'syron' ),
            ]
        );

        $background_overlay_selector = 'html[scheme="dark"] {{WRAPPER}}::before';

        $obj->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'background_overlay_dark_mode',
                'selector' => $background_overlay_selector,
                'fields_options' => [
                    'background' => [
                        'selectors' => [
                            // Hack to set the `::before` content in order to render it only when there is a background overlay.
                            $background_overlay_selector => '--background-overlay: \'\';',
                        ],
                    ],
                ],
            ]
        );


        $obj->end_controls_tab();

        /**
         * Hover.
         */
        $obj->start_controls_tab(
            'tab_background_overlay_hover_dark_mode',
            [
                'label' => esc_html__( 'Hover', 'syron' ),
            ]
        );

        $background_overlay_hover_selector = 'html[scheme="dark"] {{WRAPPER}}:hover::before';

        $obj->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'background_overlay_hover_dark_mode',
                'selector' => $background_overlay_hover_selector,
                'fields_options' => [
                    'background' => [
                        'selectors' => [
                            // Hack to set the `::before` content in order to render it only when there is a background overlay.
                            $background_overlay_hover_selector => '--background-overlay: \'\';',
                        ],
                    ],
                ],
            ]
        );

        $obj->end_controls_tab();

        $obj->end_controls_tabs();


        $obj->add_control(
            'shape_dark_mode_heading',
            [
                'label'     => esc_html__( 'Shape Divider', 'syron' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $obj->add_control(
            'shape_top_color_dark_mode',
            [
                'label'     => esc_html__( 'Top Shape', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} > .e-con-inner > .elementor-shape-top .elementor-shape-fill' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'shape_bottom_color_dark_mode',
            [
                'label'     => esc_html__( 'Bottom Shape', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} > .e-con-inner > .elementor-shape-bottom .elementor-shape-fill' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_section();


    }

    /**
     * Before container render callback.
     *
     * @param object $element
     *
     * @return void
     */
    public function container_before_render( $element ) {
        $data     = $element->get_data();
        $settings = $data['settings'];

	    if ( !empty($settings['rivax_sticky_column_enable']) ) {

		    $element->add_render_attribute( '_wrapper', array(
			    'class' => 'rivax-sticky-column',
		    ) );
	    }

	    if ( !empty($settings['rivax_particles_enable']) && !empty($settings['rivax_particles_json']) ) {

		    wp_enqueue_script('rivax-particles');
		    $element->add_render_attribute( '_wrapper', array(
			    'class' => 'rivax-particles',
			    'data-rivax-particles' => esc_attr(preg_replace('/\s+/', ' ',$settings['rivax_particles_json'])),
		    ) );
	    }
    }


	public function container_editor_render($template, $widget) {
		if ($widget->get_name() != 'container') {
			return $template;
		}
		ob_start();
		?>
		<# if ( settings.rivax_particles_enable && settings.rivax_particles_json ) { #>
		<div class="rivax-particles-wrapper" id="rivax-particles-{{ view.getID() }}" data-rivax-particles="{{ settings.rivax_particles_json }}"></div>
		<# } #>
		<?php
		$particle_content = ob_get_contents();
		ob_end_clean();
		return $particle_content . $template;
	}


    public function heading_widget_dark_mode ( $obj ) {

        $obj->start_controls_section(
            'section_rivax_dark_mode',
            [
                'label' => esc_html__( 'Dark Mode', 'syron' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $obj->add_control(
            'color_dark_mode',
            [
                'label'     => esc_html__( 'Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .elementor-heading-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_section();
    }


    public function text_editor_widget_dark_mode ( $obj ) {

        $obj->start_controls_section(
            'section_rivax_dark_mode',
            [
                'label' => esc_html__( 'Dark Mode', 'syron' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $obj->add_control(
            'color_dark_mode',
            [
                'label'     => esc_html__( 'Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}' => 'color: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_section();
    }


    public function image_box_widget_dark_mode ( $obj ) {

        $obj->start_controls_section(
            'section_rivax_dark_mode',
            [
                'label' => esc_html__( 'Dark Mode', 'syron' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $obj->add_control(
            'title_color_dark_mode',
            [
                'label'     => esc_html__( 'Title Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .elementor-image-box-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'description_color_dark_mode',
            [
                'label'     => esc_html__( 'Description Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .elementor-image-box-description' => 'color: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_section();


    }


	public function button_widget_dark_mode ( $obj ) {

		$obj->start_controls_section(
			'section_rivax_dark_mode',
			[
				'label' => esc_html__( 'Dark Mode', 'syron' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);


		$obj->start_controls_tabs( 'tabs_button_style_dark_mode');

		$obj->start_controls_tab(
			'tab_button_normal_dark_mode',
			[
				'label' => esc_html__( 'Normal', 'syron' ),
			]
		);

		$obj->add_control(
			'button_text_color_dark_mode',
			[
				'label' => esc_html__( 'Text Color', 'syron' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'html[scheme="dark"] {{WRAPPER}} .elementor-button' => 'fill: {{VALUE}}; color: {{VALUE}};',
				],
			]
		);

		$obj->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background_dark_mode',
				'types' => [ 'classic', 'gradient' ],
				'exclude' => [ 'image' ],
				'selector' => 'html[scheme="dark"] {{WRAPPER}} .elementor-button',
			]
		);

		$obj->add_control(
			'button_border_color_dark_mode',
			[
				'label' => esc_html__( 'Border Color', 'syron' ),
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'border_border!' => '',
				],
				'selectors' => [
					'html[scheme="dark"] {{WRAPPER}} .elementor-button' => 'border-color: {{VALUE}};',
				],
			]
		);

		$obj->end_controls_tab();

		$obj->start_controls_tab(
			'tab_button_hover_dark_mode',
			[
				'label' => esc_html__( 'Hover', 'syron' ),
			]
		);

		$obj->add_control(
			'hover_color_dark_mode',
			[
				'label' => esc_html__( 'Text Color', 'syron' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'html[scheme="dark"] {{WRAPPER}} .elementor-button:hover, html[scheme="dark"] {{WRAPPER}} .elementor-button:focus' => 'color: {{VALUE}};',
					'html[scheme="dark"] {{WRAPPER}} .elementor-button:hover svg, html[scheme="dark"] {{WRAPPER}} .elementor-button:focus svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$obj->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'button_background_hover_dark_mode',
				'types' => [ 'classic', 'gradient' ],
				'exclude' => [ 'image' ],
				'selector' => 'html[scheme="dark"] {{WRAPPER}} .elementor-button:hover, html[scheme="dark"] {{WRAPPER}} .elementor-button:focus',
			]
		);

		$obj->add_control(
			'button_hover_border_color_dark_mode',
			[
				'label' => esc_html__( 'Border Color', 'syron' ),
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'border_border!' => '',
				],
				'selectors' => [
					'html[scheme="dark"] {{WRAPPER}} .elementor-button:hover, html[scheme="dark"] {{WRAPPER}} .elementor-button:focus' => 'border-color: {{VALUE}};',
				],
			]
		);

		$obj->end_controls_tab();

		$obj->end_controls_tabs();

		$obj->end_controls_section();


	}


    public function icon_box_widget_dark_mode ( $obj ) {

        $obj->start_controls_section(
            'section_rivax_dark_mode',
            [
                'label' => esc_html__( 'Dark Mode', 'syron' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $obj->add_control(
            'primary_color_dark_mode',
            [
                'label' => esc_html__( 'Icon Primary Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}.elementor-view-stacked .elementor-icon' => 'background-color: {{VALUE}};',
                    'html[scheme="dark"] {{WRAPPER}}.elementor-view-framed .elementor-icon, html[scheme="dark"] {{WRAPPER}}.elementor-view-default .elementor-icon' => 'fill: {{VALUE}}; color: {{VALUE}}; border-color: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'secondary_color_dark_mode',
            [
                'label' => esc_html__( 'Icon Secondary Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'view!' => 'default',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}.elementor-view-framed .elementor-icon' => 'background-color: {{VALUE}};',
                    'html[scheme="dark"] {{WRAPPER}}.elementor-view-stacked .elementor-icon' => 'fill: {{VALUE}}; color: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'title_color_dark_mode',
            [
                'label'     => esc_html__( 'Title Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .elementor-icon-box-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'description_color_dark_mode',
            [
                'label'     => esc_html__( 'Description Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .elementor-icon-box-description' => 'color: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_section();


    }

    public function icon_widget_dark_mode ( $obj ) {

        $obj->start_controls_section(
            'section_rivax_dark_mode',
            [
                'label' => esc_html__( 'Dark Mode', 'syron' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $obj->add_control(
            'primary_color_dark_mode',
            [
                'label' => esc_html__( 'Primary Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}.elementor-view-stacked .elementor-icon' => 'background-color: {{VALUE}};',
                    'html[scheme="dark"] {{WRAPPER}}.elementor-view-framed .elementor-icon, html[scheme="dark"] {{WRAPPER}}.elementor-view-default .elementor-icon' => 'color: {{VALUE}}; border-color: {{VALUE}};',
                    'html[scheme="dark"] {{WRAPPER}}.elementor-view-framed .elementor-icon, html[scheme="dark"] {{WRAPPER}}.elementor-view-default .elementor-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'secondary_color_dark_mode',
            [
                'label' => esc_html__( 'Secondary Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'view!' => 'default',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}.elementor-view-framed .elementor-icon' => 'background-color: {{VALUE}};',
                    'html[scheme="dark"] {{WRAPPER}}.elementor-view-stacked .elementor-icon' => 'color: {{VALUE}};',
                    'html[scheme="dark"] {{WRAPPER}}.elementor-view-stacked .elementor-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_section();


    }

    public function icon_list_widget_dark_mode ( $obj ) {

        $obj->start_controls_section(
            'section_rivax_dark_mode',
            [
                'label' => esc_html__( 'Dark Mode', 'syron' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $obj->add_control(
            'divider_color_dark_mode',
            [
                'label' => esc_html__( 'Divider Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'divider' => 'yes',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .elementor-icon-list-item:not(:last-child):after' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $obj->add_control(
            'icon_color_dark_mode',
            [
                'label' => esc_html__( 'Icon Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .elementor-icon-list-icon i' => 'color: {{VALUE}};',
                    'html[scheme="dark"] {{WRAPPER}} .elementor-icon-list-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'icon_color_hover_dark_mode',
            [
                'label' => esc_html__( 'Icon Hover', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .elementor-icon-list-item:hover .elementor-icon-list-icon i' => 'color: {{VALUE}};',
                    'html[scheme="dark"] {{WRAPPER}} .elementor-icon-list-item:hover .elementor-icon-list-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'text_color_dark_mode',
            [
                'label' => esc_html__( 'Text Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .elementor-icon-list-text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'text_color_hover_dark_mode',
            [
                'label' => esc_html__( 'Text Hover', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .elementor-icon-list-item:hover .elementor-icon-list-text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_section();


    }

    public function counter_widget_dark_mode ( $obj ) {

        $obj->start_controls_section(
            'section_rivax_dark_mode',
            [
                'label' => esc_html__( 'Dark Mode', 'syron' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $obj->add_control(
            'number_color_dark_mode',
            [
                'label' => esc_html__( 'Number Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .elementor-counter-number-wrapper' => 'color: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'title_color_dark_mode',
            [
                'label' => esc_html__( 'Title Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .elementor-counter-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_section();


    }


    public function divider_widget_dark_mode ( $obj ) {

        $obj->start_controls_section(
            'section_rivax_dark_mode',
            [
                'label' => esc_html__( 'Dark Mode', 'syron' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $obj->add_control(
            'color_dark_mode',
            [
                'label' => esc_html__( 'Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'render_type' => 'template',
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}' => '--divider-color: {{VALUE}}',
                ],
            ]
        );

        $obj->add_control(
            'text_color_dark_mode',
            [
                'label' => esc_html__( 'Text Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .elementor-divider__text' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'look' => 'line_text',
                ],
            ]
        );

        $obj->add_control(
            'primary_color_dark_mode',
            [
                'label' => esc_html__( 'Icon Primary Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}.elementor-view-stacked .elementor-icon' => 'background-color: {{VALUE}};',
                    'html[scheme="dark"] {{WRAPPER}}.elementor-view-framed .elementor-icon, {{WRAPPER}}.elementor-view-default .elementor-icon' => 'color: {{VALUE}}; border-color: {{VALUE}};',
                    'html[scheme="dark"] {{WRAPPER}}.elementor-view-framed .elementor-icon, {{WRAPPER}}.elementor-view-default .elementor-icon svg' => 'fill: {{VALUE}};',
                ],
                'condition' => [
                    'look' => 'line_icon',
                ],
            ]
        );

        $obj->add_control(
            'secondary_color_dark_mode',
            [
                'label' => esc_html__( 'Icon Secondary Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'condition' => [
                    'look' => 'line_icon',
                    'icon_view!' => 'default',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}.elementor-view-framed .elementor-icon' => 'background-color: {{VALUE}};',
                    'html[scheme="dark"] {{WRAPPER}}.elementor-view-stacked .elementor-icon' => 'color: {{VALUE}};',
                    'html[scheme="dark"] {{WRAPPER}}.elementor-view-stacked .elementor-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_section();

    }


    public function nested_accordion_widget_dark_mode ( $obj ) {

        $obj->start_controls_section(
            'section_rivax_dark_mode',
            [
                'label' => esc_html__( 'Dark Mode', 'syron' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $obj->start_controls_tabs( 'tabs_header_dark_mode' );

        $obj->start_controls_tab(
            'tab_header_normal_dark_mode',
            [
                'label' => esc_html__( 'Normal', 'syron' ),
            ]
        );

        $obj->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'header_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} > .elementor-widget-container > .e-n-accordion > .e-n-accordion-item > .e-n-accordion-item-title',
            ]
        );

        $obj->add_control(
            'header_border_dark_mode',
            [
                'label' => esc_html__( 'Border Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} > .elementor-widget-container > .e-n-accordion > .e-n-accordion-item > .e-n-accordion-item-title' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'header_color_dark_mode',
            [
                'label' => esc_html__( 'Title Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}' => '--n-accordion-title-normal-color: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'header_icon_color_dark_mode',
            [
                'label' => esc_html__( 'Icon Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}' => '--n-accordion-icon-normal-color: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_tab();


        $obj->start_controls_tab(
            'tab_header_hover_dark_mode',
            [
                'label' => esc_html__( 'Hover', 'syron' ),
            ]
        );

        $obj->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'header_bg_hover_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} > .elementor-widget-container > .e-n-accordion > .e-n-accordion-item > .e-n-accordion-item-title:hover',
            ]
        );

        $obj->add_control(
            'header_border_hover_dark_mode',
            [
                'label' => esc_html__( 'Border Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} > .elementor-widget-container > .e-n-accordion > .e-n-accordion-item > .e-n-accordion-item-title:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'header_color_hover_dark_mode',
            [
                'label' => esc_html__( 'Title Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}' => '--n-accordion-title-hover-color: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'header_icon_color_hover_dark_mode',
            [
                'label' => esc_html__( 'Icon Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}' => '--n-accordion-icon-hover-color: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_tab();


        $obj->start_controls_tab(
            'tab_header_active_dark_mode',
            [
                'label' => esc_html__( 'Active', 'syron' ),
            ]
        );

        $obj->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'header_bg_active_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} > .elementor-widget-container > .e-n-accordion > .e-n-accordion-item[open] > .e-n-accordion-item-title',
            ]
        );

        $obj->add_control(
            'header_border_active_dark_mode',
            [
                'label' => esc_html__( 'Border Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} > .elementor-widget-container > .e-n-accordion > .e-n-accordion-item[open] > .e-n-accordion-item-title' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'header_color_active_dark_mode',
            [
                'label' => esc_html__( 'Title Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}' => '--n-accordion-title-active-color: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'header_icon_color_active_dark_mode',
            [
                'label' => esc_html__( 'Icon Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}' => '--n-accordion-icon-active-color: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_tab();
        $obj->end_controls_tabs();

        $obj->add_control(
            'content_heading_dark_mode',
            [
                'label'     => esc_html__( 'Content', 'syron' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $obj->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'content_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => ':where( html[scheme="dark"] {{WRAPPER}} > .elementor-widget-container > .e-n-accordion > .e-n-accordion-item ) > .e-con',
            ]
        );

        $obj->add_control(
            'content_border_dark_mode',
            [
                'label' => esc_html__( 'Border Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    ':where( html[scheme="dark"] {{WRAPPER}} > .elementor-widget-container > .e-n-accordion > .e-n-accordion-item ) > .e-con' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_section();


    }


    public function nested_tabs_widget_dark_mode ( $obj ) {

        $obj->start_controls_section(
            'section_rivax_dark_mode',
            [
                'label' => esc_html__( 'Dark Mode', 'syron' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $obj->start_controls_tabs( 'tabs_header_dark_mode' );

        $obj->start_controls_tab(
            'tab_header_normal_dark_mode',
            [
                'label' => esc_html__( 'Normal', 'syron' ),
            ]
        );

        $obj->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'header_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} > .elementor-widget-container > .e-n-tabs > .e-n-tabs-heading > .e-n-tab-title[aria-selected="false"]:not( :hover )',
            ]
        );

        $obj->add_control(
            'header_border_dark_mode',
            [
                'label' => esc_html__( 'Border Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}.elementor-widget-n-tabs > .elementor-widget-container > .e-n-tabs > .e-n-tabs-heading > .e-n-tab-title[aria-selected="false"]:not( :hover )' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'header_color_dark_mode',
            [
                'label' => esc_html__( 'Title Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}' => '--n-tabs-title-color: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'header_icon_color_dark_mode',
            [
                'label' => esc_html__( 'Icon Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}' => '--n-tabs-icon-color: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_tab();


        $obj->start_controls_tab(
            'tab_header_hover_dark_mode',
            [
                'label' => esc_html__( 'Hover', 'syron' ),
            ]
        );

        $obj->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'header_bg_hover_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}}.elementor-widget-n-tabs > .elementor-widget-container > .e-n-tabs[data-touch-mode="false"] > .e-n-tabs-heading > .e-n-tab-title[aria-selected="false"]:hover',
            ]
        );

        $obj->add_control(
            'header_border_hover_dark_mode',
            [
                'label' => esc_html__( 'Border Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}.elementor-widget-n-tabs > .elementor-widget-container > .e-n-tabs[data-touch-mode="false"] > .e-n-tabs-heading > .e-n-tab-title[aria-selected="false"]:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'header_color_hover_dark_mode',
            [
                'label' => esc_html__( 'Title Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} [data-touch-mode="false"] .e-n-tab-title[aria-selected="false"]:hover' => '--n-tabs-title-color-hover: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'header_icon_color_hover_dark_mode',
            [
                'label' => esc_html__( 'Icon Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} [data-touch-mode="false"] .e-n-tab-title[aria-selected="false"]:hover' => '--n-tabs-icon-color-hover: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_tab();


        $obj->start_controls_tab(
            'tab_header_active_dark_mode',
            [
                'label' => esc_html__( 'Active', 'syron' ),
            ]
        );

        $obj->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'header_bg_active_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}}.elementor-widget-n-tabs > .elementor-widget-container > .e-n-tabs > .e-n-tabs-heading > .e-n-tab-title[aria-selected="true"], html[scheme="dark"] {{WRAPPER}}.elementor-widget-n-tabs > .elementor-widget-container > .e-n-tabs[data-touch-mode="true"] > .e-n-tabs-heading > .e-n-tab-title[aria-selected="false"]:hover',
            ]
        );

        $obj->add_control(
            'header_border_active_dark_mode',
            [
                'label' => esc_html__( 'Border Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}.elementor-widget-n-tabs > .elementor-widget-container > .e-n-tabs > .e-n-tabs-heading > .e-n-tab-title[aria-selected="true"], html[scheme="dark"] {{WRAPPER}}.elementor-widget-n-tabs > .elementor-widget-container > .e-n-tabs[data-touch-mode="true"] > .e-n-tabs-heading > .e-n-tab-title[aria-selected="false"]:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'header_color_active_dark_mode',
            [
                'label' => esc_html__( 'Title Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}' => '--n-tabs-title-color-active: {{VALUE}};',
                ],
            ]
        );

        $obj->add_control(
            'header_icon_color_active_dark_mode',
            [
                'label' => esc_html__( 'Icon Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}' => '--n-tabs-icon-color-active: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_tab();
        $obj->end_controls_tabs();

        $obj->add_control(
            'content_heading_dark_mode',
            [
                'label'     => esc_html__( 'Content', 'syron' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $obj->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'content_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}}.elementor-widget-n-tabs > .elementor-widget-container > .e-n-tabs > .e-n-tabs-content > .e-con',
            ]
        );

        $obj->add_control(
            'content_border_dark_mode',
            [
                'label' => esc_html__( 'Border Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}.elementor-widget-n-tabs > .elementor-widget-container > .e-n-tabs > .e-n-tabs-content > .e-con' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_section();


    }


    public function widgets_common_settings ( $obj ) {

        $obj->start_controls_section(
            'section_rivax_common_dark_mode',
            [
                'label' => esc_html__( 'Dark Mode', 'syron' ),
                'tab' => Controls_Manager::TAB_ADVANCED,
            ]
        );

        $obj->start_controls_tabs( '_tabs_bg_dark_mode' );

        $obj->start_controls_tab(
            '_tab_background_normal_dark_mode',
            [
                'label' => esc_html__( 'Normal', 'syron' ),
            ]
        );

        $obj->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => '_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} > .elementor-widget-container',
            ]
        );

        $obj->add_control(
            '_border_dark_mode',
            [
                'label' => esc_html__( 'Border Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} > .elementor-widget-container' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_tab();

        $obj->start_controls_tab(
            '_tab_background_hover_dark_mode',
            [
                'label' => esc_html__( 'Hover', 'syron' ),
            ]
        );

        $obj->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => '_background_hover_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}}:hover .elementor-widget-container',
            ]
        );

        $obj->add_control(
            '_border_hover_dark_mode',
            [
                'label' => esc_html__( 'Border Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}}:hover > .elementor-widget-container' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $obj->end_controls_tab();
        $obj->end_controls_tabs();

        $obj->end_controls_section();


    }


}

Rivax_Elementor_Custom_Settings::get_instance();
