<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

class Rivax_Helper {

    public static $_instance;

    /**
     * Instance
     *
     * Ensures only one instance of the class is loaded or can be loaded.
     */
    public static function get_instance() {

        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;

    }

    /**
     * Load Construct
     *
     */
    public function __construct(){

        // Check if Elementor installed and activated
        if ( ! did_action( 'elementor/loaded' ) ) {
            return false;
        }


        // Custom Elementor Controller for rivax-select2
        add_action('wp_ajax_rivax_select2_search_query', [$this, 'rivax_select2_search_query']);
        add_action('wp_ajax_nopriv_rivax_select2_search_query', [$this, 'rivax_select2_search_query']);

        add_action('wp_ajax_rivax_select2_get_title', [$this, 'rivax_select2_get_title']);
        add_action('wp_ajax_nopriv_rivax_select2_get_title', [$this, 'rivax_select2_get_title']);


        // Load more posts
        add_action('wp_ajax_rivax_get_load_more_posts', [$this, 'rivax_get_load_more_posts']);
        add_action('wp_ajax_nopriv_rivax_get_load_more_posts', [$this, 'rivax_get_load_more_posts']);


	    // Mailchimp
	    add_action('wp_ajax_rivax_mailchimp_subscribe', [$this, 'rivax_mailchimp_subscribe']);
	    add_action('wp_ajax_nopriv_rivax_mailchimp_subscribe', [$this, 'rivax_mailchimp_subscribe']);

    }

    /*
     * $posts_source = post type
     * $source_type = post, taxonomy, author
     * */
    public function rivax_select2_search_query() {
        $posts_source = 'post';
        $source_type = 'post';

        if ( !empty( $_GET[ 'source_type' ] ) ) {
            $source_type = sanitize_text_field( $_GET[ 'source_type' ] );
        }

        if ( !empty( $_GET[ 'posts_source' ] ) ) {
            $posts_source = sanitize_text_field( $_GET[ 'posts_source' ] );
        }

        $search = !empty( $_GET[ 'term' ] ) ? sanitize_text_field( $_GET[ 'term' ] ) : '';
        $results = $query_result = [];

        if($source_type == 'post') {
            $args = [
                'post_type' => $posts_source,
                'posts_per_page' => 10,
                's'           => $search,
            ];

            $query_result = new WP_Query( $args );
            $query_result = wp_list_pluck($query_result->posts, 'post_title', 'ID');
        }
        elseif($source_type == 'taxonomy') {
            $taxonomies = get_object_taxonomies( $posts_source );

            if($taxonomies) {
                $args = [
                    'hide_empty' => false,
                    'taxonomy' => $taxonomies,
                    'number'     => '10',
                    'search'     => $search,
                    'fields'     => 'all',
                ];

                $terms_result = get_terms($args);
                foreach ($terms_result as $term_item) {
                    $query_result[$term_item->term_id] = $term_item->taxonomy . ': ' . $term_item->name;
                }
            }

        }
        elseif($source_type == 'author') {
            $search = $search? '*' . $search . '*' : '';
            $args = [
                'fields'  => [ 'ID', 'display_name' ],
                'orderby' => 'display_name',
                'has_published_posts' => true,
                'number'     => '10',
                'search'     => $search,
            ];
            $query_result = wp_list_pluck(get_users($args), 'display_name', 'ID');
        }


        if ( !empty( $query_result ) ) {
            foreach ( $query_result as $key => $item ) {
                $results[] = [ 'text' => $item, 'id' => $key ];
            }
        }

        wp_send_json( [ 'results' => $results ] );
        wp_die();
    }


    public function rivax_select2_get_title() {

        if ( empty( $_POST[ 'id' ] ) ) {
            wp_send_json_error( [] );
        }

        if ( empty( array_filter($_POST[ 'id' ]) ) ) {
            wp_send_json_error( [] );
        }
        $ids          = array_map('intval',$_POST[ 'id' ]);

        $source_type = 'post';

        if ( !empty( $_POST[ 'source_type' ] ) ) {
            $source_type = sanitize_text_field( $_POST[ 'source_type' ] );
        }

        $results = $query_result = [];

        if($source_type == 'post') {
            $args = [
                'post_type' => 'any',
                'numberposts' => '-1',
                'orderby'     => 'title',
                'order'     => 'ASC',
                'include'    => $ids,
            ];
            $query_result = wp_list_pluck(get_posts($args), 'post_title', 'ID');
        }
        elseif($source_type == 'taxonomy') {
            $args = [
                'hide_empty' => false,
                'include'    => $ids,
                'fields'     => 'all',
            ];

            $terms_result = get_terms($args);
            foreach ($terms_result as $term_item) {
                $query_result[$term_item->term_id] = $term_item->taxonomy . ': ' . $term_item->name;
            }
        }
        elseif($source_type == 'author') {
            $args = [
                'fields'  => [ 'ID', 'display_name' ],
                'include'    => $ids,
            ];
            $query_result = wp_list_pluck(get_users($args), 'display_name', 'ID');
        }


        $results = $query_result;

        if ( !empty( $results ) ) {
            wp_send_json_success( [ 'results' => $results ] );
        } else {
            wp_send_json_error( [] );
        }
        wp_die();

    }



    /**
     * Get load more ajax posts
     */
    public function rivax_get_load_more_posts() {

        $post_id   = esc_attr($_POST['postId']);
        $widget_id = esc_attr($_POST['widgetId']);

        $data = array(
            'data'              => '',
            'no_more'           => true,
            'msg'       => esc_html__( 'No more posts found!', 'syron' ),
        );

        $elementor = \Elementor\Plugin::$instance;
        $elements      = $elementor->documents->get( $post_id )->get_elements_data();

        if($elements) {

            $widget_data = $this->find_element_recursive( $elements, $widget_id );

            if($widget_data) {
                $widget = $elementor->elements_manager->create_element_instance( $widget_data );
                $rendered_widget = $widget->render_ajax_posts();
                $data = array(
                    'data'          => $rendered_widget['data'],
                    'no_more'       => $rendered_widget['no_more'],
                    'msg'           => $rendered_widget['msg'],
                );
            }

        }

        wp_send_json( $data );
    }


    public function find_element_recursive( $elements, $form_id ) {

        foreach ( $elements as $element ) {
            if ( $form_id === $element['id'] ) {
                return $element;
            }

            if ( ! empty( $element['elements'] ) ) {
                $element = $this->find_element_recursive( $element['elements'], $form_id );

                if ( $element ) {
                    return $element;
                }
            }
        }

        return false;
    }



	/**
	 * Mailchimp subscriber handler Ajax call
	 */
	public function rivax_mailchimp_subscribe() {

		parse_str( isset( $_POST['subscriber_info'] ) ? $_POST['subscriber_info'] : '', $subsciber );


		$return = [];

		$api_key = rivax_get_option('mailchimp-api-key');
		$double_opt_in = rivax_get_option('mailchimp-double-opt-in');


		$auth = [
			'api_key' => $api_key,
			'list_id' => esc_attr($_POST['list_id']),
		];

		$data = [
			'email_address' => ( isset( $subsciber['email'] ) ? sanitize_email($subsciber['email']) : '' ),
			'status'        => $double_opt_in? 'pending' : 'subscribed' ,
			'status_if_new' => $double_opt_in ? 'pending' : 'subscribed' ,
			'merge_fields'  => [
				'FNAME' => ( isset( $subsciber['fname'] ) ? esc_attr($subsciber['fname']) : '' ),
				'LNAME' => ( isset( $subsciber['lname'] ) ? esc_attr($subsciber['lname']) : '' ),
				'PHONE' => ( isset( $subsciber['phone'] ) ? esc_attr($subsciber['phone']) : '' ),
			],
		];


		$server = explode( '-', $auth['api_key'] );

		if ( ! isset( $server[1] ) ) {
            $return = ['status' => 0, 'msg' => esc_html__( 'Invalid API key.', 'syron' )];
            wp_send_json( $return );
            wp_die();
		}

		$url = 'https://' . $server[1] . '.api.mailchimp.com/3.0/lists/' . $auth['list_id'] . '/members/';

		$response = wp_remote_post(
			$url,
			[
				'method'      => 'POST',
				'data_format' => 'body',
				'timeout'     => 45,
				'headers'     => [
					'Authorization' => 'apikey ' . $auth['api_key'],
					'Content-Type'  => 'application/json; charset=utf-8',
				],
				'body'        => json_encode( $data ),
			]
		);

		if ( is_wp_error( $response ) ) {
			$error_message    = $response->get_error_message();
			$return['status'] = 0;
			$return['msg']    = esc_html__( 'Something went wrong: ', 'syron' ) . esc_html( $error_message );
		} else {
			$body           = (array) json_decode( $response['body'] );
			$return['body'] = $body;
			if ( $body['status'] > 399 && $body['status'] < 600 ) {
				$return['status'] = 0;
				$return['msg']    = $body['title'];
			} elseif ( $body['status'] == 'subscribed' ) {
				$return['status'] = 1;
				$return['msg']    = esc_html__( 'You have subscribed successfully.', 'syron' );
			} elseif ( $body['status'] == 'pending' ) {
				$return['status'] = 1;
				$return['msg']    = esc_html__( 'Please confirm your subscription from your email.', 'syron' );
			} else {
				$return['status'] = 0;
				$return['msg']    = esc_html__( 'Something went wrong. Try again later.', 'syron' );
			}
		}


		wp_send_json( $return );

		wp_die();
	}

}
Rivax_Helper::get_instance();