<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly
?>
<div class="rivax-categories-accordion layout-<?php echo esc_attr($settings['layout']); ?>">
<?php
$image_animation = $settings['image_animation'] && rivax_get_option('posts-animation');

foreach (  $settings['category_items'] as $category_item ) {

    if(!$category_item['category'] || !$category_item['category_image']['id'])
        continue;

    $category = get_category($category_item['category']);

    if(!$category)
        continue;
    ?>
    <div class="cat-item term-id-<?php echo intval($category->cat_ID); ?>">
        <div class="image-wrapper<?php if($image_animation) echo ' has-animation'; ?>">
            <?php
            echo wp_get_attachment_image( $category_item['category_image']['id'], $settings['thumbnail_size'] );

            if($image_animation) {
                echo '<div class="image-animation">';
                echo wp_get_attachment_image( $category_item['category_image']['id'], $settings['thumbnail_size'] );
                echo '</div>';
            }
            ?>
        </div>
        <div class="content-wrapper">
            <?php if( $settings['show_count'] ): ?>
                <div class="count-wrapper">
                    <span class="count"><?php echo intval($category->count) .  esc_html($settings['category_count_text']); ?></span>
                </div>
            <?php endif; ?>
            <div class="title-wrapper">
                <h5><?php echo esc_html($category->name); ?></h5>
            </div>
        </div>
        <div class="content-wrapper x2">
            <?php if( $settings['show_count'] ): ?>
                <div class="count-wrapper">
                    <span class="count"><?php echo intval($category->count) .  esc_html($settings['category_count_text']); ?></span>
                </div>
            <?php endif; ?>
            <div class="title-wrapper">
                <h5><?php echo esc_html($category->name); ?></h5>
            </div>
        </div>
        <a class="img-link rivax-position-cover" aria-label="Item Link" <?php if( $settings['open_link_new_tab'] ) echo 'target="_blank"'; ?> href="<?php echo esc_url(get_category_link($category->cat_ID)); ?>"></a>
    </div>
    <?php
}
?>
</div>
