<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

$image_animation = $settings['image_animation'] && rivax_get_option('posts-animation');
?>
<div class="rivax-insta-wrapper layout-<?php echo esc_attr($settings['layout']);?>">
    <div class="rivax-insta-header">
        <?php if($settings['show_profile_image'] && $settings['profile_image']['id']): ?>
            <div class="rivax-insta-profile-img">
                <?php
                $image = wp_get_attachment_image_src($settings['profile_image']['id'], 'thumbnail');
                if($image) {
                    ?>
                    <a target="_blank" href="<?php echo esc_url($settings['link']); ?>">
                    <img src="<?php echo esc_url($image[0]); ?>" width="<?php echo esc_attr($image[1]); ?>" height="<?php echo esc_attr($image[2]); ?>" alt="instagram profile">
                    </a>
                    <?php
                }
                ?>
            </div>
        <?php endif; ?>
        <div class="rivax-insta-info">
            <?php if($settings['show_username'] && $settings['username']): ?>
                <span class="username"><a target="_blank" href="<?php echo esc_url($settings['link']); ?>">@<?php echo esc_attr($settings['username']); ?></a></span>
            <?php endif; ?>
            <?php if($settings['show_tagline'] && $settings['tagline']): ?>
                <span class="tagline"><?php echo esc_html($settings['tagline']); ?></span>
            <?php endif; ?>
        </div>
        <?php if($settings['layout'] != 4 && $settings['show_button'] && $settings['button_text'] && $settings['link']): ?>
        <div class="rivax-insta-btn-wrap">
            <a target="_blank" class="rivax-insta-btn button" href="<?php echo esc_url($settings['link']); ?>">
                <?php if($settings['button_icon']['value']): ?>
                    <span class="icon">
                        <?php \Elementor\Icons_Manager::render_icon( $settings['button_icon'] ); ?>
                    </span>
                <?php endif; ?>
                <span class="btn-text"><?php echo esc_html($settings['button_text']); ?></span>
            </a>
        </div>
        <?php endif; ?>
    </div>
    <?php
    $images_cls = 'rivax-insta-images layout-' . $settings['images_layout'];
    if($settings['image_hover_shape']) { $images_cls .= ' hover-shape'; }
    if($settings['marquee_pauseonhover']) { $images_cls .= ' pause-hover'; }
    if($settings['marquee_swing']) { $images_cls .= ' swing'; }
    ?>
    <div class="<?php echo esc_attr($images_cls);?>">
        <?php
        $is_marquee = in_array($settings['images_layout'], ['marquee-left', 'marquee-right']);
        $j = ($is_marquee)? 2 : 1;
        for($i = 0; $i < $j; $i++) {
            if($is_marquee) { echo '<div class="marquee-wrap">'; }
            foreach ( $settings['images'] as $image_item ) {
                $image = wp_get_attachment_image_src($image_item['id'], $settings['thumbnail_size']);
                if($image) {
                    ?>
                    <div class="insta-item<?php if($image_animation) echo ' has-animation'; ?>">
                        <div class="item-img">
                            <img src="<?php echo esc_url($image[0]); ?>" width="<?php echo esc_attr($image[1]); ?>" height="<?php echo esc_attr($image[2]); ?>" alt="instagram image">
                            <?php if($image_animation): ?>
                            <div class="image-animation">
                                <img src="<?php echo esc_url($image[0]); ?>" width="<?php echo esc_attr($image[1]); ?>" height="<?php echo esc_attr($image[2]); ?>" alt="instagram image">
                            </div>
                            <?php endif; ?>
                            <?php if($settings['image_hover_shape']) { echo '<i class="ri-instagram"></i>';} ?>
	                        <?php if($settings['link']) { echo '<a target="_blank" class="rivax-position-cover" href="' . esc_url($settings['link']) . '"></a>';} ?>
                        </div>
                    </div>
                    <?php
                }
            }
            if($is_marquee) { echo '</div>'; }
        }
        ?>
        <?php if($settings['layout'] == 4 && $settings['show_button'] && $settings['button_text'] && $settings['link']): ?>
            <div class="rivax-insta-btn-wrap">
                <a target="_blank" class="rivax-insta-btn button" href="<?php echo esc_url($settings['link']); ?>">
                    <?php if($settings['button_icon']['value']): ?>
                        <span class="icon">
                        <?php \Elementor\Icons_Manager::render_icon( $settings['button_icon'] ); ?>
                        </span>
                    <?php endif; ?>
                    <span class="btn-text"><?php echo esc_html($settings['button_text']); ?></span>
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>
