<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

$cls = 'rivax-marquee-headings move-' . $settings['direction'];
$cls .= $settings['pauseonhover']? ' pause-hover' : '';
$cls .= $settings['side_fading']? ' side-fading' : '';
?>
<div class="<?php echo esc_attr($cls); ?>">
    <?php
    for($i = 0; $i < 2; $i++) {
        echo '<div class="marquee-wrap">';
        foreach ( $settings['items'] as $item ) {
            if($item['title']) {
                ?>
                <div class="heading-item elementor-repeater-item-<?php echo esc_attr($item['_id']); ?>">
                    <<?php echo esc_attr($settings['title_tag']); ?> class="heading-wrap">
                        <?php if($item['icon']['value']): ?>
                            <span class="icon">
                            <?php \Elementor\Icons_Manager::render_icon( $item['icon'] ); ?>
                            </span>
                        <?php endif; ?>
                        <span class="heading<?php if($settings['title_gradient']) {echo ' gradient-heading';} ?>"><?php echo esc_html($item['title']); ?></span>
                    </<?php echo esc_attr($settings['title_tag']); ?>>
                </div>
                <?php
            }
        }
        echo '</div>';
    }
    ?>
</div>