<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

?>
<div class="rivax-news-ticker-wrapper">
    <?php if( $settings['show_title'] ): ?>
        <div class="rivax-news-ticker-title-wrapper">

            <?php if( $settings['title_icon_type'] != 'none' ): ?>
                <span class="rivax-news-ticker-title-icon-wrapper">

                    <?php if( $settings['title_icon_type'] == 'pulse' ): ?>
                        <span class="rivax-news-ticker-title-pulse"></span>
                    <?php elseif( $settings['title_icon_type'] == 'icon' ): ?>
                        <span class="rivax-news-ticker-title-icon">
                            <?php \Elementor\Icons_Manager::render_icon( $settings['title_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        </span>
                    <?php endif; ?>
                </span>
            <?php endif; ?>

            <?php if( $settings['title'] ): ?>
                <span class="rivax-news-ticker-title-text">
                    <?php echo esc_html($settings['title']); ?>
                </span>
            <?php endif; ?>

        </div>
    <?php endif; ?>

    <?php
    $id = 'rivax-news-ticker-' . $this->get_id();
    $this->add_render_attribute( 'content-wrapper', 'id', $id );
    $this->add_render_attribute( 'content-wrapper', 'class', 'rivax-news-ticker-content-wrapper animation-' . esc_attr($settings['animation_type']) );

    if( $settings['animation_type'] == 'marquee' ) {

        if($settings["pauseonhover"]) {
            $this->add_render_attribute('content-wrapper', 'class', 'pause-hover' );
        }
    }
    else {

        $data_settings = [
            "autoplay"              => ( "yes" == $settings["carousel_autoplay"] ) ? [ "delay" => $settings["carousel_autoplay_speed"] ] : false,
            "loop"                  => true,
            "spaceBetween"          => 20,
            "speed"                 => ( $settings["animation_type"] == "type" )? 100 : $settings["carousel_speed"],
            "pauseOnMouseEnter"     => ( $settings["pauseonhover"] == "yes" ),
            "effect"                => ( $settings["animation_type"] == "fade" || $settings["animation_type"] == "type")? 'fade' : 'slide',
            "direction"             => ( $settings["animation_type"] == "vertical" )? 'vertical' : 'horizontal',
            "navigation"            => [
                "nextEl" => "#" . $id . " .carousel-nav-next",
                "prevEl" => "#" . $id . " .carousel-nav-prev",
            ],
            "a11y"            => [
                "enabled"             => "false",
            ],
            "fadeEffect"            => [
                "crossFade" => true,
            ],

        ];


        $this->add_render_attribute('content-wrapper', 'data-settings', wp_json_encode(array_filter($data_settings)) );

    }

    ?>
    <div <?php $this->print_render_attribute_string( 'content-wrapper' ); ?>>
        <div class="rivax-news-ticker-content<?php if( $settings['animation_type'] != 'marquee') echo ' swiper'; if( $settings['side_fading'] != 'none' ) echo ' side-fading-' . esc_attr($settings['side_fading']); ?>">
            <div class="rivax-news-ticker-items<?php if( $settings['animation_type'] != 'marquee') echo ' swiper-wrapper'; ?>">
                <?php
                if($settings['show_custom_content']) {

                    foreach (  $settings['custom_content_items'] as $item ) {
                        ?>
                        <div class="rivax-news-ticker-item <?php if( $settings['animation_type'] != 'marquee') echo 'swiper-slide'; ?>">
                            <?php if( $settings['show_item_icon'] ): ?>
                                <div class="item-icon">
                                    <?php \Elementor\Icons_Manager::render_icon( $settings['item_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                </div>
                            <?php endif; ?>
                            <div class="item-title"><a <?php if( $settings['open_link_new_tab'] ) echo 'target="_blank"'; ?> href="<?php echo esc_url($item['custom_content_url']); ?>"><?php echo esc_html($item['custom_content_title']); ?></a></div>
                        </div>
                        <?php
                    }

                }
                else {

                    $query = $this->get_query_result();
                    if ( $query->have_posts() ) :
                        while ( $query->have_posts() ) :
                            $query->the_post();

                            ?>
                            <div class="rivax-news-ticker-item <?php if( $settings['animation_type'] != 'marquee') echo 'swiper-slide'; ?>">
                                <?php if( $settings['show_item_icon'] ): ?>
                                    <div class="item-icon">
                                        <?php \Elementor\Icons_Manager::render_icon( $settings['item_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </div>
                                <?php endif; ?>

                                <?php if( $settings['show_item_thumbnail'] && has_post_thumbnail() ): ?>
                                    <div class="item-thumbnail"><a <?php if( $settings['open_link_new_tab'] ) echo 'target="_blank"'; ?> href="<?php echo esc_url(get_permalink()); ?>"><?php the_post_thumbnail('thumbnail', array( 'title' => get_the_title() )); ?></a></div>
                                <?php endif; ?>

                                <?php if( $settings['show_item_date'] ): ?>
                                    <div class="item-date"><?php echo current_time($settings['date_format'], true); ?></div>
                                <?php endif; ?>

                                <div class="item-title"><a <?php if( $settings['open_link_new_tab'] ) echo 'target="_blank"'; ?> href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html(get_the_title()); ?></a></div>
                            </div>
                            <?php

                        endwhile;
                    endif;
                    wp_reset_postdata();

                }
                ?>
            </div>
        </div>
        <?php if( $settings['animation_type'] != 'marquee' && $settings['carousel_arrows'] ): ?>
            <div class="rivax-news-ticker-arrows">
                <a href="" class="carousel-nav-prev">
                    <i class="<?php echo esc_attr($settings['carousel_arrows_icon']); ?>"></i>
                </a>
                <a href="" class="carousel-nav-next">
                    <i class="<?php echo esc_attr($settings['carousel_arrows_icon']); ?>"></i>
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>
