<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

$query = $this->get_query_result();
if ( ! $query->found_posts ) {

    rivax_query_not_found_msg ();

    return;
}
?>
<div class="pansy-slider <?php echo esc_attr($settings["thumbs_direction"]); ?>">
    <div class="rivax-posts-wrapper">
        <?php $this->render_slider_header(); ?>
        <?php
        if ( $query->have_posts() ) :
            while ( $query->have_posts() ) :
                $query->the_post();

                $this->render_post_body($query->current_post);

            endwhile;
        endif;
        wp_reset_postdata();
        ?>
        <?php $this->render_carousel_footer('slider'); ?>

        <?php
        $id = 'rivax-thumbs-' . $this->get_id();

        $this->add_render_attribute( 'thumbs', 'id', $id );
        $this->add_render_attribute( 'thumbs', 'class', 'thumbs-slider-wrapper' );

        $thumbs_settings = [
            "loop"                  => ( $settings["slider_loop"] == "yes" ),
            "speed"                 => $settings["slider_speed"]["size"],
            "grabCursor"            => ( $settings["slider_grab_cursor"] == "yes" ),
            "slideToClickedSlide"   => true,
            "direction"             => "horizontal",
            "touchRatio"            => 0.2,
            "spaceBetween"          => intval($settings["thumbs_spacing"]["size"]),
            "loopedSlides"          => 6,
            "slidesPerView"         => 3,
            "breakpoints"           => [
                768 => [
                    "slidesPerView"   => intval($settings["thumbs_count"]),
                    "direction"       => $settings["thumbs_direction"],
                ],
            ],
        ];

        $this->add_render_attribute('thumbs', 'data-settings', wp_json_encode(array_filter($thumbs_settings)) );

        $bar_time = ($settings["slider_autoplay"] && $settings["slider_autoplay_speed"]) ? $settings["slider_autoplay_speed"] : 2000;
        $this->add_render_attribute('thumbs', 'style', "--bar-time: {$bar_time}ms;" );
        ?>
        <div <?php $this->print_render_attribute_string( 'thumbs' ); ?>>
            <div class="thumbs-slider-inner">
                <div class="swiper thumbs-slider <?php echo esc_attr($settings["thumb_style"]); ?>">
                    <div class="swiper-wrapper">
                        <?php
                        if ( $query->have_posts() ) :
                            while ( $query->have_posts() ) :
                                $query->the_post();
                                ?>
                                <div class="thumb-wrapper swiper-slide">
                                    <div class="image-wrapper">
                                        <?php if(in_array($settings["thumb_style"], ['thumb-style-3', 'thumb-style-4'])): ?>
                                            <svg><circle cx="50%" cy="50%" r="50%" pathLength="100"/></svg>
                                        <?php endif; ?>
                                        <?php the_post_thumbnail('thumbnail', array( 'title' => get_the_title() )); ?>
                                    </div>
                                </div>
                            <?php
                            endwhile;
                        endif;
                        wp_reset_postdata();
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
