<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

$img_parallax = ($settings['carousel_effect'] == 'slide')? '70%' : '';
$content_parallax = ($settings['carousel_effect'] == 'slide')? '90%' : '5%';
?>
<div class="post-item swiper-slide">
    <article class="post-wrapper">
        <div class="image-wrapper" data-swiper-parallax="<?php echo esc_attr($img_parallax); ?>" data-swiper-parallax-scale="<?php echo esc_attr($settings['image_zoom_size']['size']); ?>">
            <?php
            $thumb_args = [ 'title' => get_the_title() ];
            if(0 <= $current_post_num && $current_post_num < intval($settings['skip_lazy_loading']) ) {
                $thumb_args ['loading'] = 'eager'; // Defaults is 'lazy'
            }
            the_post_thumbnail($settings['thumbnail_size'], $thumb_args);
            ?>
        </div>
        <div class="content-wrapper-outer" data-swiper-parallax="<?php echo esc_attr($content_parallax); ?>">
            <div class="content-wrapper">
                <div class="content-wrapper-inner">
                    <?php $this->render_terms(); ?>
                    <?php $this->render_title(); ?>
                    <div class="meta-wrapper">
                        <?php $this->render_author(); ?>
                        <?php $this->render_date(); ?>
                        <?php $this->render_comments(); ?>
                        <?php $this->render_views_count(); ?>
                        <?php $this->render_reading_time(); ?>
                    </div>
                    <?php $this->render_excerpt(); ?>
                </div>
            </div>
        </div>
    </article>
</div>