<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

$post_item_cls = 'post-item';
if( $settings['layout'] == 'carousel' ) {
    $post_item_cls .= ' swiper-slide';
}

$article_cls = '';
$article_category = get_the_category();
if(!empty($article_category)) {
    $article_cls .= ' term-id-' . $article_category[0]->term_id;
}

$image_animation = $settings['image_animation'] && rivax_get_option('posts-animation');
if(!empty($image_animation)) {
    $article_cls .= ' has-animation';
}
?>
<div class="<?php echo esc_attr($post_item_cls); ?>">
    <article class="post-wrapper<?php echo esc_attr($article_cls); ?>">
        <?php
        if($settings['link_wrapper']) {
            echo '<a class="item-link rivax-position-cover" aria-label="Item Link" href="' . get_permalink() . '"></a>';
        }
        ?>
        <div class="image-wrapper">
            <?php
            $thumb_args = [ 'title' => get_the_title() ];
            if(0 <= $current_post_num && $current_post_num < intval($settings['skip_lazy_loading']) ) {
                $thumb_args ['loading'] = 'eager'; // Defaults is 'lazy'
            }
            the_post_thumbnail($settings['thumbnail_size'], $thumb_args);

            if($image_animation) {
                echo '<div class="image-animation">';
                the_post_thumbnail($settings['thumbnail_size'], $thumb_args);
                echo '</div>';
            }
            ?>
        </div>
	    <?php if($settings['author_position'] == 'top'): ?>
		    <div class="top-content-wrapper rivax-position-top">
			    <?php $this->render_author(); ?>
            </div>
	    <?php endif; ?>
        <div class="content-wrapper rivax-position-<?php echo esc_attr($settings['content_position']) . ' ' . esc_attr($settings['content_style']); ?>">
            <div class="content-wrapper-inner">
	            <?php $this->render_terms(); ?>
                <?php $this->render_title(); ?>
	            <?php $this->render_excerpt(); ?>
                <div class="meta-wrapper">
	                <?php if($settings['author_position'] == 'inline') { $this->render_author(); }; ?>
                    <?php $this->render_date(); ?>
                    <?php $this->render_comments(); ?>
                    <?php $this->render_views_count(); ?>
                    <?php $this->render_reading_time(); ?>
                </div>
                <?php if($settings['content_style'] == 'style-3'): ?>
                    <div class="read-more-wrap">
                        <a href="<?php the_permalink(); ?>" class="read-more"><?php echo esc_html($settings['read_more_text']) ?></a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <?php if($settings['meta_date_position'] == 'inside-image'): ?>
            <div class="date-in-out-image date-inside-image rivax-position-<?php echo esc_attr($settings['date_inside_image_position']); ?>">
                <span class="day"><?php echo get_the_date('d') ?></span>
                <span class="month"><?php echo get_the_date('M') ?></span>
            </div>
        <?php endif; ?>
        <?php $this->render_post_format_icon(); ?>
    </article>
</div>