<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

$post_item_cls = 'post-item';
if( $settings['layout'] == 'carousel' ) {
    $post_item_cls .= ' swiper-slide';
}

$article_cls = $settings['article_layout'];
$article_category = get_the_category();
if(!empty($article_category)) {
	$article_cls .= ' term-id-' . $article_category[0]->term_id;
}

$footer_has_content = $settings['terms_taxonomy'] || $settings['comments_position'] == 'footer' || $settings['views_position'] == 'footer' || $settings['reading_position'] == 'footer';
$image_animation = $settings['image_animation'] && rivax_get_option('posts-animation');
?>
<div class="<?php echo esc_attr($post_item_cls); ?>">
    <article class="post-wrapper <?php echo esc_attr($article_cls); ?>">
        <?php if(has_post_thumbnail()): ?>
        <div class="image-outer-wrapper">
            <div class="image-wrapper<?php if($image_animation) echo ' has-animation'; ?>">
                <?php
                $thumb_args = [ 'title' => get_the_title() ];
                if(0 <= $current_post_num && $current_post_num < intval($settings['skip_lazy_loading']) ) {
                    $thumb_args ['loading'] = 'eager'; // Defaults is 'lazy'
                }
                the_post_thumbnail($settings['thumbnail_size'], $thumb_args);

                if($image_animation) {
                    echo '<div class="image-animation">';
                    the_post_thumbnail($settings['thumbnail_size'], $thumb_args);
                    echo '</div>';
                }
                ?>
                <a class="image-link rivax-position-cover" aria-label="Item Link" href="<?php the_permalink(); ?>"></a>
                <?php if($settings['meta_date_position'] == 'inside-image'): ?>
                    <div class="date-in-out-image date-inside-image rivax-position-<?php echo esc_attr($settings['date_inside_image_position']); ?>">
                        <span class="day"><?php echo get_the_date('d') ?></span>
                        <span class="month"><?php echo get_the_date('M') ?></span>
                    </div>
                <?php endif; ?>
		        <?php $this->render_top_content(); ?>
		        <?php $this->render_post_format_icon(); ?>

                <?php
                if($settings['show_image_svg_cover']) {
                    rivax_svg_cover ($settings['image_svg_cover']);
                }
                ?>

            </div>
            
	        <?php if($settings['counter_position'] == 'inside-image'): ?>
                <div class="post-counter-wrap counter-inside-image rivax-position-<?php echo esc_attr($settings['counter_inside_position']); ?>">
                    <span class="post-counter"></span>
                </div>
	        <?php endif; ?>

        </div>
        <?php endif; ?>
        <div class="content-wrapper">
            <div class="content-inner">
	            <?php if($settings['counter_position'] == 'outside-image'): ?>
                    <div class="post-counter-wrap counter-outside-image rivax-position-<?php echo esc_attr($settings['counter_inside_position']); ?>">
                        <span class="post-counter"></span>
                    </div>
	            <?php endif; ?>
	            <?php $this->render_title(); ?>
                <div class="meta-wrapper">
		            <?php $this->render_author(); ?>
		            <?php $this->render_date(); ?>
		            <?php if($settings['comments_position'] == 'inline') {$this->render_comments();} ?>
		            <?php if($settings['views_position'] == 'inline') {$this->render_views_count();} ?>
		            <?php if($settings['reading_position'] == 'inline') {$this->render_reading_time();} ?>
                </div>
	            <?php $this->render_excerpt(); ?>
            </div>
            <?php if ($footer_has_content): ?>
                <div class="footer-wrap">
	                <?php $this->render_terms(); ?>
                    <div class="footer-meta">
	                    <?php if($settings['comments_position'] == 'footer') {$this->render_comments();} ?>
	                    <?php if($settings['views_position'] == 'footer') {$this->render_views_count();} ?>
	                    <?php if($settings['reading_position'] == 'footer') {$this->render_reading_time();} ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </article>
</div>