<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly
?>
<?php
if($settings['image']['id']) {
    $image_animation = $settings['image_animation'] && rivax_get_option('posts-animation');
?>
    <div class="rivax-profile-card layout-<?php echo esc_attr($settings['layout']); ?>">
        <div class="image-wrapper<?php if($image_animation) echo ' has-animation'; ?>">
            <?php
            echo wp_get_attachment_image( $settings['image']['id'], $settings['thumbnail_size'] );

            if($image_animation) {
                echo '<div class="image-animation">';
                echo wp_get_attachment_image( $settings['image']['id'], $settings['thumbnail_size'] );
                echo '</div>';
            }
            ?>
        </div>
        <?php
        if($settings['title'] || $settings['subtitle']) {
            echo '<div class="content-wrapper">';
            if($settings['title']) echo '<span class="title-wrap">' . esc_html($settings['title']) . '</span>';
            if($settings['subtitle']) echo '<span class="subtitle-wrap">' . esc_html($settings['subtitle']) . '</span>';
            echo '</div>';
        }

        if($settings['layout'] == '5') {
            echo '<div class="circles-wrapper"><div class="face face1"><div class="circle"></div></div><div class="face face2"><div class="circle"></div></div></div>';
        }

        if($settings['link']['url']) {
            echo '<a class="link rivax-position-cover" aria-label="Item Link" href="' . esc_url($settings['link']['url']) . '" ' . (($settings['link']['is_external'])? 'target="_blank"' : '') . '></a>';
        }
        ?>
    </div>

<?php
}
?>
