<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

$settings = $args;

if( !empty($settings['popular_search']) ) {
?>
    <div class="popular-search-wrap">
        <div class="popular-search">
            <?php if($settings['popular_search_title']): ?>
                <div class="popular-search-title"><?php echo esc_html($settings['popular_search_title']); ?></div>
            <?php endif; ?>
            <div class="popular-search-keywords">
                <?php
                foreach ( $settings['popular_keywords'] as $popular_item ) {

                    if(!$popular_item['popular_keyword']) {
                        continue;
                    }
                    ?>
                    <a href="<?php echo esc_url(home_url('/?s=') .  esc_attr($popular_item['popular_keyword'])); ?>" class="popular-search-keyword elementor-repeater-item-<?php echo esc_attr($popular_item['_id']); ?>" title="<?php echo esc_attr($popular_item['popular_keyword']); ?>">
                        <?php echo esc_html($popular_item['popular_keyword']); ?>
                    </a>
                    <?php
                }
                ?>
            </div>
        </div>
    </div>
<?php
}
