<?php $settings = $args; ?>
<div class="popup-search">
    <div class="popup-search-container">
        <div class="popup-search-close">
            <span class="cross-line top-left"></span>
            <span class="cross-line top-right"></span>
            <span class="cross-line bottom-left"></span>
            <span class="cross-line bottom-right"></span>
            <span class="close-text"><?php esc_html_e('Close', 'syron'); ?></span>
        </div>
        <div class="popup-search-content">
            <div class="popup-search-title-wrapper">
                <h3><?php echo (!empty($settings['popup_title']))? esc_html($settings['popup_title']) : esc_html__('Type and hit Enter to search', 'syron'); ?></h3>
            </div>
            <div class="popup-search-form">
                <form action="<?php echo esc_url(home_url('/')); ?>" method="get" class="rivax-search-form">
                    <input type="text" name="s" value="" class="search-field" placeholder="<?php echo (!empty($settings['placeholder_text']))? esc_attr($settings['placeholder_text']) : esc_attr__('Search ...', 'syron'); ?>" aria-label="Search" required>
                    <button type="submit" class="submit" aria-label="Submit">
                        <?php if(empty($settings) || $settings['submit_icon'] == 'yes'): ?><i class="ri-search"></i><?php endif; ?>
                        <?php if(!empty($settings['submit_title'])): ?><span class="title"><?php echo esc_html($settings['submit_title']); ?></span><?php endif; ?>
                    </button>
                </form>
            </div>
	        <?php get_template_part("elementor/templates/search/popular-search", NULL, $settings); ?>
        </div>
    </div>
</div>
