<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

if(!isset($settings)) { $settings = []; }
$search_type = ( isset($settings['search_type']) && $settings['search_type'] == 'inline' )? 'inline' : 'popup';
?>
<?php if($search_type == 'popup'): ?>
<?php $style = ( !empty($settings['popup_style']) )? $settings['popup_style'] : 'style-1'; ?>
<div class="popup-search-wrapper <?php echo esc_attr($style); ?>">
    <div class="popup-search-opener-wrapper">
        <span class="popup-search-opener"><i class="ri-search"></i></span>
    </div>
	<?php get_template_part("elementor/templates/search/popup-search-content", NULL, $settings); ?>
</div>
<?php else: ?>
<div class="inline-search-form">
    <form action="<?php echo esc_url(home_url('/')); ?>" method="get" class="rivax-search-form">
        <input type="text" name="s" value="" class="search-field" placeholder="<?php echo (!empty($settings['placeholder_text']))? esc_attr($settings['placeholder_text']) : esc_attr__('Search ...', 'syron'); ?>" aria-label="Search" required>
        <button type="submit" class="submit" aria-label="Submit">
			<?php if($settings['submit_icon'] == 'yes'): ?><i class="ri-search"></i><?php endif; ?>
			<?php if($settings['submit_title']): ?><span class="title"><?php echo esc_html($settings['submit_title']); ?></span><?php endif; ?>
		</button>
    </form>
	<?php get_template_part("elementor/templates/search/popular-search", NULL, $settings); ?>
</div>
<?php endif; ?>