<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly
?>
<div class="rivax-social-icons">
<?php
foreach (  $settings['social_media_items'] as $social_media_item ) {

    if(!$social_media_item['social_icon']['value']) {
        continue;
    }

    $social_item_cls = 'social-item';
    $social_item_cls .= ' elementor-repeater-item-' . $social_media_item['_id'];

    if(is_string($social_media_item['social_icon']['value'])) {
        $icon_name = 'x-' . $social_media_item['social_icon']['value'];
        $icon_name = str_replace(' ', '-', $icon_name);
        $icon_name = strtolower($icon_name);
        $social_item_cls .= ' ' . $icon_name;
    }
    ?>
    <div class="<?php echo esc_attr($social_item_cls); ?>">
        <div class="social-icon">
            <span class="icon"><?php \Elementor\Icons_Manager::render_icon( $social_media_item['social_icon'] ); ?></span>
        </div>
        <?php if($social_media_item['social_title'] || $social_media_item['social_subtitle']): ?>
        <div class="social-content">
		    <?php if($social_media_item['social_title']): ?>
            <div class="social-title"><span class="title"><?php echo esc_html($social_media_item['social_title']); ?></span></div>
		    <?php endif; ?>
			<?php if($social_media_item['social_subtitle']): ?>
            <div class="social-subtitle"><span class="subtitle"><?php echo esc_html($social_media_item['social_subtitle']); ?></span></div>
			<?php endif; ?>
        </div>
        <?php endif; ?>
        <a class="rivax-position-cover" href="<?php echo esc_url($social_media_item['social_link']) ?>" title="<?php echo esc_html($social_media_item['social_title']); ?>" target="_blank" aria-label="Social Media"></a>
    </div>
    <?php
}
?>
</div>