<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

$args = [
    'taxonomy'   => $settings["taxonomy"],
    'orderby'    => $settings["orderby"],
    'order'      => $settings["order"],
    'include'    => esc_attr($settings["include"]),
    'exclude'    => esc_attr($settings["exclude"]),
    'parent'     => $settings["parent"],
    'number'     => $settings["item_limit"]["size"] ?:10,
];
$categories = get_categories( $args );


if (!empty($categories)) :

    ?>
    <div class="rivax-tag-cloud">
        <?php
        foreach ( $categories as $index => $cat ) :

            $this->add_render_attribute('category-item', 'class', 'rivax-tag-cloud-item term-id-' . $cat->term_id, true);
            $this->add_render_attribute( 'category-item', 'href', get_category_link( $cat->term_id ), true );
            ?>
            <a <?php $this->print_render_attribute_string('category-item'); ?> ><?php echo esc_html($cat->name); ?></a>
            <?php
        endforeach;
        ?>
    </div>
<?php
else :

    echo '<p>'.esc_html__('Taxonomy Not Found!', 'syron').'</p>';

endif;