<?php
namespace RivaxStudio\Traits;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


trait Rivax_Global_Widget_Controls {

    protected function register_pagination_controls() {

        $this->start_controls_section( 'section_pagination', [
            'label' => esc_html__( 'Pagination', 'syron' ) ,
            'tab'   => Controls_Manager::TAB_CONTENT,
            'condition' => [
                'layout!' => 'carousel',
            ],
        ] );

        $this->add_control(
            'pagination_type',
            [
                'label'     => esc_html__( 'Pagination', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'none',
                'options'   => [
                    'none'                  => esc_html__( 'None', 'syron' ),
                    'numbers'               => esc_html__( 'Numbers', 'syron' ),
                    'prev_next'             => esc_html__( 'Previous/Next', 'syron' ),
                    'numbers_and_prev_next' => esc_html__( 'Numbers + Previous/Next', 'syron' ),
                    'load_more'             => esc_html__( 'Load More Button', 'syron' ),
                    'infinite_scroll'       => esc_html__( 'Infinite scroll', 'syron' ),
                ],
            ]
        );

        $this->add_control(
            'pagination_page_limit',
            [
                'label'     => esc_html__( 'Page Limit', 'syron' ),
                'type'      => Controls_Manager::NUMBER,
                'condition' => [
                    'pagination_type!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'pagination_numbers_shorten',
            [
                'label'     => esc_html__( 'Shorten', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'default'   => '',
                'condition' => [
                    'pagination_type' => ['numbers', 'numbers_and_prev_next'],
                ],
            ]
        );

        $this->add_control(
            'pagination_load_more_label',
            [
                'label'     => esc_html__( 'Button Label', 'syron' ),
                'default'   => esc_html__( 'Load More', 'syron' ),
                'condition' => [
                    'pagination_type' => ['load_more', 'infinite_scroll'],
                ],
            ]
        );

        $this->add_control(
            'pagination_prev_label',
            [
                'label'     => esc_html__( 'Previous Label', 'syron' ),
                'default'   => esc_html__( '&laquo; Previous', 'syron' ),
                'condition' => [
                    'pagination_type' => ['numbers_and_prev_next', 'prev_next'],
                ],
            ]
        );

        $this->add_control(
            'pagination_next_label',
            [
                'label'     => esc_html__( 'Next Label', 'syron' ),
                'default'   => esc_html__( 'Next &raquo;', 'syron' ),
                'condition' => [
                    'pagination_type' => ['numbers_and_prev_next', 'prev_next'],
                ],
            ]
        );

        $this->add_control(
            'pagination_align',
            [
                'label'     => esc_html__( 'Alignment', 'syron' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => esc_html__( 'Left', 'syron' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'syron' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => esc_html__( 'Right', 'syron' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'default'   => 'center',
                'selectors' => [
                    '{{WRAPPER}} .rivax-posts-pagination-wrap' => 'text-align: {{VALUE}};',
					'{{WRAPPER}} .rivax-posts-pagination' => 'justify-content: {{VALUE}};',
                ],
                'condition' => [
                    'pagination_type!' => 'none',
                ],
            ]
        );

        $this->end_controls_section();
    }


    protected function register_style_pagination_controls() {
        $this->start_controls_section(
            'section_pagination_style',
            [
                'label'     => esc_html__( 'Pagination', 'syron' ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'pagination_type!' => 'none',
                    'layout!' => 'carousel',
                ],
            ]
        );

        $this->add_responsive_control(
            'pagination_margin_top',
            [
                'label'     => esc_html__( 'Gap between Posts & Pagination', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'default'   => [
                    'size' => '20',
                ],
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-posts-pagination-wrap' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'load_more_button_size',
            [
                'label'     => esc_html__( 'Size', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'sm',
                'options'   => [
                    'xs' => esc_html__( 'Extra Small', 'syron' ),
                    'sm' => esc_html__( 'Small', 'syron' ),
                    'md' => esc_html__( 'Medium', 'syron' ),
                    'lg' => esc_html__( 'Large', 'syron' ),
                    'xl' => esc_html__( 'Extra Large', 'syron' ),
                ],
                'condition' => [
                    'pagination_type' => ['load_more', 'infinite_scroll'],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'pagination_typography',
                'selector'  => '{{WRAPPER}} .rivax-posts-pagination .page-numbers, {{WRAPPER}} .rivax-posts-pagination a',
            ]
        );

        $this->start_controls_tabs( 'tabs_pagination' );

        $this->start_controls_tab(
            'tab_pagination_normal',
            [
                'label'     => esc_html__( 'Normal', 'syron' ),
            ]
        );

        $this->add_control(
            'pagination_link_bg_color_normal',
            [
                'label'     => esc_html__( 'Background Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .rivax-posts-pagination .page-numbers, {{WRAPPER}} .rivax-posts-pagination a' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'pagination_link_bg_color_normal_dark_mode',
            [
                'label'     => esc_html__( 'Background Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-posts-pagination .page-numbers, html[scheme="dark"] {{WRAPPER}} .rivax-posts-pagination a' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'pagination_color',
            [
                'label'     => esc_html__( 'Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-posts-pagination .page-numbers, {{WRAPPER}} .rivax-posts-pagination a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'pagination_color_dark_mode',
            [
                'label'     => esc_html__( 'Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-posts-pagination .page-numbers, html[scheme="dark"] {{WRAPPER}} .rivax-posts-pagination a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'pagination_link_border_normal',
                'label'       => esc_html__( 'Border', 'syron' ),
                'selector'    => '{{WRAPPER}} .rivax-posts-pagination .page-numbers, {{WRAPPER}} .rivax-posts-pagination a',

            ]
        );

        $this->add_control('pagination_link_border_normal_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'pagination_link_border_normal_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-posts-pagination .page-numbers, html[scheme="dark"] {{WRAPPER}} .rivax-posts-pagination a' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_responsive_control(
            'pagination_link_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'syron' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .rivax-posts-pagination .page-numbers, {{WRAPPER}} .rivax-posts-pagination a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'pagination_link_padding',
            [
                'label'      => esc_html__( 'Padding', 'syron' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .rivax-posts-pagination .page-numbers, {{WRAPPER}} .rivax-posts-pagination a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'      => 'pagination_link_box_shadow',
                'selector'  => '{{WRAPPER}} .rivax-posts-pagination .page-numbers, {{WRAPPER}} .rivax-posts-pagination a',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_pagination_hover',
            [
                'label'     => esc_html__( 'Hover', 'syron' ),
            ]
        );

        $this->add_control(
            'pagination_link_bg_color_hover',
            [
                'label'     => esc_html__( 'Background Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .rivax-posts-pagination a:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'pagination_link_bg_color_hover_dark_mode',
            [
                'label'     => esc_html__( 'Background Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-posts-pagination a:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'pagination_color_hover',
            [
                'label'     => esc_html__( 'Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-posts-pagination a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'pagination_color_hover_dark_mode',
            [
                'label'     => esc_html__( 'Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-posts-pagination a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'pagination_border_color_hover',
            [
                'label'     => esc_html__( 'Border Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-posts-pagination a:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'pagination_border_color_hover_dark_mode',
            [
                'label'     => esc_html__( 'Border Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-posts-pagination a:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'      => 'pagination_link_box_shadow_hover',
                'selector'  => '{{WRAPPER}} .rivax-posts-pagination a:hover',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_pagination_active',
            [
                'label'     => esc_html__( 'Active', 'syron' ),
                'condition' => [
                    'pagination_type!' => ['load_more', 'infinite_scroll'],
                ],
            ]
        );

        $this->add_control(
            'pagination_link_bg_color_active',
            [
                'label'     => esc_html__( 'Background Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .rivax-posts-pagination .page-numbers.current' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'pagination_type!' => ['load_more', 'infinite_scroll'],
                ],
            ]
        );

        $this->add_control(
            'pagination_link_bg_color_active_dark_mode',
            [
                'label'     => esc_html__( 'Background Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-posts-pagination .page-numbers.current' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'pagination_type!' => ['load_more', 'infinite_scroll'],
                ],
            ]
        );

        $this->add_control(
            'pagination_color_active',
            [
                'label'     => esc_html__( 'Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-posts-pagination .page-numbers.current' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'pagination_type!' => ['load_more', 'infinite_scroll'],
                ],
            ]
        );

        $this->add_control(
            'pagination_color_active_dark_mode',
            [
                'label'     => esc_html__( 'Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-posts-pagination .page-numbers.current' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'pagination_type!' => ['load_more', 'infinite_scroll'],
                ],
            ]
        );

        $this->add_control(
            'pagination_border_color_active',
            [
                'label'     => esc_html__( 'Border Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-posts-pagination .page-numbers.current' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'pagination_type!' => ['load_more', 'infinite_scroll'],
                ],
            ]
        );

        $this->add_control(
            'pagination_border_color_active_dark_mode',
            [
                'label'     => esc_html__( 'Border Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-posts-pagination .page-numbers.current' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'pagination_type!' => ['load_more', 'infinite_scroll'],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'      => 'pagination_link_box_shadow_active',
                'selector'  => '{{WRAPPER}} .rivax-posts-pagination .page-numbers.current',
                'condition' => [
                    'pagination_type!' => ['load_more', 'infinite_scroll'],
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'pagination_spacing',
            [
                'label'     => esc_html__( 'Space Between', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'separator' => 'before',
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-posts-pagination' => 'column-gap: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'pagination_type!' => ['load_more', 'infinite_scroll'],
                ],
            ]
        );

        $this->add_responsive_control(
            'pagination_item_width',
            [
                'label'     => esc_html__( 'Item Width', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 80,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-posts-pagination .page-numbers' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'pagination_type!' => ['load_more', 'infinite_scroll'],
                ],
            ]
        );

        $this->add_responsive_control(
            'pagination_item_height',
            [
                'label'     => esc_html__( 'Item Height', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 80,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-posts-pagination .page-numbers' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'pagination_type!' => ['load_more', 'infinite_scroll'],
                ],
            ]
        );

        $this->end_controls_section();
    }


    protected function register_carousel_controls() {

        $this->start_controls_section( 'section_carousel_settings', [
            'label' => esc_html__( 'Carousel Settings', 'syron' ) ,
            'tab'   => Controls_Manager::TAB_CONTENT,
            'condition' => [
                'layout' => 'carousel',
            ],
        ] );

        $this->add_control(
            'carousel_direction',
            [
                'label'       => esc_html__( 'Direction', 'syron' ),
                'type'        => Controls_Manager::SELECT,
                'default'     => 'horizontal',
                'options'     => [
                    'horizontal' => esc_html__( 'Horizontal', 'syron' ),
                    'vertical'   => esc_html__( 'Vertical', 'syron' ),
                ],
                'render_type'    => 'template',
            ]
        );

        $this->add_responsive_control(
            'carousel_vertical_height',
            [
                'label'       => esc_html__( 'Container Height', 'syron' ),
                'type'        => Controls_Manager::SLIDER,
                'range'       => [
                    'px' => [
                        'min'  => 100,
                        'max'  => 1200,
                        'step' => 10
                    ],
                ],
                'default'     => [
                    'size' => 300,
                ],
                'selectors'   => [
                    '{{WRAPPER}} .swiper' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition'   => [
                    'carousel_direction' => 'vertical',
                ],
            ]
        );

        $this->add_control(
            'carousel_effect',
            [
                'label'        => esc_html__( 'Effect', 'syron' ),
                'type'         => Controls_Manager::SELECT,
                'default'      => 'slide',
                'options'      => [
                    'slide'    => esc_html__( 'Slide', 'syron' ),
                    'fade'     => esc_html__( 'Fade', 'syron' ),
                ],
                'prefix_class' => 'rivax-carousel-effect-',
                'separator'    => 'before',
                'render_type'    => 'template',
            ]
        );


        $this->add_control(
            'carousel_autoplay',
            [
                'label'   => esc_html__( 'Autoplay', 'syron' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',

            ]
        );

        $this->add_control(
            'carousel_autoplay_speed',
            [
                'label'     => esc_html__( 'Autoplay Speed', 'syron' ),
                'type'      => Controls_Manager::NUMBER,
                'default'   => 4000,
                'step' => 100,
                'condition' => [
                    'carousel_autoplay' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'carousel_pauseonhover',
            [
                'label' => esc_html__( 'Pause on Hover', 'syron' ),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_responsive_control(
            'carousel_slides_to_scroll',
            [
                'type'           => Controls_Manager::SELECT,
                'label'          => esc_html__( 'Slides to Scroll', 'syron' ),
                'default'        => 1,
                'options'        => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'condition' => [
                    'carousel_effect!' => 'fade',
                ],
            ]
        );

        $this->add_control(
            'carousel_centered_slides',
            [
                'label'       => esc_html__( 'Center Slide', 'syron' ),
                'type'        => Controls_Manager::SWITCHER,
                'condition' => [
                    'carousel_effect!' => 'fade',
                ],
            ]
        );

        $this->add_control(
            'carousel_grab_cursor',
            [
                'label' => esc_html__( 'Grab Cursor', 'syron' ),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'carousel_loop',
            [
                'label'   => esc_html__( 'Loop', 'syron' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'carousel_auto_height',
            [
                'label'   => esc_html__( 'Auto Height', 'syron' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'carousel_speed',
            [
                'label'   => esc_html__( 'Animation Speed (ms)', 'syron' ),
                'type'    => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 500,
                ],
                'range'   => [
                    'px' => [
                        'min'  => 100,
                        'max'  => 5000,
                        'step' => 50,
                    ],
                ],
            ]
        );

        $this->add_control(
            'carousel_observer',
            [
                'label'       => esc_html__( 'Observer', 'syron' ),
                'description' => esc_html__( 'When you use carousel in any hidden place (in tabs, accordion etc) keep it yes.', 'syron' ),
                'type'        => Controls_Manager::SWITCHER,
            ]
        );

        $this->end_controls_section();
    }


    // $type = carousel | slider
    protected function register_carousel_nav_controls($type = 'carousel') {

        $condition = [];

        if($type == 'carousel') {
            $condition['layout'] = 'carousel'; // Post layout
        }

        $this->start_controls_section( 'section_carousel_navigation', [
            'label' => esc_html__( 'Navigation', 'syron' ) ,
            'tab'   => Controls_Manager::TAB_CONTENT,
            'condition' => $condition,
        ] );

        $this->add_control(
            'carousel_arrows',
            [
                'label'     => esc_html__( 'Arrows', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'carousel_arrows_icon',
            [
                'label'     => esc_html__( 'Icon', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'ri-right-arrow-1',
                'options'   => rivax_get_arrows_icons(),
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_next_label',
            [
                'label'       => esc_html__( 'Next Label', 'syron' ),
                'type'        => Controls_Manager::TEXT,
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_prev_label',
            [
                'label'       => esc_html__( 'Previous Label', 'syron' ),
                'type'        => Controls_Manager::TEXT,
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_position',
            [
                'label'     => esc_html__( 'Position', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'default',
                'options'   => [
                    'default'           => esc_html__( 'Default', 'syron' ),
                    'top'               => esc_html__( 'Top', 'syron' ),
                    'bottom'            => esc_html__( 'Bottom', 'syron' ),
                    'center'            => esc_html__( 'Center', 'syron' ),
                    'top-left'          => esc_html__( 'Top Left', 'syron' ),
                    'top-center'        => esc_html__( 'Top Center', 'syron' ),
                    'top-right'         => esc_html__( 'Top Right', 'syron' ),
                    'bottom-left'       => esc_html__( 'Bottom Left', 'syron' ),
                    'bottom-center'     => esc_html__( 'Bottom Center', 'syron' ),
                    'bottom-right'      => esc_html__( 'Bottom Right', 'syron' ),
                ],
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrow_show_on_hover',
            [
                'label'     => esc_html__( 'Show on Hover', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_control(
            'carousel_hide_arrow_mobile',
            [
                'label'     => esc_html__( 'Hide on Mobile', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );


        $this->add_control(
            'carousel_pagination',
            [
                'label'     => esc_html__( 'Pagination', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'carousel_pagination_type',
            [
                'label'        => esc_html__( 'Pagination Type', 'syron' ),
                'type'         => Controls_Manager::SELECT,
                'default'      => 'bullets',
                'options'      => [
                    'bullets'     => esc_html__( 'Bullets', 'syron' ),
                    'fraction' => esc_html__( 'Fraction', 'syron' ),
                ],
                'condition' => [
                    'carousel_pagination!' => '',
                ],
            ]
        );

        $this->add_control(
            'carousel_dynamic_bullets',
            [
                'label'     => esc_html__( 'Dynamic Bullets', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'bullets',
                ],
            ]
        );

        $this->add_control(
            'carousel_bullet_style',
            [
                'label'     => esc_html__( 'Style', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'style-default',
                'options'   => [
                    'style-default'     => esc_html__( 'Default', 'syron' ),
                    'style-1'           => esc_html__( 'Style 1', 'syron' ),
                    'style-2'           => esc_html__( 'Style 2', 'syron' ),
                    'style-3'           => esc_html__( 'Style 3', 'syron' ),
                    'style-4'           => esc_html__( 'Style 4', 'syron' ),
                    'style-5'           => esc_html__( 'Style 5', 'syron' ),
                ],
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'bullets',
                ],
            ]
        );

        $this->add_control(
            'carousel_pagination_position',
            [
                'label'     => esc_html__( 'Position', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'bottom-center',
                'options'   => [
                    'top-left'          => esc_html__( 'Top Left', 'syron' ),
                    'top-center'        => esc_html__( 'Top Center', 'syron' ),
                    'top-right'         => esc_html__( 'Top Right', 'syron' ),
                    'bottom-left'       => esc_html__( 'Bottom Left', 'syron' ),
                    'bottom-center'     => esc_html__( 'Bottom Center', 'syron' ),
                    'bottom-right'      => esc_html__( 'Bottom Right', 'syron' ),
                    'center-left'       => esc_html__( 'Center Left', 'syron' ),
                    'center-right'      => esc_html__( 'Center Right', 'syron' ),
                ],
                'condition' => [
                    'carousel_pagination!' => '',
                ],
            ]
        );

	    $this->add_control(
		    'carousel_pagination_hide_mobile',
		    [
			    'label'     => esc_html__( 'Hide on Mobile', 'syron' ),
			    'type'      => Controls_Manager::SWITCHER,
			    'condition' => [
				    'carousel_pagination!' => '',
			    ],
		    ]
	    );

        $this->end_controls_section();
    }



    // $type = carousel | slider
    protected function register_style_carousel_nav_controls($type = 'carousel') {

        $condition = [];

        if($type == 'carousel') {
            $condition['layout'] = 'carousel'; // Post layout
        }

        $this->start_controls_section(
            'section_carousel_navigation_style',
            [
                'label'      => esc_html__( 'Navigation', 'syron' ),
                'tab'        => Controls_Manager::TAB_STYLE,
                'condition' => $condition,
            ]
        );

        $this->add_control(
            'carousel_navigation_style_info',
            [
                'type'      => Controls_Manager::RAW_HTML,
                'raw'       => esc_html__( 'Navigation and Pagination are disabled from navigation setting.', 'syron' ),
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
                'condition' => [
                    'carousel_arrows' => '',
                    'carousel_pagination' => '',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_heading',
            [
                'label'     => esc_html__( 'Arrows', 'syron' ),
                'type'      => Controls_Manager::HEADING,
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'carousel_arrows_vertical_offset',
            [
                'label'     => esc_html__( 'Arrows Vertical Offset', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => -200,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel-nav-prev, {{WRAPPER}} .carousel-nav-next' => 'top: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'carousel_arrow_left_offset',
            [
                'label'     => esc_html__( 'Arrow Left Offset', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => -200,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel-nav-prev' => 'left: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'carousel_arrow_right_offset',
            [
                'label'     => esc_html__( 'Arrow Right Offset', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => -200,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel-nav-next' => 'right: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'carousel_arrows_label_typography',
                'label'     => esc_html__( 'Label Typography', 'syron' ),
                'selector'  => '{{WRAPPER}} .carousel-nav-prev-label, {{WRAPPER}} .carousel-nav-next-label',
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );


        $this->start_controls_tabs( 'tabs_carousel_arrows_style' );

        $this->start_controls_tab(
            'tabs_carousel_arrows_normal',
            [
                'label'     => esc_html__( 'Normal', 'syron' ),
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_color',
            [
                'label'     => esc_html__( 'Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .carousel-nav-prev, {{WRAPPER}} .carousel-nav-next' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_color_dark_mode',
            [
                'label'     => esc_html__( 'Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .carousel-nav-prev, html[scheme="dark"] {{WRAPPER}} .carousel-nav-next' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_background',
            [
                'label'     => esc_html__( 'Background', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .carousel-nav-prev, {{WRAPPER}} .carousel-nav-next' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .carousel-nav-prev, html[scheme="dark"] {{WRAPPER}} .carousel-nav-next' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'      => 'carousel_arrows_border',
                'selector'  => '{{WRAPPER}} .carousel-nav-prev, {{WRAPPER}} .carousel-nav-next',
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_control('carousel_arrows_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'carousel_arrows!' => '',
                    'carousel_arrows_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .carousel-nav-prev, html[scheme="dark"] {{WRAPPER}} .carousel-nav-next' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_responsive_control(
            'carousel_arrows_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'syron' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .carousel-nav-prev, {{WRAPPER}} .carousel-nav-next' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'  => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'carousel_arrows_padding',
            [
                'label'      => esc_html__( 'Padding', 'syron' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .carousel-nav-prev, {{WRAPPER}} .carousel-nav-next' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'  => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'carousel_arrows_size',
            [
                'label'     => esc_html__( 'Size', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel-nav-wrapper' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tabs_carousel_arrows_hover',
            [
                'label'     => esc_html__( 'Hover', 'syron' ),
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_hover_color',
            [
                'label'     => esc_html__( 'Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .carousel-nav-prev:hover, {{WRAPPER}} .carousel-nav-next:hover' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_hover_color_dark_mode',
            [
                'label'     => esc_html__( 'Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .carousel-nav-prev:hover, html[scheme="dark"] {{WRAPPER}} .carousel-nav-next:hover' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_hover_background',
            [
                'label'     => esc_html__( 'Background', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .carousel-nav-prev:hover, {{WRAPPER}} .carousel-nav-next:hover' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_hover_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .carousel-nav-prev:hover, html[scheme="dark"] {{WRAPPER}} .carousel-nav-next:hover' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_hover_border_color',
            [
                'label'     => esc_html__( 'Border Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .carousel-nav-prev:hover, {{WRAPPER}} .carousel-nav-next:hover' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'carousel_arrows_border_border!' => '',
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_hover_border_color_dark_mode',
            [
                'label'     => esc_html__( 'Border Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .carousel-nav-prev:hover, html[scheme="dark"] {{WRAPPER}} .carousel-nav-next:hover' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'carousel_arrows_border_border!' => '',
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->add_control(
            'hr_847456',
            [
                'type'      => Controls_Manager::DIVIDER,
                'condition' => [
                    'carousel_arrows!' => '',
                    'carousel_pagination!' => '',
                ],
            ]
        );

        $this->add_control(
            'carousel_bullets_heading',
            [
                'label'     => esc_html__( 'Bullets', 'syron' ),
                'type'      => Controls_Manager::HEADING,
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'bullets',
                ],
            ]
        );

        $this->add_responsive_control(
            'carousel_pagination_vertical_offset',
            [
                'label'     => esc_html__( 'Vertical Offset', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => -200,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel-pagination' => 'top: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'carousel_pagination!' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'carousel_pagination_horizontal_offset',
            [
                'label'     => esc_html__( 'Horizontal Offset', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => -200,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel-pagination' => 'left: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'carousel_pagination!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'carousel_pagination_background',
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .carousel-pagination',
                'condition' => [
                    'carousel_pagination!' => '',
                ],
            ]
        );

        $this->add_control(
            'heading_carousel_pagination_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
                'condition' => [
                    'carousel_pagination!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'carousel_pagination_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .carousel-pagination',
                'condition' => [
                    'carousel_pagination!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'      => 'carousel_pagination_border',
                'selector'  => '{{WRAPPER}} .carousel-pagination',
                'condition' => [
                    'carousel_pagination!' => '',
                ],
            ]
        );

        $this->add_control('carousel_pagination_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'carousel_pagination_border_border!' => '',
                    'carousel_pagination!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .carousel-pagination' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_responsive_control(
            'carousel_pagination_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'syron' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .carousel-pagination' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'  => [
                    'carousel_pagination!' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'carousel_pagination_padding',
            [
                'label'      => esc_html__( 'Padding', 'syron' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .carousel-pagination' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'  => [
                    'carousel_pagination!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'carousel_pagination_shadow',
                'selector' => '{{WRAPPER}} .carousel-pagination',
                'condition' => [
                    'carousel_pagination!' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'carousel_bullets_space_between',
            [
                'label'     => esc_html__( 'Space Between', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 5,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel-pagination-wrapper.type-bullets .carousel-pagination' => 'gap: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'bullets',
                ],
            ]
        );

        $this->start_controls_tabs( 'tabs_carousel_bullets_style' );

        $this->start_controls_tab(
            'tabs_carousel_bullets_normal',
            [
                'label'     => esc_html__( 'Normal', 'syron' ),
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'bullets',
                ],
            ]
        );

        $this->add_control(
            'carousel_bullets_color',
            [
                'label'     => esc_html__( 'Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-bullet' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'bullets',
                ],
            ]
        );

        $this->add_control(
            'carousel_bullets_color_dark_mode',
            [
                'label'     => esc_html__( 'Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .swiper-pagination-bullet' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'bullets',
                ],
            ]
        );

        $this->add_responsive_control(
            'carousel_bullets_width_size',
            [
                'label'     => esc_html__( 'Width(px)', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 1,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-bullet' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'bullets',
                ],
            ]
        );

        $this->add_responsive_control(
            'carousel_bullets_height_size',
            [
                'label'     => esc_html__( 'Height(px)', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 1,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-bullet' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'bullets',
                ],
            ]
        );

        $this->add_responsive_control(
            'carousel_bullets_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'syron'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .swiper-pagination-bullet' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'bullets',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'carousel_bullets_box_shadow',
                'selector' => '{{WRAPPER}} .swiper-pagination-bullet',
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'bullets',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tabs_carousel_bullets_active',
            [
                'label'     => esc_html__( 'Active', 'syron' ),
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'bullets',
                ],
            ]
        );

        $this->add_control(
            'carousel_active_bullet_color',
            [
                'label'     => esc_html__( 'Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-bullet-active' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'bullets',
                ],
            ]
        );

        $this->add_control(
            'carousel_active_bullet_color_dark_mode',
            [
                'label'     => esc_html__( 'Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .swiper-pagination-bullet-active' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'bullets',
                ],
            ]
        );

        $this->add_responsive_control(
            'carousel_active_bullet_width',
            [
                'label'     => esc_html__( 'Width(px)', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 1,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-bullet-active' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'bullets',
                ],
            ]
        );

        $this->add_responsive_control(
            'carousel_active_bullet_height',
            [
                'label'     => esc_html__( 'Height(px)', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 1,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-bullet-active' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'bullets',
                ],
            ]
        );

        $this->add_responsive_control(
            'carousel_active_bullet_radius',
            [
                'label'      => esc_html__('Border Radius', 'syron'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .swiper-pagination-bullet-active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'bullets',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'carousel_bullet_active_box_shadow',
                'selector' => '{{WRAPPER}} .swiper-pagination-bullet-active',
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'bullets',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();


        $this->add_control(
            'carousel_fraction_heading',
            [
                'label'     => esc_html__( 'Fraction', 'syron' ),
                'type'      => Controls_Manager::HEADING,
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'fraction',
                ],
            ]
        );

        $this->add_control(
            'carousel_fraction_color',
            [
                'label'     => esc_html__( 'Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-fraction' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'fraction',
                ],
            ]
        );

        $this->add_control(
            'carousel_fraction_color_dark_mode',
            [
                'label'     => esc_html__( 'Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .swiper-pagination-fraction' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'fraction',
                ],
            ]
        );

        $this->add_control(
            'carousel_active_fraction_color',
            [
                'label'     => esc_html__( 'Active Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-current' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'fraction',
                ],
            ]
        );

        $this->add_control(
            'carousel_active_fraction_color_dark_mode',
            [
                'label'     => esc_html__( 'Active Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .swiper-pagination-current' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'fraction',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'carousel_fraction_typography',
                'label'     => esc_html__( 'Typography', 'syron' ),
                'selector'  => '{{WRAPPER}} .swiper-pagination-fraction',
                'condition' => [
                    'carousel_pagination!' => '',
                    'carousel_pagination_type' => 'fraction',
                ],
            ]
        );

        $this->end_controls_section();
    }



    protected function register_slider_controls() {

        $this->start_controls_section( 'section_slider_settings', [
            'label' => esc_html__( 'Slider Settings', 'syron' ) ,
            'tab'   => Controls_Manager::TAB_CONTENT,
        ] );

        $this->add_control(
            'slider_autoplay',
            [
                'label'   => esc_html__( 'Autoplay', 'syron' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',

            ]
        );

        $this->add_control(
            'slider_autoplay_speed',
            [
                'label'     => esc_html__( 'Autoplay Speed', 'syron' ),
                'type'      => Controls_Manager::NUMBER,
                'default'   => 4000,
                'step' => 100,
                'condition' => [
                    'slider_autoplay' => 'yes',
                ],
            ]
        );


        $this->add_control(
            'slider_pauseonhover',
            [
                'label' => esc_html__( 'Pause on Hover', 'syron' ),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'slider_grab_cursor',
            [
                'label' => esc_html__( 'Grab Cursor', 'syron' ),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'slider_loop',
            [
                'label'   => esc_html__( 'Loop', 'syron' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'slider_speed',
            [
                'label'   => esc_html__( 'Animation Speed (ms)', 'syron' ),
                'type'    => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 1000,
                ],
                'range'   => [
                    'px' => [
                        'min'  => 500,
                        'max'  => 5000,
                        'step' => 100,
                    ],
                ],
            ]
        );

        $this->end_controls_section();
    }



	protected function register_author_controls() {

		$this->add_control('show_author', [
			'label' => esc_html__('Author', 'syron'),
			'type' => Controls_Manager::SWITCHER,
			'default' => 'yes',
			'separator' => 'before',
		]);

		$this->add_control('show_author_image', [
			'label' => esc_html__('Author Image', 'syron'),
			'type' => Controls_Manager::SWITCHER,
			'condition' => [
				'show_author' => 'yes',
			],
		]);

		$this->add_control('show_author_icon', [
			'label' => esc_html__('Author Icon', 'syron'),
			'type' => Controls_Manager::SWITCHER,
			'condition' => [
				'show_author' => 'yes',
			],
		]);

		$this->add_control('show_author_by', [
			'label' => esc_html__('Author By', 'syron'),
			'type' => Controls_Manager::SWITCHER,
			'condition' => [
				'show_author' => 'yes',
			],
		]);

		$this->add_control(
			'author_by_text',
			[
				'label'       => esc_html__( 'Author By Text', 'syron' ),
				'type'        => Controls_Manager::TEXT,
				'default'     =>  esc_html__( 'By', 'syron' ),
				'condition' => [
					'show_author' => 'yes',
					'show_author_by' => 'yes',
				],
			]
		);

	}



    protected function register_date_controls() {

        $this->add_control(
            'show_date',
            [
                'label'     => esc_html__( 'Date', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'default'   => 'yes',
                'separator' => 'before'
            ]
        );

	    $this->add_control(
		    'show_date_icon',
		    [
			    'label'     => esc_html__( 'Icon', 'syron' ),
			    'type'      => Controls_Manager::SWITCHER,
			    'condition' => [
				    'show_date' => 'yes'
			    ]
		    ]
	    );

        $this->add_control(
            'human_diff_time',
            [
                'label'     => esc_html__( 'Human Different Time', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'condition' => [
                    'show_date' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'show_time',
            [
                'label'     => esc_html__( 'Show Time', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'condition' => [
                    'human_diff_time' => '',
                    'show_date'       => 'yes'
                ]
            ]
        );
    }



	protected function register_comments_controls() {

		$this->add_control('show_comments', [
			'label' => esc_html__('Comments', 'syron'),
			'type' => Controls_Manager::SWITCHER,
			'separator' => 'before',
		]);

		$this->add_control('show_comments_icon', [
			'label' => esc_html__('Icon', 'syron'),
			'type' => Controls_Manager::SWITCHER,
			'condition' => [
				'show_comments' => 'yes',
			],
		]);

		$this->add_control('comments_just_count', [
			'label' => esc_html__('Just Show Count', 'syron'),
			'type' => Controls_Manager::SWITCHER,
			'condition' => [
				'show_comments' => 'yes',
			],
		]);

        $this->add_control('comments_hide_mobile', [
            'label' => esc_html__('Hide on Mobile', 'syron'),
            'type' => Controls_Manager::SWITCHER,
            'condition' => [
                'show_comments' => 'yes',
            ],
        ]);
	}


	protected function register_views_count_controls() {

		$this->add_control('show_views_count', [
			'label' => esc_html__('Views Count', 'syron'),
			'type' => Controls_Manager::SWITCHER,
			'separator' => 'before',
		]);

		$this->add_control('show_views_count_icon', [
			'label' => esc_html__('Icon', 'syron'),
			'type' => Controls_Manager::SWITCHER,
			'condition' => [
				'show_views_count' => 'yes',
			],
		]);

        $this->add_control('views_count_hide_mobile', [
            'label' => esc_html__('Hide on Mobile', 'syron'),
            'type' => Controls_Manager::SWITCHER,
            'condition' => [
                'show_views_count' => 'yes',
            ],
        ]);

		$this->add_control(
			'views_count_text',
			[
				'label'       => esc_html__( 'Text', 'syron' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__('Views', 'syron'),
				'condition'   => [
					'show_views_count' => 'yes',
				],
			]
		);
	}


	protected function register_reading_time_controls() {

		$this->add_control('show_reading_time', [
			'label' => esc_html__('Reading Time', 'syron'),
			'type' => Controls_Manager::SWITCHER,
			'separator' => 'before',
		]);

		$this->add_control('show_reading_time_icon', [
			'label' => esc_html__('Icon', 'syron'),
			'type' => Controls_Manager::SWITCHER,
			'condition' => [
				'show_reading_time' => 'yes',
			],
		]);

        $this->add_control('reading_time_hide_mobile', [
            'label' => esc_html__('Hide on Mobile', 'syron'),
            'type' => Controls_Manager::SWITCHER,
            'condition' => [
                'show_reading_time' => 'yes',
            ],
        ]);

		$this->add_control(
			'reading_time_text',
			[
				'label'       => esc_html__( 'Text', 'syron' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__('Min Read', 'syron'),
				'condition'   => [
					'show_reading_time' => 'yes',
				],
			]
		);

	}



    protected function register_terms_controls() {

        $this->add_control(
            'show_terms',
            [
                'label'     => esc_html__( 'Terms', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'separator' => 'before'
            ]
        );

		$terms = wp_list_pluck(get_taxonomies( ['public'=>true, 'show_ui'=>true], 'objects' ), "label", "name");
        unset($terms["product_cat"], $terms["product_tag"]);
		
        $this->add_control(
            'terms_taxonomy',
            [
                'label'         => esc_html__( 'Term Taxonomy', 'syron' ),
                'description'   => esc_html__( 'Select taxonomy related to your post type.', 'syron' ),
                'type'          => Controls_Manager::SELECT,
                'options'       => $terms,
                'condition' => [
                    'show_terms' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'term_limit',
            [
                'label'         => esc_html__( 'Max Terms', 'syron' ),
                'type'          => Controls_Manager::NUMBER,
                'default'       => 1,
                'min'           => 1,
                'condition' => [
                    'show_terms' => 'yes'
                ]
            ]
        );

	    $this->add_responsive_control(
		    'term_wrapper_align',
		    [
			    'label' => esc_html__( 'Alignment', 'syron' ),
			    'type' => Controls_Manager::CHOOSE,
			    'options' => [
				    'left' => [
					    'title' => esc_html__( 'Left', 'syron' ),
					    'icon' => 'eicon-text-align-left',
				    ],
				    'center' => [
					    'title' => esc_html__( 'Center', 'syron' ),
					    'icon' => 'eicon-text-align-center',
				    ],
				    'right' => [
					    'title' => esc_html__( 'Right', 'syron' ),
					    'icon' => 'eicon-text-align-right',
				    ]
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .terms-wrapper' => 'justify-content: {{VALUE}};'
			    ],
			    'condition' => [
				    'show_terms' => 'yes'
			    ]
		    ]
	    );

    }


    protected function register_style_terms_controls() {
        $this->start_controls_section('section_style_term',
            [
                'label' => esc_html__('Term', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_terms' => 'yes',
                ],
            ]);

	    $this->add_group_control(
		    Group_Control_Typography::get_type(),
		    [
			    'name' => 'term_typography',
			    'label' => esc_html__('Typography', 'syron'),
			    'selector' => '{{WRAPPER}} .term-item',
		    ]);


        $this->start_controls_tabs('tabs_term_style');
        $this->start_controls_tab('tab_term_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]);

        $this->add_control('term_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .term-item' => '--body-color: {{VALUE}};',
                ],
            ]);

        $this->add_control('term_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .term-item' => '--body-color: {{VALUE}};',
                ],
            ]);


        $this->end_controls_tab();

        $this->start_controls_tab('tab_term_hover',
            [
                'label' => esc_html__('Hover', 'syron'),
            ]);

        $this->add_control('term_hover_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .term-item:hover' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('term_hover_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .term-item:hover' => 'color: {{VALUE}};',
                ],
            ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }


    protected function register_title_controls($tag = 'h3') {

        $this->add_control(
            'title_tag',
            [
                'label'     => esc_html__( 'Title HTML Tag', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => $tag,
                'options'   => rivax_get_title_tags(),
                'separator' => 'before',
            ]
        );

        $this->add_control('title_limit_words',
            [
                'label'     => esc_html__( 'Limit Words', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control( 'title_limit_words_count',
            [
                'label'       => esc_html__( 'Max Words Count', 'syron' ),
                'type'        => Controls_Manager::NUMBER,
                'min'         => 5,
                'default'     => 10,
                'condition'   => [
                    'title_limit_words' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title_limit_words_more_text',
            [
                'label'       => esc_html__( 'More Text', 'syron' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => '...',
                'condition'   => [
                    'title_limit_words' => 'yes',
                ],
            ]
        );

	    
    }


    protected function register_style_title_controls() {
        $this->start_controls_section('section_style_title',
            [
                'label' => esc_html__('Title', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]);

        $this->add_control(
            'title_hover_style',
            [
                'label'   => esc_html__( 'Hover Style', 'syron' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'default',
                'options' => [
                    'default'          => esc_html__( 'Default', 'syron' ),
                    'underline-fix'    => esc_html__( 'Underline Fix', 'syron' ),
                    'middle-fix'       => esc_html__( 'Middle Fix', 'syron' ),
                    'underline'        => esc_html__( 'Underline', 'syron' ),
                    'middle-underline' => esc_html__( 'Middle Underline', 'syron' ),
                    'underline-in-out' => esc_html__( 'Underline In Out', 'syron' ),
                    'under-cover'      => esc_html__( 'Under Cover', 'syron' ),
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'title_shape_hover_background',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .post-wrapper .title a',
                'condition' => [
                    'title_hover_style' => ['underline', 'middle-underline', 'underline-in-out', 'under-cover']
                ]
            ]
        );

        $this->add_control(
            'heading_title_shape_hover_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
                'condition' => [
                    'title_hover_style' => ['underline', 'middle-underline', 'underline-in-out', 'under-cover']
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'title_shape_hover_bg_dark_mode',
                'types' => [ 'gradient' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .post-wrapper .title a',
                'condition' => [
                    'title_hover_style' => ['underline', 'middle-underline', 'underline-in-out', 'under-cover']
                ]
            ]
        );

        $this->add_control(
            'title_hover_underline_position',
            [
                'label'   => esc_html__( 'Underline Position', 'syron' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'top'          => esc_html__( 'Top', 'syron' ),
                    'center'       => esc_html__( 'Center', 'syron' ),
                    'bottom'       => esc_html__( 'Bottom', 'syron' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title a' => '--underline-position: {{VALUE}};',
                ],
                'condition' => [
                    'title_hover_style' => ['underline', 'middle-underline', 'underline-in-out', 'under-cover']
                ]
            ]
        );

        $this->add_control(
            'title_hover_underline_size',
            [
                'label'     => esc_html__( 'Underline Size', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title a' => '--underline-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'title_hover_style' => ['underline', 'middle-underline', 'underline-in-out', 'under-cover']
                ]
            ]
        );

        $this->add_control('title_decoration_hover_color',
            [
                'label' => esc_html__('Decoration Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title-animation-underline-fix:hover, {{WRAPPER}} .title-animation-middle-fix:hover' => 'text-decoration-color: {{VALUE}} !important;',
                ],
                'condition' => [
                    'title_hover_style' => ['underline-fix', 'middle-fix']
                ]
            ]);

        $this->add_control('title_decoration_hover_color_dark_mode',
            [
                'label' => esc_html__('Decoration Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .title-animation-underline-fix:hover, html[scheme="dark"] {{WRAPPER}} .title-animation-middle-fix:hover' => 'text-decoration-color: {{VALUE}} !important;',
                ],
                'condition' => [
                    'title_hover_style' => ['underline-fix', 'middle-fix']
                ]
            ]);


        $this->add_responsive_control('title_margin',
            [
                'label' => esc_html__('Margin', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_responsive_control('title_padding',
            [
                'label' => esc_html__('Padding', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__('Typography', 'syron'),
                'selector' => '{{WRAPPER}} .post-wrapper .title',
            ]);

        $this->add_control(
            'title_grid_tiles_sm_font_size',
            [
                'label'     => esc_html__( 'Small Titles Font Size', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'rem', 'em' ],
                'range'     => [
                    'px' => [
                        'min'  => 13,
                        'max'  => 50,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min'  => 1,
                        'max'  => 4,
                        'step' => 0.1,
                    ],
                    'em' => [
                        'min'  => 1,
                        'max'  => 4,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title' => '--sm-tiles-font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'layout'             => 'grid',
                    'grid_tiles_layout!' => '0',
                ],
            ]
        );

        $this->add_control(
            'title_grid_tiles_sm_line_height',
            [
                'label'     => esc_html__( 'Small Titles Line Height', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em' ],
                'range'     => [
                    'px' => [
                        'min'  => 13,
                        'max'  => 50,
                        'step' => 1,
                    ],
                    'em' => [
                        'min'  => 0.8,
                        'max'  => 4,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title' => '--sm-tiles-line-height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'layout'             => 'grid',
                    'grid_tiles_layout!' => '0',
                ],
            ]
        );


        $this->start_controls_tabs(
            'title_style_tabs'
        );

        $this->start_controls_tab(
            'title_style_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'syron' ),
            ]
        );

        $this->add_control('title_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title a' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .post-wrapper .title a' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_section_background',
            [
                'label' => esc_html__('Section Background', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title' => 'background-color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_section_bg_dark_mode',
            [
                'label' => esc_html__('Section Background - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .post-wrapper .title' => 'background-color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_background',
            [
                'label' => esc_html__('Background', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title a' => 'background-color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_bg_dark_mode',
            [
                'label' => esc_html__('Background - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .post-wrapper .title a' => 'background-color: {{VALUE}};',
                ],
            ]);

	    $this->add_group_control(
		    Group_Control_Text_Shadow::get_type(),
		    [
			    'name' => 'title_text_shadow',
			    'label' => esc_html__( 'Text Shadow', 'syron' ),
			    'selector' => '{{WRAPPER}} .post-wrapper .title a',
		    ]
	    );

	    $this->add_group_control(
		    Group_Control_Border::get_type(),
		    [
			    'name'     => 'title_border',
			    'selector' => '{{WRAPPER}} .post-wrapper .title',
		    ]
	    );

        $this->add_control('title_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'title_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .post-wrapper .title' => 'border-color: {{VALUE}};',
                ],
            ]);


        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_style_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'syron' ),
            ]
        );

        $this->add_control('title_hover_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title a:hover' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_hover_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .post-wrapper .title a:hover' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_section_hover_background',
            [
                'label' => esc_html__('Section Background', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title:hover' => 'background-color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_section_hover_bg_dark_mode',
            [
                'label' => esc_html__('Section Background - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .post-wrapper .title:hover' => 'background-color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_hover_background',
            [
                'label' => esc_html__('Background', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title a:hover' => 'background-color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_hover_bg_dark_mode',
            [
                'label' => esc_html__('Background - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .post-wrapper .title a:hover' => 'background-color: {{VALUE}};',
                ],
            ]);

	    $this->add_group_control(
		    Group_Control_Text_Shadow::get_type(),
		    [
			    'name' => 'title_hover_text_shadow',
			    'label' => esc_html__( 'Text Shadow', 'syron' ),
			    'selector' => '{{WRAPPER}} .post-wrapper .title a:hover',
		    ]
	    );


        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }


    protected function register_excerpt_controls() {

        $this->add_control('show_excerpt',
            [
                'label'     => esc_html__( 'Excerpt', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'separator' => 'before',
            ]
        );
		
		$this->add_control('excerpt_hide_on_mobile',
		    [
			    'label'     => esc_html__( 'Hide on Mobile', 'syron' ),
			    'type'      => Controls_Manager::SWITCHER,
				'condition'   => [
                    'show_excerpt' => 'yes',
                ],
		    ]
	    );

        $this->add_control( 'excerpt_length',
            [
                'label'       => esc_html__( 'Excerpt Limit Characters', 'syron' ),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 100,
                'min'         => 30,
                'step'        => 5,
                'condition'   => [
                    'show_excerpt' => 'yes',
                ],
            ]
        );

    }


    protected function register_style_excerpt_controls() {

        $this->start_controls_section('section_style_excerpt',
            [
                'label' => esc_html__('Excerpt', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_excerpt' => 'yes',
                ],
            ]);

        $this->add_control('excerpt_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .excerpt' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('excerpt_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .excerpt' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'excerpt_typography',
                'label' => esc_html__('Typography', 'syron'),
                'selector' => '{{WRAPPER}} .excerpt',
            ]);

        $this->add_responsive_control(
            'excerpt_margin',
            [
                'label'      => esc_html__( 'Margin', 'syron' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .excerpt' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );	    

        $this->end_controls_section();
    }



    protected function register_post_format_icon_controls() {

        $this->add_control('show_post_format_icon',
            [
                'label'     => esc_html__( 'Post Format Icon', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'separator' => 'before',
            ]
        );

    }


    protected function register_style_post_format_icon_controls() {

        $this->start_controls_section(
            'section_post_format_icon_style',
            [
                'label' => esc_html__( 'Post Format Icon', 'syron' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition'   => [
                    'show_post_format_icon' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'post_format_icon_position',
            [
                'label'     => esc_html__( 'Icon Position', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'top-left',
                'options'   => [
                    'top-left'          => esc_html__( 'Top Left', 'syron' ),
                    'top-center'        => esc_html__( 'Top Center', 'syron' ),
                    'top-right'         => esc_html__( 'Top Right', 'syron' ),
                    'center-center'     => esc_html__( 'Center Center', 'syron' ),
                ],
            ]
        );

        $this->add_responsive_control(
            'post_format_icon_margin',
            [
                'label'      => esc_html__( 'Margin', 'syron' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'selectors'  => [
                    '{{WRAPPER}} .post-format-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'post_format_icon_padding',
            [
                'label'     => esc_html__( 'Padding', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 2,
                        'max' => 20,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-format-icon' => 'padding: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'post_format_icon_font_size',
            [
                'label'     => esc_html__( 'Icon Size', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 10,
                        'max' => 80,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-format-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'post_format_icon_background',
            [
                'label'     => esc_html__( 'Background', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-format-icon' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'post_format_icon_color',
            [
                'label'     => esc_html__( 'Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-format-icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'post_format_icon_border',
                'selector' => '{{WRAPPER}} .post-format-icon',
            ]
        );

        $this->add_responsive_control(
            'post_format_icon_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'syron' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .post-format-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'post_format_icon_box_shadow',
                'selector' => '{{WRAPPER}} .post-format-icon',
            ]);


        $this->end_controls_section();

    }


    protected function register_style_post_date_controls() {

        $this->start_controls_section('section_style_date_in_out_image',
            [
                'label' => esc_html__('Date', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_date' => 'yes',
                    'meta_date_position' => ['inside-image', 'outside-image'],
                ]
            ]);


        $this->add_responsive_control('date_padding',
            [
                'label' => esc_html__('Padding', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .date-in-out-image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_responsive_control('date_margin',
            [
                'label' => esc_html__('Margin', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .date-in-out-image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);


        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'date_border',
                'selector' => '{{WRAPPER}} .date-in-out-image',
            ]
        );

        $this->add_control('date_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'date_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .date-in-out-image' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_responsive_control(
            'date_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'syron' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'selectors'  => [
                    '{{WRAPPER}} .date-in-out-image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'date_bg_from_term',
            [
                'label'     => esc_html__( 'Background From Term', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'selectors' => [
                    '{{WRAPPER}} .date-in-out-image' => 'background: var(--term-color, var(--accent-color));',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'date_background',
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .date-in-out-image',
            ]
        );

        $this->add_control(
            'heading_date_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'date_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .date-in-out-image',
            ]
        );

        $this->add_responsive_control('date_spacing',
            [
                'label' => esc_html__('Spacing', 'syron'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 5,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .date-in-out-image .day' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control('day_color',
            [
                'label' => esc_html__('Day Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .date-in-out-image .day' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('day_color_dark_mode',
            [
                'label' => esc_html__('Day Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .date-in-out-image .day' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('month_color',
            [
                'label' => esc_html__('Month Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .date-in-out-image .month' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('month_color_dark_mode',
            [
                'label' => esc_html__('Month Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .date-in-out-image .month' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'day_typography',
                'label' => esc_html__('Day Typography', 'syron'),
                'selector' => '{{WRAPPER}} .date-in-out-image .day',
            ]);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'month_typography',
                'label' => esc_html__('Month Typography', 'syron'),
                'selector' => '{{WRAPPER}} .date-in-out-image .month',
            ]);


        $this->end_controls_section();
    }


	protected function register_style_post_counter_controls() {

		$this->start_controls_section('section_style_post_counter',
			[
				'label' => esc_html__('Counter', 'syron'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_counter' => 'yes',
				]
			]);

		$this->add_control(
			'counter_with_zero',
			[
				'label'     => esc_html__( 'Counter With Zero', 'syron' ),
				'type'      => Controls_Manager::SWITCHER,
				'selectors' => [
					'{{WRAPPER}} .post-counter::before' => 'content: counter(post-num, decimal-leading-zero);',
				],
			]
		);

		$this->add_control(
			'post_counter_separator',
			[
				'label'   => esc_html__( 'Separator', 'syron' ),
				'type'    => Controls_Manager::SELECT,
				'default'    => 'none',
				'options' => [
					'none'          => esc_html__( 'None', 'syron' ),
					'dot'         => esc_html__( 'Dot', 'syron' ),
					'slash'    => esc_html__( 'Slash', 'syron' ),
				],
				'selectors_dictionary' => [
					'dot' => 'content: "."',
					'slash' => 'content: "/"',
				],
				'selectors' => [
					'{{WRAPPER}} .post-counter::after' => '{{VALUE}}',
				]
			]
		);


		$this->add_responsive_control(
			'post_counter_vertically',
			[
				'label' => esc_html__( 'Vertically', 'syron' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'flex-start' => [
						'title' => esc_html__( 'Start', 'syron' ),
						'icon' => 'eicon-align-start-v',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'syron' ),
						'icon' => 'eicon-justify-center-v',
					],
					'flex-end' => [
						'title' => esc_html__( 'End', 'syron' ),
						'icon' => 'eicon-align-end-v',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .post-counter-wrap' => 'align-self: {{VALUE}};',
				],
			]
		);


		$this->add_responsive_control('post_counter_padding',
			[
				'label' => esc_html__('Padding', 'syron'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .post-counter' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]);

		$this->add_responsive_control('post_counter_margin',
			[
				'label' => esc_html__('Margin', 'syron'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .post-counter' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]);


		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'post_counter_border',
				'selector' => '{{WRAPPER}} .post-counter',
			]
		);

        $this->add_control('post_counter_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'post_counter_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .post-counter' => 'border-color: {{VALUE}};',
                ],
            ]);

		$this->add_responsive_control(
			'post_counter_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'syron' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .post-counter' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'post_counter_width',
			[
				'label'     => esc_html__( 'Width', 'syron' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 150,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .post-counter' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'post_counter_height',
			[
				'label'     => esc_html__( 'Height', 'syron' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 150,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .post-counter' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'post_counter_box_shadow',
				'selector' => '{{WRAPPER}} .post-counter',
			]);

        $this->add_control(
            'counter_bg_from_term',
            [
                'label'     => esc_html__( 'Background From Term', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'selectors' => [
                    '{{WRAPPER}} .post-counter' => 'background: var(--term-color, var(--accent-color));',
                ],
            ]
        );

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'post_counter_background',
				'exclude' => [ 'image' ],
				'selector' => '{{WRAPPER}} .post-counter',
			]
		);

        $this->add_control(
            'heading_post_counter_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'post_counter_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .post-counter',
            ]
        );

		$this->add_control('post_counter_color',
			[
				'label' => esc_html__('Color', 'syron'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .post-counter' => 'color: {{VALUE}};',
				],
			]);

        $this->add_control('post_counter_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .post-counter' => 'color: {{VALUE}};',
                ],
            ]);


		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'post_counter_typography',
				'label' => esc_html__('Typography', 'syron'),
				'selector' => '{{WRAPPER}} .post-counter',
			]);


		$this->end_controls_section();

	}



    protected function register_style_meta_controls() {

        $this->start_controls_section('section_style_meta',
            [
                'label' => esc_html__('Meta', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]);

        $this->add_responsive_control(
            'meta_container_margin',
            [
                'label'      => esc_html__( 'Margin', 'syron' ),
                'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .meta-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'meta_author_image_size',
            [
                'label'     => esc_html__( 'Author Image Size', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 20,
                        'max' => 60,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-author-wrapper .author-image img' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'show_author' => 'yes',
                    'show_author_image' => 'yes',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'meta_typography',
                'label' => esc_html__('Typography', 'syron'),
                'selector' => '{{WRAPPER}} .meta-wrapper',
            ]);


        $this->start_controls_tabs( 'tabs_meta_style' );
        $this->start_controls_tab(
            'tabs_meta_normal',
            [
                'label'     => esc_html__( 'Normal', 'syron' ),
            ]
        );

        $this->add_control('meta_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .meta-wrapper' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('meta_author_color',
            [
                'label' => esc_html__('Author Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .author-wrapper a' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('meta_author_hover_color',
            [
                'label' => esc_html__('Author Hover Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .author-wrapper a:hover' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('meta_icon_color',
            [
                'label' => esc_html__('Icon Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .meta-wrapper i' => 'color: {{VALUE}};',
                ],
            ]);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tabs_meta_dark_mode',
            [
                'label'     => esc_html__( 'Dark Mode', 'syron' ),
            ]
        );

        $this->add_control('meta_color_dark_mode',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .meta-wrapper' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('meta_author_color_dark_mode',
            [
                'label' => esc_html__('Author Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .author-wrapper a' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('meta_author_hover_color_dark_mode',
            [
                'label' => esc_html__('Author Hover Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .author-wrapper a:hover' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('meta_icon_color_dark_mode',
            [
                'label' => esc_html__('Icon Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .meta-wrapper i' => 'color: {{VALUE}};',
                ],
            ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

    }



}

