<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class Rivax_Advanced_Heading_Widget extends Widget_Base {

    public function get_name() {
        return 'rivax-advanced-heading';
    }

    public function get_title() {
        return esc_html__('Advanced Heading', 'syron');
    }

    public function get_icon() {
        return 'eicon-heading';
    }

    protected function get_html_wrapper_class() {
        return $this->get_name() . '-widget';
    }

    public function get_categories() {
        return ['rivax-elements'];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__( 'General', 'syron' ),
            ]
        );

        $this->add_control(
            'heading_one',
            [
                'label' => esc_html__( 'Text One', 'syron' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
                'default' => esc_html__( 'Rivax Studio', 'syron' ),
                'placeholder' => esc_html__( 'Text One', 'syron' ),
            ]
        );

        $this->add_control(
            'heading_two',
            [
                'label' => esc_html__( 'Text Two', 'syron' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
                'default' => esc_html__( 'Creative', 'syron' ),
                'placeholder' => esc_html__( 'Text Two', 'syron' ),
            ]
        );

        $this->add_control(
            'heading_three',
            [
                'label' => esc_html__( 'Text three', 'syron' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
                'default' => esc_html__( 'Company', 'syron' ),
                'placeholder' => esc_html__( 'Text three', 'syron' ),
            ]
        );

        $this->add_control(
            'show_background_text',
            [
                'label' => esc_html__( 'Background Text', 'syron' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
            ]
        );

        $this->add_control(
            'background_text',
            [
                'label' => esc_html__( 'Text', 'syron' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Background', 'syron' ),
                'placeholder' => esc_html__( 'Background Text', 'syron' ),
                'condition' => [
                    'show_background_text' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => esc_html__( 'Link', 'syron' ),
                'type' => Controls_Manager::URL,
                'placeholder' => 'https://example.com/',
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__( 'HTML Tag', 'syron' ),
                'type' => Controls_Manager::CHOOSE,
                'default' => 'h2',
                'options' => [
                    'h1'  => [
                        'title' => 'H1',
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2'  => [
                        'title' => 'H2',
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3'  => [
                        'title' => 'H3',
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4'  => [
                        'title' => 'H4',
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5'  => [
                        'title' => 'H5',
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6'  => [
                        'title' => 'H6',
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'toggle' => false,
            ]
        );

        $this->add_responsive_control(
            'heading_align',
            [
                'label' => esc_html__( 'Alignment', 'syron' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'start' => [
                        'title' => esc_html__( 'Left', 'syron' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'syron' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'end' => [
                        'title' => esc_html__( 'Right', 'syron' ),
                        'icon' => 'eicon-text-align-right',
                    ]
                ],
                'prefix_class' => 'rivax-align-',
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-wrap' => 'text-align: {{VALUE}}; align-items: {{VALUE}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'heading_position',
            [
                'label' => esc_html__( 'Layout', 'syron' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'block' => [
                        'title' => esc_html__( 'Inline', 'syron' ),
                        'icon' => 'eicon-ellipsis-h',
                    ],
                    'flex' => [
                        'title' => esc_html__( 'Block', 'syron' ),
                        'icon' => 'eicon-menu-bar',
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-wrap' => 'display: {{VALUE}}',
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_style_heading',
            [
                'label' => esc_html__( 'Heading', 'syron' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'heading_typography',
                'selector' => '{{WRAPPER}} .rivax-advanced-heading-tag',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_text_one',
            [
                'label' => esc_html__( 'Text One', 'syron' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'text_one_padding',
            [
                'label' => esc_html__( 'Padding', 'syron' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-one' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'text_one_margin',
            [
                'label' => esc_html__( 'Margin', 'syron' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-one' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'text_one_border',
                'selector' => '{{WRAPPER}} .rivax-advanced-heading-one',
            ]
        );

        $this->add_control('text_one_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'text_one_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-advanced-heading-one' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_control(
            'text_one_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'syron' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-one' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'text_one_typography',
                'selector' => '{{WRAPPER}} .rivax-advanced-heading-one',
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'text_one_shadow',
                'label' => esc_html__( 'Text Shadow', 'syron' ),
                'selector' => '{{WRAPPER}} .rivax-advanced-heading-one',
            ]
        );

        $this->start_controls_tabs( 'tabs_text_one' );

        /**
         * Normal.
         */
        $this->start_controls_tab(
            'tab_text_one_normal',
            [
                'label' => esc_html__( 'Normal', 'syron' ),
            ]
        );

        $this->add_control(
            'text_one_color',
            [
                'label' => esc_html__( 'Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-one' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'text_one_background',
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .rivax-advanced-heading-one',
            ]
        );


        $this->end_controls_tab();

        /**
         * Dark Mode.
         */
        $this->start_controls_tab(
            'tab_text_one_dark_mode',
            [
                'label' => esc_html__( 'Dark Mode', 'syron' ),
            ]
        );

        $this->add_control(
            'text_one_color_dark_mode',
            [
                'label' => esc_html__( 'Color - Dark Mode', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-advanced-heading-one' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'text_one_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .rivax-advanced-heading-one',
            ]
        );


        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        $this->start_controls_section(
            'section_text_two',
            [
                'label' => esc_html__( 'Text Two', 'syron' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'text_two_padding',
            [
                'label' => esc_html__( 'Padding', 'syron' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-two' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'text_two_margin',
            [
                'label' => esc_html__( 'Margin', 'syron' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-two' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'text_two_border',
                'selector' => '{{WRAPPER}} .rivax-advanced-heading-two',
            ]
        );

        $this->add_control('text_two_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'text_two_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-advanced-heading-two' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_control(
            'text_two_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'syron' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-two' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'text_two_typography',
                'selector' => '{{WRAPPER}} .rivax-advanced-heading-two',
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'text_two_shadow',
                'label' => esc_html__( 'Text Shadow', 'syron' ),
                'selector' => '{{WRAPPER}} .rivax-advanced-heading-two',
            ]
        );

        $this->add_control(
            'text_two_gradient',
            [
                'label'     => esc_html__( 'Gradient Color', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
            ]
        );

        $this->start_controls_tabs( 'tabs_text_two' );

        /**
         * Normal.
         */
        $this->start_controls_tab(
            'tab_text_two_normal',
            [
                'label' => esc_html__( 'Normal', 'syron' ),
            ]
        );

        $this->add_control(
            'text_two_color',
            [
                'label' => esc_html__( 'Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'condition'	=> [
                    'text_two_gradient' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-two' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'text_two_background',
                'exclude' => [ 'image' ],
                'condition'	=> [
                    'text_two_gradient' => '',
                ],
                'selector' => '{{WRAPPER}} .rivax-advanced-heading-two',
            ]
        );

        $this->add_control(
            'text_two_gradient_01',
            [
                'label' => esc_html__('Color One', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition'	=> [
                    'text_two_gradient' => 'yes',
                ],

            ]
        );

        $this->add_control(
            'text_two_gradient_02',
            [
                'label' => esc_html__('Color Two', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition'	=> [
                    'text_two_gradient' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'text_two_gradient_03',
            [
                'label' => esc_html__('Color Three', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition'	=> [
                    'text_two_gradient' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-two.gradient-heading' => 'background-image: linear-gradient(90deg, {{text_two_gradient_01.VALUE}} 0%, {{text_two_gradient_02.VALUE}} 50%, {{text_two_gradient_03.VALUE}} 100%)',
                ],
            ]
        );

        $this->end_controls_tab();

        /**
         * Dark Mode.
         */
        $this->start_controls_tab(
            'tab_text_two_dark_mode',
            [
                'label' => esc_html__( 'Dark Mode', 'syron' ),
            ]
        );

        $this->add_control(
            'text_two_color_dark_mode',
            [
                'label' => esc_html__( 'Color - Dark Mode', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'condition'	=> [
                    'text_two_gradient' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-advanced-heading-two' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'text_two_bg_dark_mode',
                'exclude' => [ 'image' ],
                'condition'	=> [
                    'text_two_gradient' => '',
                ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .rivax-advanced-heading-two',
            ]
        );

        $this->add_control(
            'text_two_gradient_01_dark_mode',
            [
                'label' => esc_html__('Color One', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition'	=> [
                    'text_two_gradient' => 'yes',
                ],

            ]
        );

        $this->add_control(
            'text_two_gradient_02_dark_mode',
            [
                'label' => esc_html__('Color Two', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition'	=> [
                    'text_two_gradient' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'text_two_gradient_03_dark_mode',
            [
                'label' => esc_html__('Color Three', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition'	=> [
                    'text_two_gradient' => 'yes',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-advanced-heading-two.gradient-heading' => 'background-image: linear-gradient(90deg, {{text_two_gradient_01_dark_mode.VALUE}} 0%, {{text_two_gradient_02_dark_mode.VALUE}} 50%, {{text_two_gradient_03_dark_mode.VALUE}} 100%)',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        $this->start_controls_section(
            'section_text_three',
            [
                'label' => esc_html__( 'Text Three', 'syron' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'text_three_padding',
            [
                'label' => esc_html__( 'Padding', 'syron' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-three' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'text_three_margin',
            [
                'label' => esc_html__( 'Margin', 'syron' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-three' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'text_three_border',
                'selector' => '{{WRAPPER}} .rivax-advanced-heading-three',
            ]
        );

        $this->add_control('text_three_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'text_three_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-advanced-heading-three' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_control(
            'text_three_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'syron' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-three' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'text_three_typography',
                'selector' => '{{WRAPPER}} .rivax-advanced-heading-three',
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'text_three_shadow',
                'label' => esc_html__( 'Text Shadow', 'syron' ),
                'selector' => '{{WRAPPER}} .rivax-advanced-heading-three',
            ]
        );

        $this->start_controls_tabs( 'tabs_text_three' );

        /**
         * Normal.
         */
        $this->start_controls_tab(
            'tab_text_three_normal',
            [
                'label' => esc_html__( 'Normal', 'syron' ),
            ]
        );

        $this->add_control(
            'text_three_color',
            [
                'label' => esc_html__( 'Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-three' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'text_three_background',
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .rivax-advanced-heading-three',
            ]
        );


        $this->end_controls_tab();

        /**
         * Dark Mode.
         */
        $this->start_controls_tab(
            'tab_text_three_dark_mode',
            [
                'label' => esc_html__( 'Dark Mode', 'syron' ),
            ]
        );

        $this->add_control(
            'text_three_color_dark_mode',
            [
                'label' => esc_html__( 'Color - Dark Mode', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-advanced-heading-three' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'text_three_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .rivax-advanced-heading-three',
            ]
        );


        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        $this->start_controls_section(
            'section_style_border',
            [
                'label' => esc_html__( 'Border', 'syron' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'border_width',
            [
                'label' => esc_html__( 'Width', 'syron' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-border' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'border_height',
            [
                'label' => esc_html__( 'Height', 'syron' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-border:after' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'border_bg',
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .rivax-advanced-heading-border:after',
            ]
        );

        $this->add_control(
            'heading_border_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'border_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .rivax-advanced-heading-border:after',
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__( 'Border radius', 'syron' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-border:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
            ]
        );

        $this->add_control(
            'border_offset_toggle',
            [
                'label' => esc_html__( 'Offset', 'syron' ),
                'type' => Controls_Manager::POPOVER_TOGGLE,
            ]
        );

        $this->start_popover();

        $this->add_responsive_control(
            'border_horizontal_position',
            [
                'label' => esc_html__( 'Horizontal Position', 'syron' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => -200,
                        'max' => 200,
                    ],
                ],
                'condition' => [
                    'border_offset_toggle' => 'yes'
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-border:after' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'border_vertical_position',
            [
                'label' => esc_html__( 'Vertical Position', 'syron' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => -50,
                        'max' => 200,
                    ],
                ],
                'condition' => [
                    'border_offset_toggle' => 'yes'
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-border:after' => 'bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_popover();

        $this->end_controls_section();


        $this->start_controls_section(
            'section_style_background',
            [
                'label' => esc_html__( 'Background Text', 'syron' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_background_text' => 'yes',
                ],
            ]
        );


        $this->add_control(
            'background_text_color',
            [
                'label' => esc_html__( 'Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-wrap:before' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'background_text_color_dark_mode',
            [
                'label' => esc_html__( 'Color - Dark Mode', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-advanced-heading-wrap:before' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'background_text_typography',
                'selector' => '{{WRAPPER}} .rivax-advanced-heading-wrap:before',
            ]
        );

        $this->add_control(
            'background_offset_toggle',
            [
                'label' => esc_html__( 'Offset', 'syron' ),
                'type' => Controls_Manager::POPOVER_TOGGLE,
            ]
        );

        $this->start_popover();

        $this->add_responsive_control(
            'background_horizontal_position',
            [
                'label' => esc_html__( 'Horizontal Position', 'syron' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'default' => [
                    'unit' => '%',
                ],
                'range' => [
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'condition' => [
                    'background_offset_toggle' => 'yes'
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-wrap:before' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'background_vertical_position',
            [
                'label' => esc_html__( 'Vertical Position', 'syron' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'default' => [
                    'unit' => '%',
                ],
                'range' => [
                    '%' => [
                        'min' => -100,
                        'max' => 200,
                    ],
                ],
                'condition' => [
                    'background_offset_toggle' => 'yes'
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-advanced-heading-wrap:before' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_popover();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $widget_path_name = str_replace('rivax-', '', $this->get_name() );
        include RIVAX_THEME_DIR . '/elementor/templates/' . $widget_path_name . '/' . $widget_path_name . '.php';
    }

}