<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class Rivax_Category_Accordion_Widget extends Widget_Base {

    public function get_name() {
        return 'rivax-category-accordion';
    }

    public function get_title() {
        return esc_html__('Category Accordion', 'syron');
    }

    public function get_icon() {
        return 'eicon-info-box';
    }

    protected function get_html_wrapper_class() {
        return $this->get_name() . '-widget';
    }

    public function get_categories() {
        return ['rivax-elements'];
    }



    protected function register_controls() {

        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__( 'Layout', 'syron' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout',
            [
                'label'              => esc_html__( 'Layout', 'syron' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'horizontal' => esc_html__( 'Horizontal', 'syron' ),
                    'vertical' => esc_html__( 'Vertical', 'syron' ),
                ],
                'default'   => 'horizontal',
            ]
        );

        $this->add_responsive_control(
            'gap',
            [
                'label'     => esc_html__( 'Gap', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'default'   => [
                    'size' => '20',
                ],
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-categories-accordion' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'height',
            [
                'label'     => esc_html__( 'Height', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 200,
                        'max' => 800,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-categories-accordion.layout-horizontal .image-wrapper' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .rivax-categories-accordion.layout-vertical' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_categories',
            [
                'label' => esc_html__( 'Categories', 'syron' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $categories_list = get_terms(['taxonomy' => 'category', 'fields' => 'id=>name']);


        $repeater = new Repeater();

        $repeater->add_control(
            'category',
            [
                'label'         => esc_html__( 'Category', 'syron' ),
                'type'          => Controls_Manager::SELECT,
                'options'       => $categories_list,

            ]
        );

        $repeater->add_control(
            'category_image',
            [
                'label' => esc_html__( 'Image', 'syron' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );


        $this->add_control(
            'category_items',
            [
                'label' => esc_html__( 'Category Items', 'syron' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'prevent_empty' => false,
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'section_settings',
            [
                'label' => esc_html__( 'Settings', 'syron' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'open_link_new_tab',
            [
                'label'     => esc_html__( 'Open Link In New Tab', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'disable_grow',
            [
                'label'     => esc_html__( 'Disable Item Grow', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'selectors' => [
                    '{{WRAPPER}} .cat-item' => 'flex-grow: 1 !important; flex-basis: 200px !important;',
                ],
            ]
        );

        $this->add_control(
            'image_animation',
            [
                'label'     => esc_html__( 'Image Animation', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

	    $this->add_group_control(
		    Group_Control_Image_Size::get_type(),
		    [
			    'name' => 'thumbnail',
			    'exclude' => ['custom'],
			    'default' => 'rivax-small-square',
		    ]
	    );

        $this->add_control(
            'show_count',
            [
                'label'     => esc_html__( 'Show Posts Count', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'category_count_text',
            [
                'label'     => esc_html__( 'Count Text', 'syron' ),
                'type'      => Controls_Manager::TEXT,
                'default' => esc_html__( ' Posts' , 'syron' ),
                'condition' => [
                    'show_count' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();


	    $this->start_controls_section('section_style_image',
		    [
			    'label' => esc_html__('Image', 'syron'),
			    'tab' => Controls_Manager::TAB_STYLE,
		    ]
	    );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'image_border',
                'selector' => '{{WRAPPER}} .cat-item',
            ]);

        $this->add_responsive_control('image_border_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .cat-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_responsive_control('container_border_radius',
            [
                'label' => esc_html__('Container Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-categories-accordion' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'image_box_shadow',
                'selector' => '{{WRAPPER}} .cat-item',
            ]);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'image_overlay_color',
                'label' => esc_html__('Overlay Color', 'syron'),
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .image-wrapper::after',
            ]
        );

        $this->add_control(
            'image_overlay_opacity',
            [
                'label'     => esc_html__( 'Overlay Opacity', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 1,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .image-wrapper::after' => 'opacity: {{SIZE}};',
                ],
            ]
        );

	    $this->end_controls_section();


        $this->start_controls_section('section_style_content',
            [
                'label' => esc_html__('Content', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]);

        $this->add_control(
            'heading_title',
            [
                'label'     => esc_html__( 'Title', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_responsive_control('title_padding',
            [
                'label' => esc_html__('Padding', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .content-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_control('title_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .content-wrapper' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .content-wrapper' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__('Typography', 'syron'),
                'selector' => '{{WRAPPER}} .title-wrapper h5',
            ]);

        $this->add_control(
            'heading_count',
            [
                'label'     => esc_html__( 'Count', 'syron' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'count_typography',
                'label' => esc_html__('Typography', 'syron'),
                'selector' => '{{WRAPPER}} .count',
            ]);


        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $widget_path_name = str_replace('rivax-', '', $this->get_name() );
        include RIVAX_THEME_DIR . '/elementor/templates/' . $widget_path_name . '/' . $widget_path_name . '.php';
    }

}